/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.simulator;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import jmri.Disposable;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.simulator.CbusDummyCS;
import jmri.jmrix.can.cbus.simulator.CbusDummyNode;
import jmri.jmrix.can.cbus.simulator.CbusEventResponder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusSimulator
implements Disposable {
    private final CanSystemConnectionMemo memo;
    public ArrayList<CbusDummyCS> _csArr;
    public ArrayList<CbusDummyNode> _ndArr;
    public ArrayList<CbusEventResponder> _evResponseArr;
    private static final Logger log = LoggerFactory.getLogger(CbusSimulator.class);

    public CbusSimulator(@Nonnull CanSystemConnectionMemo sysmemo) {
        this.memo = sysmemo;
        this._csArr = new ArrayList();
        this._ndArr = new ArrayList();
        this._evResponseArr = new ArrayList();
        this.init();
    }

    public final void init() {
        log.info("Starting CBUS Network Simulation Tools");
        this._csArr.add(new CbusDummyCS(this.memo));
        this._evResponseArr.add(new CbusEventResponder(this.memo));
    }

    public int getNumCS() {
        return this._csArr.size();
    }

    public int getNumNd() {
        return this._ndArr.size();
    }

    public int getNumEv() {
        return this._evResponseArr.size();
    }

    public CbusDummyCS getCS(int id) {
        return this._csArr.get(id);
    }

    public CbusDummyNode getNd(int id) {
        return this._ndArr.get(id);
    }

    public void addNode(CbusDummyNode nd) {
        this._ndArr.add(nd);
    }

    public void removeNode(CbusDummyNode nd) {
        this._ndArr.remove(nd);
    }

    public CbusEventResponder getEv(int id) {
        return this._evResponseArr.get(id);
    }

    public CbusDummyCS getNewCS() {
        CbusDummyCS newcs = new CbusDummyCS(this.memo);
        this._csArr.add(newcs);
        return newcs;
    }

    public CbusEventResponder getNewEv() {
        CbusEventResponder newcs = new CbusEventResponder(this.memo);
        this._evResponseArr.add(newcs);
        return newcs;
    }

    @Override
    public void dispose() {
        log.info("Stopping {} Simulations", (Object)(this._csArr.size() + this._ndArr.size() + this._evResponseArr.size()));
        for (CbusDummyCS cbusDummyCS : this._csArr) {
            cbusDummyCS.dispose();
        }
        this._csArr.clear();
        for (CbusDummyNode cbusDummyNode : this._ndArr) {
            cbusDummyNode.dispose();
        }
        this._ndArr.clear();
        for (CbusEventResponder cbusEventResponder : this._evResponseArr) {
            cbusEventResponder.dispose();
        }
        this._evResponseArr.clear();
    }
}

