/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing;

import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import jmri.InstanceManager;
import jmri.LightManager;
import jmri.NamedBean;
import jmri.ProvidingManager;
import jmri.SensorManager;
import jmri.TurnoutManager;
import jmri.configurexml.ShutdownPreferences;
import jmri.jmrix.can.cbus.CbusAddress;
import jmri.jmrix.can.cbus.CbusMessage;
import jmri.jmrix.can.cbus.CbusNameService;
import jmri.jmrix.can.cbus.swing.Bundle;
import jmri.jmrix.can.swing.CanPanel;
import jmri.util.swing.JmriJOptionPane;

public class CbusCreateBeanPane
extends JPanel {
    private final CanPanel _mainPane;
    private JLabel beanLabel;
    private JPanel editPanel;
    private JTextField beanUsername;
    private final CbusNameService nameservice;
    private NamedBean bean;
    private JButton editUserNameButton;
    protected CbTransferHandler[] transferArray;
    private boolean showReminder = true;
    private final boolean checkEnabled = InstanceManager.getDefault(ShutdownPreferences.class).isStoreCheckEnabled();

    public CbusCreateBeanPane(CanPanel mainPane) {
        this._mainPane = mainPane;
        this.nameservice = new CbusNameService(mainPane.getMemo());
        this.init();
    }

    private void init() {
        this.transferArray = new CbTransferHandler[3];
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("CreateNew")));
        this.add(this.getNewDragPanel());
        this.add(this.getEditPane());
    }

    private JPanel getNewDragPanel() {
        JPanel dragContainer = new JPanel();
        dragContainer.setToolTipText(Bundle.getMessage("DragHereForNew"));
        dragContainer.setLayout(new BoxLayout(dragContainer, 0));
        for (int i = 0; i < 3; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html><h2>").append(this.getManagerByIndex(i).getBeanTypeHandled()).append("</h2></html>");
            JLabel newBealLabel = new JLabel(sb.toString());
            newBealLabel.setBorder(BorderFactory.createEtchedBorder());
            newBealLabel.setHorizontalAlignment(0);
            this.transferArray[i] = new CbTransferHandler();
            newBealLabel.setTransferHandler(this.transferArray[i]);
            dragContainer.add(newBealLabel);
        }
        return dragContainer;
    }

    private JPanel getEditPane() {
        this.editPanel = new JPanel();
        this.editPanel.setLayout(new BoxLayout(this.editPanel, 0));
        this.editPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("TslDetails")));
        this.beanUsername = new JTextField(20);
        this.beanUsername.setDropTarget(null);
        this.beanUsername.setMinimumSize(new Dimension(60, 16));
        this.beanLabel = new JLabel();
        this.editUserNameButton = new JButton(Bundle.getMessage("EditUserName"));
        this.editUserNameButton.setToolTipText(Bundle.getMessage("EditUNameTip"));
        this.editUserNameButton.addActionListener(e -> {
            String newUname = this.beanUsername.getText();
            this.bean.setUserName(newUname);
            this.showSaveReminder();
        });
        this.setEditPaneActive(false);
        this.editPanel.add(this.beanLabel);
        this.editPanel.add(this.beanUsername);
        this.editPanel.add(this.editUserNameButton);
        return this.editPanel;
    }

    private void setEditPaneActive(boolean enabled) {
        this.editPanel.setEnabled(enabled);
        this.beanUsername.setEnabled(enabled);
        this.editUserNameButton.setEnabled(enabled);
    }

    private ProvidingManager<?> classMgrInString(String dropLocation) {
        for (int i = 0; i < 3; ++i) {
            if (!dropLocation.contains(this.getManagerByIndex(i).getBeanTypeHandled())) continue;
            return this.getManagerByIndex(i);
        }
        throw new IllegalArgumentException("Unable to get Bean Type");
    }

    private ProvidingManager<?> getManagerByIndex(int index) {
        switch (index) {
            case 0: {
                return this._mainPane.getMemo().get(TurnoutManager.class);
            }
            case 1: {
                return this._mainPane.getMemo().get(SensorManager.class);
            }
            case 2: {
                return this._mainPane.getMemo().get(LightManager.class);
            }
        }
        throw new IllegalArgumentException("Unable to get Manager from Index" + index);
    }

    private void resetBeanText(NamedBean bean, boolean tableChanged, int nn, int en) {
        this.beanLabel.setText(bean.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME));
        this.editPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.nameservice.getEventNodeString(nn, en)));
        this.beanUsername.setText(bean.getUserName());
        if (tableChanged) {
            this.showSaveReminder();
        }
    }

    private void showSaveReminder() {
        if (this.showReminder && !this.checkEnabled) {
            JCheckBox checkbox = new JCheckBox(Bundle.getMessage("HideFurtherDialog"));
            Object[] params = new Object[]{Bundle.getMessage("SavePanelReminder"), checkbox};
            JmriJOptionPane.showMessageDialog(this._mainPane, params, Bundle.getMessage("ReminderTitle"), 1);
            this.showReminder = !checkbox.isSelected();
        }
    }

    protected class CbTransferHandler
    extends TransferHandler {
        protected CbTransferHandler() {
        }

        @Override
        public boolean canImport(JComponent c, DataFlavor[] transferFlavors) {
            for (DataFlavor flavor : transferFlavors) {
                if (!DataFlavor.stringFlavor.equals(flavor)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean importData(JComponent c, Transferable t) {
            if (this.canImport(c, t.getTransferDataFlavors())) {
                ProvidingManager<?> mgrClass;
                String validatedAddr;
                try {
                    validatedAddr = CbusAddress.validateSysName((String)t.getTransferData(DataFlavor.stringFlavor));
                    mgrClass = CbusCreateBeanPane.this.classMgrInString(((JLabel)c).getText());
                }
                catch (UnsupportedFlavorException | IOException | ClassCastException | IllegalArgumentException e) {
                    return false;
                }
                int nn = CbusMessage.getNodeNumber(new CbusAddress(validatedAddr).makeMessage(0));
                int en = CbusMessage.getEvent(new CbusAddress(validatedAddr).makeMessage(0));
                boolean dirty = false;
                CbusCreateBeanPane.this.bean = mgrClass.getBySystemName(validatedAddr);
                if (CbusCreateBeanPane.this.bean == null) {
                    dirty = true;
                    CbusCreateBeanPane.this.bean = mgrClass.provide(validatedAddr);
                    CbusCreateBeanPane.this.bean.setUserName(CbusCreateBeanPane.this.nameservice.getEventName(nn, en));
                }
                CbusCreateBeanPane.this.setEditPaneActive(true);
                CbusCreateBeanPane.this.resetBeanText(CbusCreateBeanPane.this.bean, dirty, nn, en);
                return true;
            }
            return false;
        }
    }
}

