/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrix.can.cbus.swing.Bundle;
import jmri.jmrix.can.cbus.swing.eventrequestmonitor.CbusEventRequestTablePane;
import jmri.jmrix.can.cbus.swing.eventtable.CbusEventTablePane;
import jmri.util.swing.JSpinnerUtil;

public class CbusNewEventPane
extends JPanel {
    private JSpinner newnodenumberSpinner;
    private JSpinner newevnumberSpinner;
    private JButton newevbutton;
    private final CbusEventTablePane _evPanel;
    private final CbusEventRequestTablePane _evReqPanel;
    private UserPreferencesManager p;
    private static final String EVENTNUM_PREF = "EventNum";
    private static final String NODENUM_PREF = "NodeNum";

    public CbusNewEventPane(CbusEventTablePane evPanel) {
        this._evPanel = evPanel;
        this._evReqPanel = null;
        this.init();
    }

    public CbusNewEventPane(CbusEventRequestTablePane evReqPanel) {
        this._evPanel = null;
        this._evReqPanel = evReqPanel;
        this.init();
    }

    final void init() {
        Object en;
        this.p = InstanceManager.getDefault(UserPreferencesManager.class);
        int nodenum = 0;
        int eventnum = 1;
        Object nn = this.p.getProperty(this.getClass().getName(), NODENUM_PREF);
        if (nn != null) {
            nodenum = (Integer)nn;
        }
        if ((en = this.p.getProperty(this.getClass().getName(), EVENTNUM_PREF)) != null) {
            eventnum = (Integer)en;
        }
        this.newnodenumberSpinner = new JSpinner(new SpinnerNumberModel(nodenum, 0, 65535, 1));
        this.newevnumberSpinner = new JSpinner(new SpinnerNumberModel(eventnum, 0, 65535, 1));
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("NewEvent")));
        this.newevbutton = new JButton(Bundle.getMessage("NewEvent"));
        this.newevbutton.addActionListener(e -> this.newEvent());
        this.add(this.newSpinnerPanel(this.newnodenumberSpinner, Bundle.getMessage("CbusNode"), Bundle.getMessage("NewNodeTip")));
        this.add(this.newSpinnerPanel(this.newevnumberSpinner, Bundle.getMessage("CbusEvent"), null));
        this.add(this.newevbutton);
    }

    private JPanel newSpinnerPanel(JSpinner spinner, String label, String tip) {
        JPanel newnode = new JPanel();
        newnode.add(new JLabel(label));
        JSpinnerUtil.setCommitsOnValidEdit(spinner, true);
        spinner.addChangeListener(e -> this.eventChanged());
        newnode.add(spinner);
        newnode.setToolTipText(tip);
        spinner.setToolTipText(tip);
        return newnode;
    }

    private void eventChanged() {
        if (this._evPanel != null) {
            this._evPanel.cbEvTable.tableChanged(null);
        } else if (this._evReqPanel != null) {
            this._evReqPanel.tableChanged(null);
        }
        this.p.setProperty(this.getClass().getName(), NODENUM_PREF, this.newnodenumberSpinner.getValue());
        this.p.setProperty(this.getClass().getName(), EVENTNUM_PREF, this.newevnumberSpinner.getValue());
    }

    public void setNewButtonActive(boolean newState) {
        this.newevbutton.setEnabled(newState);
    }

    public int getNn() {
        return (Integer)this.newnodenumberSpinner.getValue();
    }

    public int getEn() {
        return (Integer)this.newevnumberSpinner.getValue();
    }

    private void newEvent() {
        if (this._evPanel != null) {
            this._evPanel.cbEvTable.addEvent(this.getNn(), this.getEn());
        } else if (this._evReqPanel != null) {
            this._evReqPanel.addEvent(this.getNn(), this.getEn());
        }
    }
}

