/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing;

import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceMotionListener;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.CbusEvent;
import jmri.jmrix.can.cbus.CbusNameService;
import jmri.jmrix.can.cbus.eventtable.CbusEventTableDataModel;
import jmri.jmrix.can.cbus.node.CbusNodeEventTableDataModel;
import jmri.util.TimerUtil;

public class CbusTableRowEventDnDHandler
extends TransferHandler
implements DragSourceMotionListener {
    private int nn;
    private int en;
    private JLabel tempLabel;
    private JFrame frame;
    private final CbusNameService nameService;
    private TimerTask showFrameTimerTask;
    private DragSource source;

    public CbusTableRowEventDnDHandler(CanSystemConnectionMemo memo, JTable table) {
        this.nameService = new CbusNameService(memo);
        this.initFrame();
    }

    final void initFrame() {
        this.tempLabel = new JLabel();
        this.frame = new JFrame();
        this.frame.setUndecorated(true);
        this.frame.add(this.tempLabel);
        this.frame.setFocusableWindowState(false);
        this.source = DragSource.getDefaultDragSource();
        this.source.addDragSourceMotionListener(this);
    }

    @Override
    public void dragMouseMoved(DragSourceDragEvent e) {
        this.mouseMoved(e.getX(), e.getY());
    }

    protected void mouseMoved(int x, int y) {
        this.clearFrameTimeout();
        if (this.nn < 0 || this.en < 0) {
            return;
        }
        this.tempLabel.setText(this.nameService.getEventNodeString(this.nn, this.en));
        this.frame.repaint();
        this.frame.pack();
        this.frame.setLocation(x + 20, y + 15);
        this.frame.setVisible(true);
        this.frame.toFront();
        this.setFrameTimeout();
    }

    private void clearFrameTimeout() {
        if (this.showFrameTimerTask != null) {
            this.showFrameTimerTask.cancel();
            this.showFrameTimerTask = null;
            this.frame.setVisible(false);
        }
    }

    private void setFrameTimeout() {
        this.showFrameTimerTask = new TimerTask(){

            @Override
            public void run() {
                CbusTableRowEventDnDHandler.this.showFrameTimerTask = null;
                CbusTableRowEventDnDHandler.this.frame.setVisible(false);
            }
        };
        TimerUtil.schedule(this.showFrameTimerTask, 650L);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    public Transferable createTransferable(JComponent c) {
        this.nn = -1;
        this.en = -1;
        if (!(c instanceof JTable)) {
            return null;
        }
        this.setNnEn((JTable)c);
        if (this.nn < 0 || this.en < 0) {
            return null;
        }
        return new StringSelection(CbusEvent.getJmriString(this.nn, this.en));
    }

    private void setNnEn(JTable table) {
        int row = table.getSelectedRow();
        if (row < 0) {
            return;
        }
        if (table.getName().equals(CbusEventTableDataModel.class.getName()) || table.getName().equals(CbusNodeEventTableDataModel.class.getName())) {
            this.nn = (Integer)table.getModel().getValueAt(table.convertRowIndexToModel(row), 0);
            this.en = (Integer)table.getModel().getValueAt(table.convertRowIndexToModel(row), 1);
        }
    }

    public void dispose() {
        this.source.removeDragSourceMotionListener(this);
        this.clearFrameTimeout();
        this.frame.dispose();
    }
}

