/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.bootloader;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import jmri.InstanceManager;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.can.cbus.CbusMessage;
import jmri.jmrix.can.cbus.CbusPreferences;
import jmri.jmrix.can.cbus.CbusSend;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.swing.bootloader.Bundle;
import jmri.jmrix.can.cbus.swing.bootloader.CbusParameters;
import jmri.jmrix.can.cbus.swing.bootloader.CbusPicHexFile;
import jmri.jmrix.can.cbus.swing.bootloader.HexFile;
import jmri.jmrix.can.cbus.swing.bootloader.HexRecord;
import jmri.jmrix.can.swing.CanNamedPaneAction;
import jmri.jmrix.can.swing.CanPanel;
import jmri.util.FileUtil;
import jmri.util.ThreadingUtil;
import jmri.util.TimerUtil;
import jmri.util.swing.BusyDialog;
import jmri.util.swing.JmriJFileChooser;
import jmri.util.swing.TextAreaFIFO;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusBootloaderPane
extends CanPanel
implements CanListener {
    private TrafficController tc;
    private CbusSend send;
    private CbusPreferences preferences;
    private final JRadioButtonMenuItem slowWrite;
    private final JRadioButtonMenuItem fastWrite;
    protected JTextField nodeNumberField = new JTextField(6);
    protected JCheckBox configCheckBox = new JCheckBox();
    protected JCheckBox eepromCheckBox = new JCheckBox();
    protected JCheckBox moduleCheckBox = new JCheckBox();
    protected JButton programButton;
    protected JButton openFileChooserButton;
    protected JButton readNodeParamsButton;
    private final TextAreaFIFO bootConsole;
    private static final int MAX_LINES = 5000;
    private final JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(this);
    final JFileChooser hexFileChooser = new JmriJFileChooser(FileUtil.getUserFilesPath());
    transient HexFile hexFile = null;
    CbusParameters hardwareParams = null;
    CbusParameters fileParams = null;
    boolean hexForBootloader = false;
    int nodeNumber;
    int nextParam;
    protected HexRecord currentRecord;
    protected int recordIndex = 0;
    protected boolean recordDone = false;
    private static final int CONFIG_START = 0x200000;
    BusyDialog busyDialog;
    protected BootProtocol bootProtocol = BootProtocol.UNKNOWN;
    protected BootChecksum bootChecksum = BootChecksum.CHECK_2S_COMPLEMENT;
    protected BootState bootState = BootState.IDLE;
    protected int bootAddress;
    protected int checksum;
    protected int dataFramesSent;
    protected int dataTimeout;
    private TimerTask allParamTask;
    private TimerTask startBootTask;
    private TimerTask checkBootTask;
    private TimerTask pauseTask;
    private TimerTask dataTask;
    private TimerTask ackTask;
    private TimerTask devIdTask;
    private TimerTask bootIdTask;
    private TimerTask checkTask;
    private static final Logger log = LoggerFactory.getLogger(CbusBootloaderPane.class);

    public CbusBootloaderPane() {
        this.bootConsole = new TextAreaFIFO(5000);
        this.slowWrite = new JRadioButtonMenuItem(Bundle.getMessage("Slow"));
        this.fastWrite = new JRadioButtonMenuItem(Bundle.getMessage("Fast"));
    }

    @Override
    public void initComponents(CanSystemConnectionMemo memo) {
        super.initComponents(memo);
        this.tc = memo.getTrafficController();
        this.addTc(this.tc);
        this.send = new CbusSend(memo, this.bootConsole);
        this.preferences = memo.get(CbusPreferences.class);
        this.init();
        this.setMenuOptions();
    }

    public void init() {
        this.bootConsole.setEditable(false);
        this.setLayout(new BoxLayout(this, 1));
        JPanel nnPane = new JPanel();
        nnPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("BootNodeNumber")));
        nnPane.add(this.nodeNumberField);
        this.nodeNumberField.setText("");
        this.nodeNumberField.setToolTipText(Bundle.getMessage("BootNodeNumberTT"));
        this.nodeNumberField.setMaximumSize(this.nodeNumberField.getPreferredSize());
        this.nodeNumberField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.resetButtons();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.resetButtons();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.resetButtons();
            }

            public void resetButtons() {
                CbusBootloaderPane.this.openFileChooserButton.setEnabled(false);
                CbusBootloaderPane.this.programButton.setEnabled(false);
                CbusBootloaderPane.this.hardwareParams = null;
            }
        });
        nnPane.add(this.nodeNumberField);
        this.configCheckBox.setText(Bundle.getMessage("BootWriteConfigWords"));
        this.configCheckBox.setVisible(true);
        this.configCheckBox.setEnabled(true);
        this.configCheckBox.setSelected(false);
        this.configCheckBox.setToolTipText(Bundle.getMessage("BootWriteConfigWordsTT"));
        this.eepromCheckBox.setText(Bundle.getMessage("BootWriteEeprom"));
        this.eepromCheckBox.setVisible(true);
        this.eepromCheckBox.setEnabled(true);
        this.eepromCheckBox.setSelected(false);
        this.eepromCheckBox.setToolTipText(Bundle.getMessage("BootWriteEepromTT"));
        JPanel memoryPane = new JPanel();
        memoryPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("BootMemoryOptions")));
        memoryPane.setLayout(new BoxLayout(memoryPane, 0));
        memoryPane.add(this.configCheckBox);
        memoryPane.add(this.eepromCheckBox);
        this.moduleCheckBox.setText(Bundle.getMessage("BootIgnoreParams"));
        this.moduleCheckBox.setVisible(true);
        this.moduleCheckBox.setEnabled(true);
        this.moduleCheckBox.setSelected(false);
        this.moduleCheckBox.setToolTipText(Bundle.getMessage("BootIgnoreParamsTT"));
        JPanel modulePane = new JPanel();
        modulePane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("BootModuleOptions")));
        modulePane.setLayout(new BoxLayout(modulePane, 0));
        modulePane.add(this.moduleCheckBox);
        JPanel selectPane = new JPanel();
        selectPane.setLayout(new BoxLayout(selectPane, 0));
        selectPane.add(nnPane);
        selectPane.add(modulePane);
        selectPane.add(memoryPane);
        this.readNodeParamsButton = new JButton(Bundle.getMessage("BootReadNodeParams"));
        this.readNodeParamsButton.setVisible(true);
        this.readNodeParamsButton.setEnabled(true);
        this.readNodeParamsButton.setToolTipText(Bundle.getMessage("BootReadNodeParamsTT"));
        this.readNodeParamsButton.addActionListener(e -> this.readNodeParamsButtonActionPerformed(e));
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Hex file", "hex");
        this.hexFileChooser.setFileFilter(filter);
        this.hexFileChooser.addChoosableFileFilter(filter);
        this.openFileChooserButton = new JButton(Bundle.getMessage("BootChooseFile"));
        this.openFileChooserButton.setVisible(true);
        this.openFileChooserButton.setEnabled(false);
        this.openFileChooserButton.setToolTipText(Bundle.getMessage("BootChooseFileTT"));
        this.openFileChooserButton.addActionListener(e -> this.openFileChooserButtonActionPerformed(e));
        this.programButton = new JButton(Bundle.getMessage("BootStartProgramming"));
        this.programButton.setVisible(true);
        this.programButton.setEnabled(false);
        this.programButton.setToolTipText(Bundle.getMessage("BootStartProgrammingTT"));
        this.programButton.addActionListener(e -> this.programButtonActionPerformed(e));
        JPanel buttonPane = new JPanel();
        buttonPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ""));
        buttonPane.setLayout(new BoxLayout(buttonPane, 0));
        buttonPane.add(this.readNodeParamsButton);
        buttonPane.add(this.openFileChooserButton);
        buttonPane.add(this.programButton);
        JPanel topPane = new JPanel();
        topPane.setLayout(new BoxLayout(topPane, 1));
        topPane.add(selectPane);
        topPane.add(buttonPane);
        JScrollPane feedbackScroll = new JScrollPane(this.bootConsole);
        feedbackScroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("BootConsole")));
        feedbackScroll.setPreferredSize(new Dimension(400, 200));
        JPanel pane1 = new JPanel();
        pane1.setLayout(new BorderLayout());
        pane1.add((Component)topPane, "First");
        pane1.add((Component)feedbackScroll, "Center");
        this.add(pane1);
        this.setVisible(true);
    }

    @Override
    public String getTitle() {
        return this.prependConnToString(Bundle.getMessage("MenuItemBootloader"));
    }

    private void setMenuOptions() {
        this.slowWrite.setSelected(false);
        this.fastWrite.setSelected(false);
        switch (this.preferences.getBootWriteDelay()) {
            case 10: {
                this.fastWrite.setSelected(true);
                break;
            }
            case 50: {
                this.slowWrite.setSelected(true);
                break;
            }
        }
    }

    @Override
    public List<JMenu> getMenus() {
        ArrayList<JMenu> menuList = new ArrayList<JMenu>();
        JMenu optionsMenu = new JMenu(Bundle.getMessage("Options"));
        JMenu writeSpeedMenu = new JMenu(Bundle.getMessage("BootWriteSpeed"));
        ButtonGroup backgroundFetchGroup = new ButtonGroup();
        backgroundFetchGroup.add(this.slowWrite);
        backgroundFetchGroup.add(this.fastWrite);
        writeSpeedMenu.add(this.slowWrite);
        writeSpeedMenu.add(this.fastWrite);
        optionsMenu.add(writeSpeedMenu);
        menuList.add(optionsMenu);
        ActionListener writeSpeedListener = ae -> {
            if (this.slowWrite.isSelected()) {
                this.preferences.setBootWriteDelay(CbusNode.BOOT_PROG_TIMEOUT_SLOW);
            } else if (this.fastWrite.isSelected()) {
                this.preferences.setBootWriteDelay(CbusNode.BOOT_PROG_TIMEOUT_FAST);
            }
        };
        this.slowWrite.addActionListener(writeSpeedListener);
        this.slowWrite.addActionListener(writeSpeedListener);
        return menuList;
    }

    int getWriteDelay() {
        int delay = CbusNode.BOOT_PROG_TIMEOUT_FAST;
        if (this.bootProtocol == BootProtocol.AN247) {
            if (this.slowWrite.isSelected()) {
                delay = CbusNode.BOOT_PROG_TIMEOUT_SLOW;
            }
            if (this.bootAddress >= 0x200000) {
                delay *= 8;
            }
        } else {
            delay = CbusNode.BOOT_LONG_TIMEOUT_TIME;
        }
        return delay;
    }

    private void readNodeParamsButtonActionPerformed(ActionEvent e) {
        try {
            this.nodeNumber = Integer.parseInt(this.nodeNumberField.getText());
        }
        catch (NumberFormatException e1) {
            this.addToLog(Bundle.getMessage("BootInvalidNode"));
            log.error("Invalid node number {}", (Object)this.nodeNumberField.getText());
            return;
        }
        this.addToLog(Bundle.getMessage("BootReadingParams"));
        this.hardwareParams = new CbusParameters();
        this.nextParam = 0;
        this.busyDialog = new BusyDialog(this.topFrame, Bundle.getMessage("BootReadingParams"), false);
        this.busyDialog.start();
        this.requestParam(this.nextParam);
    }

    private void openFileChooserButtonActionPerformed(ActionEvent e) {
        int retVal = this.hexFileChooser.showOpenDialog(this);
        if (retVal == 0) {
            this.hexFile = new CbusPicHexFile(this.hexFileChooser.getSelectedFile().getPath());
            log.debug("hex file chosen: {}", (Object)this.hexFile.getName());
            this.addToLog(MessageFormat.format(Bundle.getMessage("BootFileChosen"), this.hexFile.getName()));
            try {
                this.hexFile.openRd();
                this.hexFile.read();
            }
            catch (IOException ex) {
                log.error("Error opening hex file");
                this.addToLog(Bundle.getMessage("BootHexFileOpenFailed"));
                return;
            }
            this.fileParams = this.hexFile.getParams();
            if (!this.moduleCheckBox.isSelected()) {
                if (this.fileParams.validate(this.fileParams, this.hardwareParams)) {
                    this.addToLog(MessageFormat.format(Bundle.getMessage("BootHexFileFoundParameters"), this.fileParams.toString()));
                    this.addToLog(Bundle.getMessage("BootHexFileParametersMatch"));
                    this.programButton.setEnabled(true);
                } else {
                    this.addToLog(Bundle.getMessage("BootHexFileParametersMismatch"));
                }
            } else {
                this.addToLog(Bundle.getMessage("BootHexFileIgnoringParameters"));
                this.programButton.setEnabled(true);
            }
            if (this.hardwareParams.areValid() && this.hardwareParams.getLoadAddress() == 0) {
                this.addToLog(Bundle.getMessage("BootBoot"));
                this.hexForBootloader = true;
                this.programButton.setEnabled(true);
            }
        }
    }

    private void programButtonActionPerformed(ActionEvent e) {
        if (this.hasActiveTimers()) {
            return;
        }
        this.openFileChooserButton.setEnabled(false);
        this.programButton.setEnabled(false);
        this.busyDialog = new BusyDialog(this.topFrame, Bundle.getMessage("BootLoading"), false);
        this.busyDialog.start();
        this.setStartBootTimeout();
        this.bootState = BootState.START_BOOT;
        CanMessage m = CbusMessage.getBootEntry(this.nodeNumber, 0);
        this.tc.sendCanMessage(m, null);
    }

    @Override
    public void message(CanMessage m) {
        if (this.bootProtocol == BootProtocol.AN247 && this.bootState == BootState.PROG_DATA && m.isExtended() && CbusMessage.isBootWriteData(m)) {
            log.debug("Boot data write message {}", (Object)m);
            this.setDataTimeout(this.dataTimeout);
        }
    }

    @Override
    public void reply(CanReply r) {
        if (r.isRtr()) {
            return;
        }
        if (!r.isExtended()) {
            log.debug("Standard Reply {}", (Object)r);
            this.handleStandardReply(r);
        } else {
            this.handleExtendedReply(r);
        }
    }

    private void handleStandardReply(CanReply r) {
        int opc = CbusMessage.getOpcode(r);
        if (this.bootState != BootState.GET_PARAMS) {
            log.debug("Reply not for me");
            return;
        }
        if (opc == 155) {
            this.clearAllParamTimeout();
            this.hardwareParams.setParam(r.getElement(3), r.getElement(4));
            if (++this.nextParam < this.hardwareParams.getParam(0) + 1) {
                this.requestParam(this.nextParam);
            } else {
                this.hardwareParams.setValid(true);
                this.addToLog(MessageFormat.format(Bundle.getMessage("BootNodeParametersFinished"), this.hardwareParams.toString()));
                this.busyDialog.finish();
                this.busyDialog = null;
                this.openFileChooserButton.setEnabled(true);
                this.bootState = BootState.IDLE;
            }
        }
    }

    private void handleExtendedReply(CanReply r) {
        switch (this.bootState) {
            default: {
                break;
            }
            case CHECK_BOOT_MODE: {
                this.clearCheckBootTimeout();
                if (!CbusMessage.isBootConfirm(r)) break;
                this.requestDevId();
                break;
            }
            case WAIT_BOOT_DEVID: {
                this.clearDevIdTimeout();
                if (CbusMessage.isBootDevId(r)) {
                    this.showDevId(r);
                    this.bootProtocol = BootProtocol.CBUS_2_0;
                    this.requestBootId();
                    break;
                }
                this.protocolError();
                break;
            }
            case WAIT_BOOT_ID: {
                this.clearBootIdTimeout();
                if (CbusMessage.isBootId(r)) {
                    this.showBootId(r);
                    this.sendBootEnables();
                    break;
                }
                this.protocolError();
                break;
            }
            case ENABLES_SENT: {
                this.clearAckTimeout();
                if (CbusMessage.isBootOK(r)) {
                    this.initialise();
                    break;
                }
                this.protocolError();
                break;
            }
            case INIT_SENT: {
                this.clearAckTimeout();
                if (CbusMessage.isBootOK(r)) {
                    this.writeNextData();
                    break;
                }
                if (CbusMessage.isBootOutOfRange(r)) {
                    log.error("INIT Address out of range");
                    this.endProgramming(BootStatus.INIT_OUT_OF_RANGE);
                    break;
                }
                this.protocolError();
                break;
            }
            case PROG_DATA: {
                this.clearAckTimeout();
                if (CbusMessage.isBootDataOK(r)) {
                    this.writeNextData();
                    break;
                }
                if (CbusMessage.isBootError(r)) {
                    log.error("Data Error");
                    this.endProgramming(BootStatus.DATA_ERROR);
                    break;
                }
                if (CbusMessage.isBootDataOutOfRange(r)) {
                    log.error("Data Address out of range");
                    this.endProgramming(BootStatus.DATA_OUT_OF_RANGE);
                    break;
                }
                this.protocolError();
                break;
            }
            case NOP_SENT: {
                this.clearAckTimeout();
                if (CbusMessage.isBootOK(r)) {
                    this.bootState = BootState.PROG_DATA;
                    this.writeNextData();
                    break;
                }
                if (CbusMessage.isBootOutOfRange(r)) {
                    log.error("NOP Address out of range");
                    this.endProgramming(BootStatus.ADDRESS_OUT_OF_RANGE);
                    break;
                }
                this.protocolError();
                break;
            }
            case CHECK_SENT: {
                this.clearCheckTimeout();
                if (CbusMessage.isBootOK(r)) {
                    this.sendReset();
                    break;
                }
                if (CbusMessage.isBootError(r)) {
                    log.error("Node {} checksum failed", (Object)this.nodeNumber);
                    this.endProgramming(BootStatus.CHECKSUM_FAILED);
                    break;
                }
                this.protocolError();
            }
        }
    }

    void showDevId(CanReply r) {
        log.debug("Found device ID Manu: {} Dev: {} Device ID: {}", new Object[]{r.getElement(1), r.getElement(2), (r.getElement(3) << 24) + (r.getElement(4) << 16) + (r.getElement(5) << 8) + r.getElement(4)});
        this.addToLog(MessageFormat.format(Bundle.getMessage("DevIdCbus"), r.getElement(1), r.getElement(2), (r.getElement(3) << 24) + (r.getElement(4) << 16) + (r.getElement(5) << 8) + r.getElement(4)));
    }

    void showBootId(CanReply r) {
        log.debug("Found bootloader Major: {} Minor: {} Algo: {} Reports: {}", new Object[]{r.getElement(1), r.getElement(2), r.getElement(3), r.getElement(4)});
        this.addToLog(MessageFormat.format(Bundle.getMessage("BootIdCbus"), r.getElement(1), r.getElement(2), r.getElement(3), r.getElement(4)));
    }

    void sendBootEnables() {
        int enables = 1;
        if (this.eepromCheckBox.isSelected()) {
            enables |= 2;
        }
        if (this.configCheckBox.isSelected()) {
            enables |= 4;
        }
        this.bootState = BootState.ENABLES_SENT;
        this.setAckTimeout();
        CanMessage m = CbusMessage.getBootEnables(enables, 0);
        log.debug("Send boot enables {}", (Object)enables);
        this.addToLog(MessageFormat.format(Bundle.getMessage("BootEnables"), enables));
        this.tc.sendCanMessage(m, null);
    }

    void protocolError() {
        log.error("Bootloader Protocol Error in state {}", (Object)this.bootState.toString());
        this.addToLog(MessageFormat.format(Bundle.getMessage("BootProtocol"), this.bootState.toString()));
        this.endProgramming(BootStatus.PROTOCOL_ERROR);
    }

    boolean isProgrammingNeeded(byte[] d) {
        for (int i = 0; i < d.length; ++i) {
            if (d[i] == -1) continue;
            return true;
        }
        return false;
    }

    protected void logFrame(CanMessage m) {
        log.debug("Write frame {} at address {} {}", new Object[]{this.dataFramesSent, Integer.toHexString(this.bootAddress), m});
        if ((this.bootAddress & 0xFF) == 0) {
            this.addToLog(MessageFormat.format(Bundle.getMessage("BootAddress"), Integer.toHexString(this.bootAddress)));
        } else {
            this.bootConsole.append(".");
        }
    }

    protected boolean dataIsFiltered(int address) {
        if (address >= 0x300000 && address < 0x310000 && !this.configCheckBox.isSelected()) {
            return true;
        }
        return address >= 0x310000 && !this.eepromCheckBox.isSelected();
    }

    protected void sendData(int timeout) {
        byte[] d = this.getDataFromRecord();
        ++this.dataFramesSent;
        CanMessage m = CbusMessage.getBootWriteData(d, 0);
        if (this.bootProtocol == BootProtocol.CBUS_2_0) {
            this.setAckTimeout();
            this.updateChecksum(d);
            this.logFrame(m);
            this.tc.sendCanMessage(m, null);
        } else if (!this.dataIsFiltered(this.bootAddress)) {
            this.dataTimeout = timeout;
            this.updateChecksum(d);
            this.logFrame(m);
            this.tc.sendCanMessage(m, null);
        } else {
            this.setDataTimeout(10);
        }
        this.bootAddress += d.length;
    }

    private byte[] getDataFromRecord() {
        byte[] d;
        if (this.currentRecord.len - this.recordIndex >= 8) {
            d = new byte[8];
            if (this.currentRecord.len - this.recordIndex == 8) {
                this.recordDone = true;
            }
        } else {
            d = new byte[this.currentRecord.len - this.recordIndex];
            this.recordDone = true;
        }
        for (int i = 0; i < d.length; ++i) {
            d[i] = this.currentRecord.getData(this.recordIndex++);
        }
        return d;
    }

    void writeNextDataAn247() {
        if (this.bootAddress == 2040 && this.hexForBootloader) {
            log.debug("Pause for bootloader reset");
            this.bootAddress = 2048;
            this.checksum = 0;
            this.bootState = BootState.PROG_PAUSE;
            this.setPauseTimeout();
        } else {
            if (this.currentRecord.address + this.recordIndex != this.bootAddress) {
                this.bootAddress = this.currentRecord.address;
                log.debug("Start writing at new address {}", (Object)Integer.toHexString(this.bootAddress));
                this.addToLog(MessageFormat.format(Bundle.getMessage("BootNewAddress"), Integer.toHexString(this.bootAddress)));
                CanMessage m = CbusMessage.getBootNop(this.bootAddress, 0);
                this.tc.sendCanMessage(m, null);
            }
            if (this.bootAddress < 0x200000 && this.currentRecord.len % 8 != 0) {
                int pad = 8 - this.currentRecord.len % 8;
                for (int i = 0; i < pad; ++i) {
                    this.currentRecord.data[this.currentRecord.len + pad] = -1;
                }
                this.currentRecord.len += pad;
            }
            this.sendData(this.getWriteDelay());
        }
    }

    void writeNextDataCbus() {
        if (this.currentRecord.address + this.recordIndex != this.bootAddress) {
            this.bootAddress = this.currentRecord.address;
            log.debug("Start writing at new address {}", (Object)Integer.toHexString(this.bootAddress));
            this.addToLog(MessageFormat.format(Bundle.getMessage("BootNewAddress"), Integer.toHexString(this.bootAddress)));
            this.bootState = BootState.NOP_SENT;
            this.setAckTimeout();
            CanMessage m = CbusMessage.getBootNop(this.bootAddress, 0);
            this.tc.sendCanMessage(m, null);
        } else {
            this.sendData(this.getWriteDelay());
        }
    }

    void writeNextData() {
        if (this.recordDone) {
            this.recordDone = false;
            this.recordIndex = 0;
            this.currentRecord = this.hexFile.getNextRecord();
            if (this.currentRecord.type == 1) {
                this.bootState = BootState.CHECK_SENT;
                this.addToLog(Bundle.getMessage("BootVerifyChecksum"));
                log.debug("Sending checksum {} as 2s complement {}", (Object)this.checksum, (Object)(0 - this.checksum));
                this.setCheckTimeout();
                CanMessage m = CbusMessage.getBootCheck(0 - this.checksum, 0);
                this.tc.sendCanMessage(m, null);
                return;
            }
        }
        this.bootState = BootState.PROG_DATA;
        if (this.bootProtocol == BootProtocol.AN247) {
            this.writeNextDataAn247();
        } else {
            this.writeNextDataCbus();
        }
    }

    private void initialise() {
        this.bootAddress = this.hardwareParams.areValid() ? this.hardwareParams.getLoadAddress() : (this.fileParams.areValid() ? this.fileParams.getLoadAddress() : this.hexFile.getProgStart());
        this.recordDone = false;
        this.recordIndex = 0;
        Optional<HexRecord> hexRecord = this.hexFile.getRecordForAddress(this.bootAddress);
        if (hexRecord.isPresent()) {
            this.currentRecord = hexRecord.get();
        } else {
            log.error("Did not find hex record for load address {}", (Object)("0x" + Integer.toHexString(this.bootAddress)));
            this.endProgramming(BootStatus.ADDRESS_NOT_FOUND);
        }
        this.checksum = 0;
        this.dataFramesSent = 0;
        log.debug("Initialise at address {}", (Object)("0x" + Integer.toHexString(this.bootAddress)));
        this.addToLog(MessageFormat.format(Bundle.getMessage("BootStartAddress"), Integer.toHexString(this.bootAddress)));
        if (this.bootProtocol == BootProtocol.CBUS_2_0) {
            this.setAckTimeout();
        }
        CanMessage m = CbusMessage.getBootInitialise(this.bootAddress, 0);
        this.bootState = BootState.INIT_SENT;
        this.tc.sendCanMessage(m, null);
        if (this.bootProtocol == BootProtocol.AN247) {
            this.writeNextData();
        }
    }

    protected void requestDevId() {
        CanMessage m = CbusMessage.getBootDevId(0);
        log.debug("Requesting bootloader device ID...");
        this.addToLog(Bundle.getMessage("ReqDevId"));
        this.bootState = BootState.WAIT_BOOT_DEVID;
        this.setDevIdTimeout();
        this.tc.sendCanMessage(m, null);
    }

    protected void requestBootId() {
        CanMessage m = CbusMessage.getBootId(0);
        log.debug("Requesting bootloader ID...");
        this.addToLog(Bundle.getMessage("ReqBootId"));
        this.bootState = BootState.WAIT_BOOT_ID;
        this.setBootIdTimeout();
        this.tc.sendCanMessage(m, null);
    }

    protected void sendReset() {
        CanMessage m = CbusMessage.getBootReset(0);
        log.debug("Done. Resetting node...");
        this.addToLog(Bundle.getMessage("BootFinished"));
        this.tc.sendCanMessage(m, null);
        this.endProgramming(BootStatus.COMPLETE);
    }

    private void endProgramming(BootStatus status) {
        log.debug("Boot status is {}", (Object)status.toString());
        this.addToLog(MessageFormat.format(Bundle.getMessage("BootStatus"), status.toString()));
        if (this.busyDialog != null) {
            this.busyDialog.finish();
            this.busyDialog = null;
        }
        this.openFileChooserButton.setEnabled(true);
        this.programButton.setEnabled(false);
        this.bootState = BootState.IDLE;
    }

    protected void updateChecksum(byte[] d) {
        for (int i = 0; i < d.length; ++i) {
            this.checksum += d[i] & 0xFF;
        }
    }

    public void requestParam(int param) {
        if (this.hasActiveTimers()) {
            return;
        }
        this.bootState = BootState.GET_PARAMS;
        this.setAllParamTimeout();
        this.send.rQNPN(this.nodeNumber, param);
    }

    protected boolean hasActiveTimers() {
        return this.allParamTask != null || this.startBootTask != null || this.checkBootTask != null || this.devIdTask != null || this.bootIdTask != null || this.pauseTask != null || this.dataTask != null || this.ackTask != null || this.checkTask != null;
    }

    private void clearAllParamTimeout() {
        if (this.allParamTask != null) {
            this.allParamTask.cancel();
            this.allParamTask = null;
        }
    }

    private void setAllParamTimeout() {
        this.clearAllParamTimeout();
        this.allParamTask = new TimerTask(){

            @Override
            public void run() {
                CbusBootloaderPane.this.allParamTask = null;
                if (CbusBootloaderPane.this.busyDialog != null) {
                    CbusBootloaderPane.this.busyDialog.finish();
                    CbusBootloaderPane.this.busyDialog = null;
                    log.debug("Failed to read module parameters from node {}", (Object)CbusBootloaderPane.this.nodeNumber);
                    CbusBootloaderPane.this.hardwareParams.setValid(false);
                    CbusBootloaderPane.this.moduleCheckBox.setSelected(true);
                    CbusBootloaderPane.this.openFileChooserButton.setEnabled(true);
                    CbusBootloaderPane.this.endProgramming(BootStatus.PARAMETER_TIMEOUT);
                }
            }
        };
        TimerUtil.schedule(this.allParamTask, CbusNode.SINGLE_MESSAGE_TIMEOUT_TIME);
    }

    private void clearStartBootTimeout() {
        if (this.startBootTask != null) {
            this.startBootTask.cancel();
            this.startBootTask = null;
        }
    }

    private void setStartBootTimeout() {
        this.clearStartBootTimeout();
        this.startBootTask = new TimerTask(){

            @Override
            public void run() {
                CbusBootloaderPane.this.startBootTask = null;
                CbusBootloaderPane.this.setCheckBootTimeout();
                CbusBootloaderPane.this.bootState = BootState.CHECK_BOOT_MODE;
                CanMessage m = CbusMessage.getBootTest(0);
                CbusBootloaderPane.this.tc.sendCanMessage(m, null);
            }
        };
        TimerUtil.schedule(this.startBootTask, CbusNode.BOOT_LONG_TIMEOUT_TIME);
    }

    private void clearCheckBootTimeout() {
        if (this.checkBootTask != null) {
            this.checkBootTask.cancel();
            this.checkBootTask = null;
        }
    }

    private void setCheckBootTimeout() {
        this.clearCheckBootTimeout();
        this.checkBootTask = new TimerTask(){

            @Override
            public void run() {
                CbusBootloaderPane.this.checkBootTask = null;
                log.error("Timeout checking for boot mode");
                CbusBootloaderPane.this.endProgramming(BootStatus.BOOT_TIMEOUT);
            }
        };
        TimerUtil.schedule(this.checkBootTask, CbusNode.BOOT_LONG_TIMEOUT_TIME);
    }

    private void clearDevIdTimeout() {
        if (this.devIdTask != null) {
            this.devIdTask.cancel();
            this.devIdTask = null;
        }
    }

    private void setDevIdTimeout() {
        this.clearDevIdTimeout();
        this.devIdTask = new TimerTask(){

            @Override
            public void run() {
                CbusBootloaderPane.this.devIdTask = null;
                CbusBootloaderPane.this.bootProtocol = BootProtocol.AN247;
                log.debug("Found AN247 bootloader");
                CbusBootloaderPane.this.addToLog(Bundle.getMessage("BootIdAn247"));
                CbusBootloaderPane.this.initialise();
            }
        };
        TimerUtil.schedule(this.devIdTask, CbusNode.BOOT_LONG_TIMEOUT_TIME);
    }

    private void clearBootIdTimeout() {
        if (this.bootIdTask != null) {
            this.bootIdTask.cancel();
            this.bootIdTask = null;
        }
    }

    private void setBootIdTimeout() {
        this.clearBootIdTimeout();
        this.bootIdTask = new TimerTask(){

            @Override
            public void run() {
                CbusBootloaderPane.this.bootIdTask = null;
                CbusBootloaderPane.this.protocolError();
            }
        };
        TimerUtil.schedule(this.bootIdTask, CbusNode.BOOT_LONG_TIMEOUT_TIME);
    }

    private void clearPauseTimeout() {
        if (this.pauseTask != null) {
            this.pauseTask.cancel();
            this.pauseTask = null;
        }
    }

    private void setPauseTimeout() {
        this.clearPauseTimeout();
        this.pauseTask = new TimerTask(){

            @Override
            public void run() {
                CbusBootloaderPane.this.pauseTask = null;
                CbusBootloaderPane.this.hexForBootloader = false;
                log.debug("Start writing at address {}", (Object)Integer.toHexString(CbusBootloaderPane.this.bootAddress));
                CbusBootloaderPane.this.addToLog(MessageFormat.format(Bundle.getMessage("BootStartAddress"), Integer.toHexString(CbusBootloaderPane.this.bootAddress)));
                CbusBootloaderPane.this.bootState = BootState.PROG_DATA;
                CbusBootloaderPane.this.writeNextData();
            }
        };
        TimerUtil.schedule(this.pauseTask, CbusNode.BOOT_LONG_TIMEOUT_TIME);
    }

    private void clearDataTimeout() {
        if (this.dataTask != null) {
            this.dataTask.cancel();
            this.dataTask = null;
        }
    }

    private void setDataTimeout(int timeout) {
        this.clearDataTimeout();
        this.dataTask = new TimerTask(){

            @Override
            public void run() {
                CbusBootloaderPane.this.dataTask = null;
                CbusBootloaderPane.this.writeNextData();
            }
        };
        TimerUtil.schedule(this.dataTask, timeout);
    }

    private void clearAckTimeout() {
        if (this.ackTask != null) {
            this.ackTask.cancel();
            this.ackTask = null;
        }
    }

    private void setAckTimeout() {
        this.clearAckTimeout();
        this.ackTask = new TimerTask(){

            @Override
            public void run() {
                CbusBootloaderPane.this.ackTask = null;
                CbusBootloaderPane.this.endProgramming(BootStatus.ACK_TIMEOUT);
                CbusBootloaderPane.this.bootAddress -= 8;
                log.error("Timeout waiting for data write ACK at address {}", (Object)Integer.toHexString(CbusBootloaderPane.this.bootAddress));
            }
        };
        TimerUtil.schedule(this.ackTask, CbusNode.BOOT_LONG_TIMEOUT_TIME);
    }

    private void clearCheckTimeout() {
        if (this.checkTask != null) {
            this.checkTask.cancel();
            this.checkTask = null;
        }
    }

    private void setCheckTimeout() {
        this.clearCheckTimeout();
        this.checkTask = new TimerTask(){

            @Override
            public void run() {
                CbusBootloaderPane.this.checkTask = null;
                CbusBootloaderPane.this.endProgramming(BootStatus.CHECKSUM_TIMEOUT);
                log.error("Timeout verifying checksum");
            }
        };
        TimerUtil.schedule(this.checkTask, CbusNode.BOOT_LONG_TIMEOUT_TIME);
    }

    public void addToLog(String boottext) {
        ThreadingUtil.runOnGUI(() -> this.bootConsole.append("\n" + boottext));
    }

    @Override
    public void dispose() {
        if (this.hexFile != null) {
            this.hexFile.dispose();
        }
        this.bootConsole.dispose();
        this.tc.removeCanListener(this);
    }

    public static class Default
    extends CanNamedPaneAction {
        public Default() {
            super(Bundle.getMessage("MenuItemBootloader"), new JmriJFrameInterface(), CbusBootloaderPane.class.getName(), InstanceManager.getDefault(CanSystemConnectionMemo.class));
        }
    }

    protected static enum BootStatus {
        NONE,
        PARAMETER_TIMEOUT,
        INIT_OUT_OF_RANGE,
        DATA_ERROR,
        DATA_OUT_OF_RANGE,
        ADDRESS_OUT_OF_RANGE,
        CHECKSUM_FAILED,
        ADDRESS_NOT_FOUND,
        COMPLETE,
        BOOT_TIMEOUT,
        ACK_TIMEOUT,
        CHECKSUM_TIMEOUT,
        PROTOCOL_ERROR;

    }

    protected static enum BootState {
        IDLE,
        GET_PARAMS,
        START_BOOT,
        CHECK_BOOT_MODE,
        WAIT_BOOT_DEVID,
        WAIT_BOOT_ID,
        ENABLES_SENT,
        INIT_SENT,
        PROG_DATA,
        PROG_PAUSE,
        CHECK_SENT,
        NOP_SENT;

    }

    protected static enum BootChecksum {
        CHECK_2S_COMPLEMENT,
        CHECK_CRC16;

    }

    protected static enum BootProtocol {
        UNKNOWN,
        AN247,
        CBUS_2_0;

    }
}

