/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.bootloader;

import java.util.Arrays;
import jmri.jmrix.can.cbus.swing.bootloader.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusParameters {
    protected int[] paramData = new int[33];
    protected boolean valid = false;
    private static final Logger log = LoggerFactory.getLogger(CbusParameters.class);

    public CbusParameters() {
        Arrays.fill(this.paramData, -1);
    }

    public CbusParameters(byte[] d) {
        this();
        if (d.length > 32) {
            log.error("Too many parameters");
            this.valid = false;
        } else {
            this.paramData[0] = d.length;
            for (int i = 0; i < this.paramData[0]; ++i) {
                this.paramData[i + 1] = d[i] & 0xFF;
            }
            this.valid = true;
        }
    }

    public int getParam(int i) {
        return this.paramData[i];
    }

    public void setParam(int i, int v) {
        this.paramData[i] = v;
    }

    public boolean validate(CbusParameters fp, CbusParameters hp) {
        if (!fp.valid || !hp.valid) {
            return false;
        }
        if (fp.paramData[1] != hp.paramData[1]) {
            log.error("Manufacturer ID mismatch {} {}", (Object)fp.paramData[1], (Object)hp.paramData[1]);
            return false;
        }
        if (fp.paramData[3] != hp.paramData[3]) {
            log.error("Module ID mismatch {} {}", (Object)fp.paramData[3], (Object)hp.paramData[3]);
            return false;
        }
        if (hp.paramData[0] > 7 && fp.paramData[9] != hp.paramData[9]) {
            log.error("Processor type mismatch {} {}", (Object)fp.paramData[9], (Object)hp.paramData[9]);
            return false;
        }
        return true;
    }

    public int getLoadAddress() {
        if (this.paramData[0] == 7) {
            return 2048;
        }
        int la = this.paramData[11] + this.paramData[12] * 256 + this.paramData[13] * 256 * 256 + this.paramData[14] * 256 * 256 * 256;
        log.debug("Load address is {}", (Object)la);
        return la;
    }

    public String toString() {
        if (!this.valid) {
            return Bundle.getMessage("ParamsInvalid");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < this.paramData[0]; ++i) {
            sb.append(this.paramData[i] + " ");
        }
        return sb.toString();
    }

    public boolean areValid() {
        return this.valid;
    }

    public void setValid(boolean s) {
        this.valid = s;
    }
}

