/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.bootloader;

import jmri.jmrix.can.cbus.swing.bootloader.CbusParameters;
import jmri.jmrix.can.cbus.swing.bootloader.HexFile;
import jmri.jmrix.can.cbus.swing.bootloader.HexRecord;

public class CbusPicHexFile
extends HexFile {
    public static final int PARAM_OLD_START = 2064;
    public static final int PARAM_OLD_END = 2071;
    public static final int PARAM_OLD_LEN = 7;
    public static final int PARAM_NEW_START = 2080;
    public static final int PARAM_NEW_END = 2105;
    public static final int PARAM_NEW_LEN = 32;
    private CbusParameters newParams = new CbusParameters();
    private CbusParameters oldParams = new CbusParameters();
    private boolean checkValid = false;

    public CbusPicHexFile(String fileName) {
        super(fileName);
    }

    @Override
    protected void checkRecord(HexRecord r) {
        int rStart = 0;
        int rEnd = 0;
        int pStart = 0;
        int checksum = 0;
        if (r.type == 0) {
            if (r.address == 2064) {
                for (int i = 0; i <= 7; ++i) {
                    this.oldParams.setParam(pStart++, r.getData(i) & 0xFF);
                }
                this.checkValid = true;
            } else {
                if (r.address < 2080 && r.address + r.len > 2080) {
                    rStart = 2080 - r.address;
                    pStart = 1;
                    rEnd = r.len > 32 ? rStart + 32 : rStart + r.len;
                    this.checkValid = true;
                } else if (r.address >= 2080 && r.address < 2105) {
                    rStart = 0;
                    rEnd = r.len;
                    pStart = r.address - 2080 + 1;
                    this.checkValid = true;
                }
                if (this.checkValid) {
                    for (int i = rStart; i < rEnd; ++i) {
                        this.newParams.setParam(pStart++, r.getData(i) & 0xFF);
                        checksum += r.getData(i) & 0xFF;
                    }
                }
            }
            if (r.address >= 2105 && this.checkValid) {
                this.checkValid = false;
                this.newParams.setParam(0, this.newParams.getParam(25));
                if (checksum == 0) {
                    this.newParams.setValid(true);
                } else if (this.oldParams.getParam(1) == -91) {
                    this.oldParams.setParam(0, 7);
                    this.oldParams.setValid(true);
                }
            }
        }
    }

    @Override
    public CbusParameters getParams() {
        if (this.newParams.areValid()) {
            return this.newParams;
        }
        if (this.oldParams.areValid()) {
            return this.oldParams;
        }
        return new CbusParameters();
    }
}

