/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.bootloader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Optional;
import jmri.jmrix.can.cbus.swing.bootloader.Bundle;
import jmri.jmrix.can.cbus.swing.bootloader.CbusParameters;
import jmri.jmrix.can.cbus.swing.bootloader.HexRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HexFile {
    protected String name;
    protected File file;
    protected FileInputStream in;
    protected BufferedInputStream buffIn;
    protected static final int MAX_HEX_SIZE = 10000;
    protected int address = 0;
    protected boolean read;
    protected int lineNo = 0;
    private int progStart = 99999999;
    private int progEnd = 0;
    protected HexRecord[] hexRecords;
    protected int readIndex = 0;
    protected int endRecord = 0;
    private static final Logger log = LoggerFactory.getLogger(HexFile.class);

    public HexFile(String fileName) {
        this.name = fileName;
        this.file = new File(fileName);
        this.hexRecords = new HexRecord[10000];
    }

    public String getName() {
        return this.name;
    }

    public void openRd() throws FileNotFoundException {
        this.read = true;
        this.in = new FileInputStream(this.file);
        this.buffIn = new BufferedInputStream(this.in);
        this.address = 0;
    }

    public void close() {
        try {
            if (this.read) {
                this.buffIn.close();
                this.in.close();
            }
            this.name = null;
        }
        catch (IOException e) {
            log.warn("Exception closing hex file", (Throwable)e);
            this.name = null;
        }
    }

    protected void checkRecord(HexRecord r) {
    }

    protected HexRecord readOneRecord() throws IOException {
        HexRecord r;
        try {
            r = new HexRecord(this);
        }
        catch (IOException e) {
            log.error("Exception reading hex record", (Throwable)e);
            throw new IOException(e);
        }
        this.checkRecord(r);
        return r;
    }

    public void read() throws IOException {
        HexRecord r;
        this.lineNo = 0;
        this.endRecord = 0;
        do {
            r = this.readOneRecord();
            r.setLineNo(this.lineNo);
            this.hexRecords[this.lineNo] = r;
            if (r.type == 4) {
                this.address = (r.data[0] & 0xFF) * 256 * 65536 + (r.data[1] & 0xFF) * 65536;
                log.debug("Found extended adress record for address {}", (Object)Integer.toHexString(this.address));
                continue;
            }
            if (r.type == 0) {
                this.hexRecords[this.lineNo].address = this.address = (this.address & 0xFFFF0000) + r.getAddress();
                log.debug("Hex record for address {}", (Object)Integer.toHexString(this.hexRecords[this.lineNo].address));
                if (this.address < this.progStart) {
                    this.progStart = this.address;
                }
                if (this.address + r.len > this.progEnd) {
                    this.progEnd = this.address + r.len;
                }
            }
            if (r.type == 1) {
                this.endRecord = this.lineNo;
            }
            ++this.lineNo;
        } while (r.type != 1);
        log.debug("Done reading hex file");
    }

    public int readChar() throws IOException {
        return this.buffIn.read();
    }

    public int rdHexByte() throws IOException {
        int hi = this.rdHexDigit();
        int lo = this.rdHexDigit();
        return hi * 16 + lo;
    }

    private int rdHexDigit() throws IOException {
        int b = this.buffIn.read();
        if (b >= 48 && b <= 57) {
            b -= 48;
        } else if (b >= 65 && b <= 70) {
            b = b - 65 + 10;
        } else if (b >= 97 && b <= 102) {
            b = b - 97 + 10;
        } else {
            log.error("Invalid hex digit {}", (Object)b);
            throw new IOException(Bundle.getMessage("HexInvalidDigit"));
        }
        return (byte)b;
    }

    public int getAddress() {
        return this.address;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public HexRecord getNextRecord() throws ArrayIndexOutOfBoundsException {
        return this.hexRecords[this.readIndex++];
    }

    public Optional<HexRecord> getRecordForAddress(int addr) throws ArrayIndexOutOfBoundsException {
        this.readIndex = 0;
        try {
            HexRecord r;
            do {
                r = this.hexRecords[this.readIndex++];
            } while (r.type != 0 || addr < r.address || addr >= r.address + r.len);
            return Optional.of(r);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return Optional.empty();
        }
    }

    public CbusParameters getParams() {
        return new CbusParameters();
    }

    public int getProgStart() {
        return this.progStart;
    }

    public int getProgEnd() {
        return this.progEnd;
    }

    public void dispose() {
        this.close();
    }
}

