/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.bootloader;

import java.io.IOException;
import java.util.Arrays;
import jmri.jmrix.can.cbus.swing.bootloader.HexFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HexRecord {
    static final byte EXT_ADDR = 4;
    static final byte TYPE_DATA = 0;
    static final byte END = 1;
    static final int MAX_LEN = 256;
    protected int len = 0;
    protected int addrh = 0;
    protected int addrl = 0;
    protected int address;
    protected int type = 1;
    protected int checksum = 0;
    protected boolean valid = false;
    protected byte[] data = new byte[256];
    protected int lineNo;
    private static final Logger log = LoggerFactory.getLogger(HexRecord.class);

    public HexRecord() {
        Arrays.fill(this.data, (byte)-1);
        this.lineNo = -1;
    }

    public HexRecord(HexFile f) throws IOException {
        this();
        this.readRecord(f);
    }

    protected void setLineNo(int l) {
        this.lineNo = l;
    }

    protected byte[] getData() {
        return this.data;
    }

    protected byte getData(int i) {
        return this.data[i];
    }

    protected int getAddress() {
        return this.address;
    }

    private void startRecord(HexFile f) throws IOException {
        int c;
        this.checksum = 0;
        while ((c = f.readChar()) == 13 || c == 10) {
        }
        if (c != 58) {
            log.error("No colon at start of line {}", (Object)f.getLineNo());
            throw new IOException("No colon at start of line " + f.getLineNo());
        }
    }

    private void readHeader(HexFile f) throws IOException {
        this.len = f.rdHexByte();
        this.checksum += this.len;
        this.addrh = f.rdHexByte();
        this.checksum += this.addrh;
        this.addrl = f.rdHexByte();
        this.checksum += this.addrl;
        this.type = f.rdHexByte();
        this.checksum += this.type;
        if (this.type != 4) {
            this.address = this.addrh * 256 + this.addrl;
        }
    }

    void readData(HexFile f) throws IOException {
        if (this.type != 1) {
            for (int i = 0; i < this.len; ++i) {
                this.data[i] = (byte)(f.rdHexByte() & 0xFF);
                this.checksum += this.data[i];
            }
        }
    }

    private void checkRecord(HexFile f) throws IOException {
        int fileCheck = f.rdHexByte();
        if ((this.checksum + fileCheck & 0xFF) != 0) {
            log.error("Bad checksum at {}", (Object)Integer.toHexString(this.address));
            throw new IOException("Bad checksum");
        }
    }

    private void readRecord(HexFile f) throws IOException {
        try {
            this.startRecord(f);
            this.readHeader(f);
            this.readData(f);
            this.checkRecord(f);
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        this.valid = true;
    }
}

