/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.cbusslotmonitor;

import java.util.ArrayList;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.table.AbstractTableModel;
import jmri.DccLocoAddress;
import jmri.Disposable;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.MemoryManager;
import jmri.ThrottleManager;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.throttle.ThrottleFrame;
import jmri.jmrit.throttle.ThrottleFrameManager;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.can.cbus.CbusMessage;
import jmri.jmrix.can.cbus.swing.cbusslotmonitor.Bundle;
import jmri.jmrix.can.cbus.swing.cbusslotmonitor.CbusSlotMonitorSession;
import jmri.util.StringUtil;
import jmri.util.ThreadingUtil;
import jmri.util.TimerUtil;
import jmri.util.swing.TextAreaFIFO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusSlotMonitorDataModel
extends AbstractTableModel
implements CanListener,
Disposable {
    private final TextAreaFIFO tablefeedback;
    private final TrafficController tc;
    private final CanSystemConnectionMemo memo;
    private final ArrayList<CbusSlotMonitorSession> _mainArray = new ArrayList(0);
    protected int _contype = 0;
    protected String _context;
    private int cmndstat_fw = 0;
    public static int CS_TIMEOUT = 2000;
    private static final int MAX_LINES = 5000;
    public static final int SESSION_ID_COLUMN = 0;
    public static final int LOCO_ID_COLUMN = 1;
    public static final int ESTOP_COLUMN = 2;
    public static final int LOCO_ID_LONG_COLUMN = 3;
    public static final int LOCO_COMMANDED_SPEED_COLUMN = 4;
    public static final int LOCO_DIRECTION_COLUMN = 5;
    public static final int FUNCTION_LIST = 6;
    public static final int SPEED_STEP_COLUMN = 7;
    public static final int LOCO_CONSIST_COLUMN = 8;
    public static final int FLAGS_COLUMN = 9;
    public static final int KILL_SESSION_COLUMN = 10;
    public static final int LAUNCH_THROTTLE = 11;
    public static final int MAX_COLUMN = 12;
    static final int[] CBUSSLOTMONINITIALCOLS = new int[]{0, 1, 2, 4, 5, 6, 9, 10, 11};
    static final String[] CBUSSLOTMONTOOLTIPS = new String[]{"Session ID", null, null, "If Loco ID heard by long address format", "Speed Commanded by throttle / CAB", "Forward or Reverse", "Any Functions set to ON", "Speed Steps", null, null, Bundle.getMessage("ReleaseTip"), Bundle.getMessage("LaunchThrottleTip")};
    private boolean maintainLocoSpdMemory = false;
    private transient TimerTask eStopTask;
    private transient TimerTask powerTask;
    private static final Logger log = LoggerFactory.getLogger(CbusSlotMonitorDataModel.class);

    public CbusSlotMonitorDataModel(CanSystemConnectionMemo memo) {
        this.tablefeedback = new TextAreaFIFO(5000);
        this.tablefeedback.setEditable(false);
        this.tc = memo.getTrafficController();
        this.addTc(this.tc);
        this.memo = memo;
        log.debug("Starting {} CbusSlotMonitorDataModel", (Object)memo.getUserName());
    }

    protected TextAreaFIFO tablefeedback() {
        return this.tablefeedback;
    }

    @Override
    public int getRowCount() {
        return this._mainArray.size();
    }

    @Override
    public int getColumnCount() {
        return 12;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("OPC_SN");
            }
            case 1: {
                return Bundle.getMessage("LocoID");
            }
            case 3: {
                return Bundle.getMessage("Long");
            }
            case 8: {
                return Bundle.getMessage("OPC_CA");
            }
            case 5: {
                return Bundle.getMessage("TrafficDirection");
            }
            case 4: {
                return Bundle.getMessage("Speed");
            }
            case 2: {
                return Bundle.getMessage("EStop");
            }
            case 7: {
                return Bundle.getMessage("Steps");
            }
            case 9: {
                return Bundle.getMessage("OPC_FL");
            }
            case 6: {
                return Bundle.getMessage("Functions");
            }
            case 10: {
                return Bundle.getMessage("Release");
            }
            case 11: {
                return Bundle.getMessage("ThrottleTitle");
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 1: 
            case 8: {
                return Integer.class;
            }
            case 3: {
                return Boolean.class;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                return String.class;
            }
            case 2: 
            case 10: 
            case 11: {
                return JButton.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 2: {
                return this._mainArray.get(row).getSessionId() > 0;
            }
            case 11: {
                return true;
            }
            case 10: {
                return this.isJmriManagedThrottle(this._mainArray.get(row).getLocoAddr());
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                if (this._mainArray.get(row).getSessionId() > 0) {
                    return this._mainArray.get(row).getSessionId();
                }
                return "";
            }
            case 1: {
                return this._mainArray.get(row).getLocoAddr().getNumber();
            }
            case 3: {
                return this._mainArray.get(row).getLocoAddr().isLongAddress();
            }
            case 8: {
                return this._mainArray.get(row).getConsistId();
            }
            case 9: {
                return this._mainArray.get(row).getFlagString();
            }
            case 5: {
                return this._mainArray.get(row).getDirection();
            }
            case 4: {
                return this._mainArray.get(row).getCommandedSpeed();
            }
            case 2: {
                if (this._mainArray.get(row).getSessionId() > 0) {
                    return new NamedIcon("resources/icons/throttles/estop.png", "resources/icons/throttles/estop.png");
                }
                return null;
            }
            case 6: {
                return this._mainArray.get(row).getFunctionString();
            }
            case 7: {
                return this._mainArray.get(row).getSpeedSteps();
            }
            case 10: {
                if (this.isJmriManagedThrottle(this._mainArray.get(row).getLocoAddr())) {
                    return Bundle.getMessage("Release");
                }
                return null;
            }
            case 11: {
                return Bundle.getMessage("ThrottleTitle");
            }
        }
        log.error("internal state inconsistent with table request for row {} col {}", (Object)row, (Object)col);
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 0: {
                this._mainArray.get(row).setSessionId((Integer)value);
                this.updateGui(row, col);
                this.updateGui(row, 10);
                break;
            }
            case 8: {
                this._mainArray.get(row).setConsistId((Integer)value);
                this.updateGui(row, col);
                break;
            }
            case 4: {
                this._mainArray.get(row).setDccSpeed((Integer)value);
                this.updateGui(row, col);
                this.updateGui(row, 5);
                this.updateMemory(this._mainArray.get(row));
                break;
            }
            case 2: {
                int stopspeed = 1;
                if (this._mainArray.get(row).getDirection().equals(Bundle.getMessage("FWD")) && this._mainArray.get(row).getSpeedSteps().equals("128")) {
                    stopspeed = 129;
                }
                CanMessage m = new CanMessage(this.tc.getCanid());
                m.setNumDataElements(3);
                CbusMessage.setPri(m, 11);
                m.setElement(0, 71);
                m.setElement(1, this._mainArray.get(row).getSessionId());
                m.setElement(2, stopspeed);
                this.tc.sendCanMessage(m, null);
                break;
            }
            case 7: {
                this._mainArray.get(row).setSpeedSteps((String)value);
                this.updateGui(row, col);
                break;
            }
            case 10: {
                CanMessage msg = new CanMessage(2, this.tc.getCanid());
                CbusMessage.setPri(msg, 11);
                msg.setOpCode(33);
                msg.setElement(1, this._mainArray.get(row).getSessionId());
                this.tc.sendCanMessage(msg, null);
                break;
            }
            case 11: {
                ThrottleFrame tf = InstanceManager.getDefault(ThrottleFrameManager.class).createThrottleFrame();
                tf.toFront();
                tf.getAddressPanel().setCurrentAddress(this._mainArray.get(row).getLocoAddr());
                break;
            }
            default: {
                log.warn("Failed to set value at column {}", (Object)col);
            }
        }
    }

    private void updateGui(int row, int col) {
        ThreadingUtil.runOnGUI(() -> this.fireTableCellUpdated(row, col));
    }

    public void setMaintainLocoSpdMemory(boolean newVal) {
        this.maintainLocoSpdMemory = newVal;
    }

    private void updateMemory(CbusSlotMonitorSession session) {
        if (!this.maintainLocoSpdMemory || session == null) {
            return;
        }
        MemoryManager memMgr = InstanceManager.getDefault(MemoryManager.class);
        memMgr.provideMemory(memMgr.getSystemNamePrefix() + session.getLocoAddr()).setValue(StringUtil.getFirstIntFromString(session.getCommandedSpeed()));
    }

    private int createnewrow(int locoid, Boolean islong) {
        DccLocoAddress addr = new DccLocoAddress(locoid, islong);
        CbusSlotMonitorSession newSession = new CbusSlotMonitorSession(addr);
        this._mainArray.add(newSession);
        this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
        return this.getRowCount() - 1;
    }

    private int provideTableRow(DccLocoAddress addr) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!addr.equals(this._mainArray.get(i).getLocoAddr())) continue;
            return i;
        }
        return this.createnewrow(addr.getNumber(), addr.isLongAddress());
    }

    private int getrowfromsession(int sessionid) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (sessionid != this._mainArray.get(i).getSessionId()) continue;
            return i;
        }
        CanMessage m = new CanMessage(this.tc.getCanid());
        m.setNumDataElements(2);
        CbusMessage.setPri(m, 11);
        m.setElement(0, 34);
        m.setElement(1, sessionid);
        this.tc.sendCanMessage(m, null);
        return -1;
    }

    @Override
    public void message(CanMessage m) {
        if (m.extendedOrRtr()) {
            return;
        }
        int opc = CbusMessage.getOpcode(m);
        switch (opc) {
            case 225: {
                int rcvdIntAddr = (m.getElement(2) & 0x3F) * 256 + m.getElement(3);
                boolean rcvdIsLong = (m.getElement(2) & 0xC0) != 0;
                this.processploc(m.getElement(1), new DccLocoAddress(rcvdIntAddr, rcvdIsLong), m.getElement(4), m.getElement(5), m.getElement(6), m.getElement(7));
                break;
            }
            case 64: {
                int rcvdIntAddr = (m.getElement(1) & 0x3F) * 256 + m.getElement(2);
                boolean rcvdIsLong = (m.getElement(1) & 0xC0) != 0;
                this.processrloc(false, new DccLocoAddress(rcvdIntAddr, rcvdIsLong));
                break;
            }
            case 71: {
                this.processdspd(m.getElement(1), m.getElement(2));
                break;
            }
            case 35: {
                this.processdkeep(m.getElement(1));
                break;
            }
            case 33: {
                this.processkloc(false, m.getElement(1));
                break;
            }
            case 97: {
                int rcvdIntAddr = (m.getElement(1) & 0x3F) * 256 + m.getElement(2);
                boolean rcvdIsLong = (m.getElement(1) & 0xC0) != 0;
                this.processgloc(false, new DccLocoAddress(rcvdIntAddr, rcvdIsLong), m.getElement(3));
                break;
            }
            case 99: {
                this.processerr(false, m.getElement(1), m.getElement(2), m.getElement(3));
                break;
            }
            case 68: {
                this.processstmod(false, m.getElement(1), m.getElement(2));
                break;
            }
            case 96: {
                this.processdfun(m.getElement(1), m.getElement(2), m.getElement(3));
                break;
            }
            case 73: {
                this.processdfnon(m.getElement(1), m.getElement(2), true);
                break;
            }
            case 74: {
                this.processdfnon(m.getElement(1), m.getElement(2), false);
                break;
            }
            case 69: {
                this.processpcon(m.getElement(1), m.getElement(2));
                break;
            }
            case 70: {
                this.processpcon(m.getElement(1), 0);
                break;
            }
            case 72: {
                this.processdflg(m.getElement(1), m.getElement(2));
                break;
            }
            case 6: {
                this.processestop();
                break;
            }
            case 9: {
                this.processrton();
                break;
            }
            case 8: {
                this.processrtof();
                break;
            }
            case 5: {
                this.processton();
                break;
            }
            case 4: {
                this.processtof();
                break;
            }
        }
    }

    @Override
    public void reply(CanReply m) {
        if (m.extendedOrRtr()) {
            return;
        }
        int opc = CbusMessage.getOpcode(m);
        switch (opc) {
            case 227: {
                this.cmndstat_fw = 4;
                break;
            }
            case 225: {
                int rcvdIntAddr = (m.getElement(2) & 0x3F) * 256 + m.getElement(3);
                boolean rcvdIsLong = (m.getElement(2) & 0xC0) != 0;
                DccLocoAddress addr = new DccLocoAddress(rcvdIntAddr, rcvdIsLong);
                this.processploc(m.getElement(1), addr, m.getElement(4), m.getElement(5), m.getElement(6), m.getElement(7));
                break;
            }
            case 64: {
                int rcvdIntAddr = (m.getElement(1) & 0x3F) * 256 + m.getElement(2);
                boolean rcvdIsLong = (m.getElement(1) & 0xC0) != 0;
                DccLocoAddress addr = new DccLocoAddress(rcvdIntAddr, rcvdIsLong);
                this.processrloc(true, addr);
                break;
            }
            case 71: {
                this.processdspd(m.getElement(1), m.getElement(2));
                break;
            }
            case 35: {
                this.processdkeep(m.getElement(1));
                break;
            }
            case 33: {
                this.processkloc(true, m.getElement(1));
                break;
            }
            case 97: {
                int rcvdIntAddr = (m.getElement(1) & 0x3F) * 256 + m.getElement(2);
                boolean rcvdIsLong = (m.getElement(1) & 0xC0) != 0;
                DccLocoAddress addr = new DccLocoAddress(rcvdIntAddr, rcvdIsLong);
                this.processgloc(true, addr, m.getElement(3));
                break;
            }
            case 99: {
                this.processerr(true, m.getElement(1), m.getElement(2), m.getElement(3));
                break;
            }
            case 68: {
                this.processstmod(true, m.getElement(1), m.getElement(2));
                break;
            }
            case 96: {
                this.processdfun(m.getElement(1), m.getElement(2), m.getElement(3));
                break;
            }
            case 73: {
                this.processdfnon(m.getElement(1), m.getElement(2), true);
                break;
            }
            case 74: {
                this.processdfnon(m.getElement(1), m.getElement(2), false);
                break;
            }
            case 69: {
                this.processpcon(m.getElement(1), m.getElement(2));
                break;
            }
            case 70: {
                this.processpcon(m.getElement(1), 0);
                break;
            }
            case 72: {
                this.processdflg(m.getElement(1), m.getElement(2));
                break;
            }
            case 6: {
                this.processestop();
                break;
            }
            case 9: {
                this.processrton();
                break;
            }
            case 8: {
                this.processrtof();
                break;
            }
            case 5: {
                this.processton();
                break;
            }
            case 4: {
                this.processtof();
                break;
            }
        }
    }

    private void processploc(int session, DccLocoAddress addr, int speeddir, int fa, int fb, int fc) {
        int row = this.provideTableRow(addr);
        this.setValueAt(session, row, 0);
        this.setValueAt(speeddir, row, 4);
        this.processdfun(session, 1, fa);
        this.processdfun(session, 2, fb);
        this.processdfun(session, 3, fc);
    }

    private void processkloc(boolean messagein, int session) {
        int row = this.getrowfromsession(session);
        String messagedir = messagein ? Bundle.getMessage("CBUS_IN_CAB") : Bundle.getMessage("CBUS_OUT_CMD");
        log.debug("direction {} kloc {}", (Object)messagedir, (Object)Bundle.getMessage("CNFO_KLOC", session));
        if (row > -1) {
            this.setValueAt(0, row, 0);
            if (this.cmndstat_fw > 3 && !"0".startsWith(this._mainArray.get(row).getCommandedSpeed())) {
                log.debug("send qloc {} {}", (Object)Bundle.getMessage("CBUS_OUT_CMD"), (Object)Bundle.getMessage("QuerySession8a", session));
                CanMessage m = new CanMessage(this.tc.getCanid());
                m.setNumDataElements(2);
                CbusMessage.setPri(m, 11);
                m.setElement(0, 34);
                m.setElement(1, session);
                this.tc.sendCanMessage(m, null);
            }
        }
    }

    private void processrloc(boolean messagein, DccLocoAddress addr) {
        int row = this.provideTableRow(addr);
        log.debug("{} new table row {}", (Object)messagein, (Object)row);
    }

    private void processgloc(boolean messagein, DccLocoAddress addr, int flags) {
        boolean sharemode;
        int row = this.provideTableRow(addr);
        log.debug("processgloc row {}", (Object)row);
        StringBuilder flagstring = new StringBuilder();
        if (messagein) {
            flagstring.append(Bundle.getMessage("CBUS_IN_CAB"));
        } else {
            flagstring.append(Bundle.getMessage("CBUS_OUT_CMD"));
        }
        boolean stealmode = (flags & 1) != 0;
        boolean bl = sharemode = (flags >> 1 & 1) != 0;
        if (stealmode) {
            flagstring.append(Bundle.getMessage("CNFO_GLOC_ST"));
        } else if (sharemode) {
            flagstring.append(Bundle.getMessage("CNFO_GLOC_SH"));
        } else {
            flagstring.append(Bundle.getMessage("CNFO_GLOC"));
        }
        flagstring.append(addr);
        this.addToLog(1, flagstring.toString());
    }

    private void processstmod(boolean messagein, int session, int flags) {
        int row = this.getrowfromsession(session);
        if (row > -1) {
            String messagedir = messagein ? Bundle.getMessage("CBUS_IN_CAB") : Bundle.getMessage("CBUS_OUT_CMD");
            boolean sm0 = (flags & 1) != 0;
            boolean sm1 = (flags >> 1 & 1) != 0;
            boolean servicemode = (flags >> 2 & 1) != 0;
            boolean soundmode = (flags >> 3 & 1) != 0;
            String speedstep = "";
            if (!sm0 && !sm1) {
                speedstep = "128";
            } else if (!sm0 && sm1) {
                speedstep = "14";
            } else if (sm0 && !sm1) {
                speedstep = "28I";
            } else if (sm0 && sm1) {
                speedstep = "28";
            }
            log.debug("processstmod {} {}", (Object)messagedir, (Object)Bundle.getMessage("CNFO_STMOD", session, speedstep, servicemode, soundmode));
            this.setValueAt(speedstep, row, 7);
        }
    }

    private void processdkeep(int session) {
        int row = this.getrowfromsession(session);
        if (row < 0) {
            log.debug("Requesting loco details for session {}.", (Object)session);
        }
    }

    private void processdspd(int session, int speeddir) {
        int row = this.getrowfromsession(session);
        if (row > -1) {
            this.setValueAt(speeddir, row, 4);
        }
    }

    private void processdflg(int session, int flags) {
        int row = this.getrowfromsession(session);
        if (row > -1) {
            this._mainArray.get(row).setFlags(flags);
            this.updateGui(row, 7);
            this.updateGui(row, 9);
        }
    }

    private void processdfnon(int session, int function, boolean trueorfalse) {
        int row = this.getrowfromsession(session);
        if (row > -1 && function > -1 && function < 29) {
            this._mainArray.get(row).setFunction(function, trueorfalse);
            this.updateGui(row, 6);
        }
    }

    private void processdfun(int session, int range, int functionbyte) {
        int row = this.getrowfromsession(session);
        if (row > -1) {
            switch (range) {
                case 1: {
                    this._mainArray.get(row).setFunction(0, (functionbyte & 0x10) == 16);
                    this._mainArray.get(row).setFunction(1, (functionbyte & 1) == 1);
                    this._mainArray.get(row).setFunction(2, (functionbyte & 2) == 2);
                    this._mainArray.get(row).setFunction(3, (functionbyte & 4) == 4);
                    this._mainArray.get(row).setFunction(4, (functionbyte & 8) == 8);
                    break;
                }
                case 2: {
                    this._mainArray.get(row).setFunction(5, (functionbyte & 1) == 1);
                    this._mainArray.get(row).setFunction(6, (functionbyte & 2) == 2);
                    this._mainArray.get(row).setFunction(7, (functionbyte & 4) == 4);
                    this._mainArray.get(row).setFunction(8, (functionbyte & 8) == 8);
                    break;
                }
                case 3: {
                    this._mainArray.get(row).setFunction(9, (functionbyte & 1) == 1);
                    this._mainArray.get(row).setFunction(10, (functionbyte & 2) == 2);
                    this._mainArray.get(row).setFunction(11, (functionbyte & 4) == 4);
                    this._mainArray.get(row).setFunction(12, (functionbyte & 8) == 8);
                    break;
                }
                case 4: {
                    this._mainArray.get(row).setFunction(13, (functionbyte & 1) == 1);
                    this._mainArray.get(row).setFunction(14, (functionbyte & 2) == 2);
                    this._mainArray.get(row).setFunction(15, (functionbyte & 4) == 4);
                    this._mainArray.get(row).setFunction(16, (functionbyte & 8) == 8);
                    this._mainArray.get(row).setFunction(17, (functionbyte & 0x10) == 16);
                    this._mainArray.get(row).setFunction(18, (functionbyte & 0x20) == 32);
                    this._mainArray.get(row).setFunction(19, (functionbyte & 0x40) == 64);
                    this._mainArray.get(row).setFunction(20, (functionbyte & 0x80) == 128);
                    break;
                }
                case 5: {
                    this._mainArray.get(row).setFunction(21, (functionbyte & 1) == 1);
                    this._mainArray.get(row).setFunction(22, (functionbyte & 2) == 2);
                    this._mainArray.get(row).setFunction(23, (functionbyte & 4) == 4);
                    this._mainArray.get(row).setFunction(24, (functionbyte & 8) == 8);
                    this._mainArray.get(row).setFunction(25, (functionbyte & 0x10) == 16);
                    this._mainArray.get(row).setFunction(26, (functionbyte & 0x20) == 32);
                    this._mainArray.get(row).setFunction(27, (functionbyte & 0x40) == 64);
                    this._mainArray.get(row).setFunction(28, (functionbyte & 0x80) == 128);
                    break;
                }
            }
            this.updateGui(row, 6);
        }
    }

    private void processerr(boolean messagein, int one, int two, int errnum) {
        int rcvdIntAddr = (one & 0x3F) * 256 + two;
        StringBuilder buf = new StringBuilder();
        if (messagein) {
            buf.append(Bundle.getMessage("CBUS_CMND_BR"));
        } else {
            buf.append(Bundle.getMessage("CBUS_OUT_CMD"));
        }
        switch (errnum) {
            case 1: {
                buf.append(Bundle.getMessage("ERR_LOCO_STACK_FULL"));
                buf.append(rcvdIntAddr);
                break;
            }
            case 2: {
                buf.append(Bundle.getMessage("ERR_LOCO_ADDRESS_TAKEN", rcvdIntAddr));
                break;
            }
            case 3: {
                buf.append(Bundle.getMessage("ERR_SESSION_NOT_PRESENT", one));
                break;
            }
            case 4: {
                buf.append(Bundle.getMessage("ERR_CONSIST_EMPTY"));
                buf.append(one);
                break;
            }
            case 5: {
                buf.append(Bundle.getMessage("ERR_LOCO_NOT_FOUND"));
                buf.append(one);
                break;
            }
            case 6: {
                buf.append(Bundle.getMessage("ERR_CAN_BUS_ERROR"));
                break;
            }
            case 7: {
                buf.append(Bundle.getMessage("ERR_INVALID_REQUEST"));
                buf.append(rcvdIntAddr);
                break;
            }
            case 8: {
                buf.append(Bundle.getMessage("ERR_SESSION_CANCELLED", one));
                int row = this.getrowfromsession(one);
                if (row <= -1) break;
                this.setValueAt(0, row, 0);
                break;
            }
        }
        this._context = buf.toString();
        this.addToLog(1, this._context);
    }

    private void processpcon(int session, int consist) {
        log.debug("processing pcon");
        int row = this.getrowfromsession(session);
        if (row > -1) {
            int consistaddr = consist & 0x7F;
            this.setValueAt(consistaddr, row, 8);
            StringBuilder buf = new StringBuilder();
            buf.append(Bundle.getMessage("CNFO_PCON", session, consistaddr));
            if ((consist & 0x80) == 128) {
                buf.append(Bundle.getMessage("FWD"));
            } else {
                buf.append(Bundle.getMessage("REV"));
            }
            this.addToLog(1, buf.toString());
        }
    }

    private void processestop() {
        this.addToLog(1, "Command station acknowledges estop");
        this.clearEStopTask();
    }

    private void processrton() {
        this.setPowerTask();
    }

    private void processrtof() {
        this.setPowerTask();
    }

    private void processton() {
        this.clearPowerTask();
        log.debug("Track on confirmed from command station.");
    }

    private void processtof() {
        this.clearPowerTask();
        log.debug("Track off confirmed from command station.");
    }

    public void sendcbusestop() {
        log.info("Sending Command Station e-stop");
        CanMessage m = new CanMessage(this.tc.getCanid());
        m.setNumDataElements(1);
        CbusMessage.setPri(m, 11);
        m.setElement(0, 10);
        this.tc.sendCanMessage(m, null);
        this.setEstopTask();
    }

    private void clearEStopTask() {
        if (this.eStopTask != null) {
            this.eStopTask.cancel();
            this.eStopTask = null;
        }
    }

    private void setEstopTask() {
        this.eStopTask = new TimerTask(){

            @Override
            public void run() {
                CbusSlotMonitorDataModel.this.eStopTask = null;
                CbusSlotMonitorDataModel.this.addToLog(1, "Send Estop No Response received from command station.");
                log.info("Send Estop No Response received from command station.");
            }
        };
        TimerUtil.schedule(this.eStopTask, CS_TIMEOUT);
    }

    private void clearPowerTask() {
        if (this.powerTask != null) {
            this.powerTask.cancel();
            this.powerTask = null;
        }
    }

    private void setPowerTask() {
        this.powerTask = new TimerTask(){

            @Override
            public void run() {
                CbusSlotMonitorDataModel.this.powerTask = null;
                CbusSlotMonitorDataModel.this.addToLog(1, "Track Power - No Response received from command station.");
                log.info("Track Power - No Response received from command station.");
            }
        };
        TimerUtil.schedule(this.powerTask, CS_TIMEOUT);
    }

    public void addToLog(int cbuserror, String cbustext) {
        ThreadingUtil.runOnGUI(() -> this.tablefeedback.append(System.lineSeparator() + cbustext));
    }

    private boolean isJmriManagedThrottle(LocoAddress addr) {
        ThrottleManager tm = (ThrottleManager)this.memo.getFromMap(ThrottleManager.class);
        return tm != null && tm.getThrottleUsageCount(addr) > 0;
    }

    @Override
    public void dispose() {
        this.removeTc(this.tc);
        this.clearEStopTask();
        this.clearPowerTask();
        this.tablefeedback.dispose();
    }
}

