/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.cbusslotmonitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import jmri.InstanceManager;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.throttle.LargePowerManagerButton;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.swing.CbusCommonSwing;
import jmri.jmrix.can.cbus.swing.cbusslotmonitor.Bundle;
import jmri.jmrix.can.cbus.swing.cbusslotmonitor.CbusSlotMonitorDataModel;
import jmri.jmrix.can.swing.CanNamedPaneAction;
import jmri.jmrix.can.swing.CanPanel;
import jmri.swing.JmriJTablePersistenceManager;
import jmri.util.swing.StayOpenCheckBoxItem;
import jmri.util.swing.XTableColumnModel;
import jmri.util.swing.sdi.JmriJFrameInterface;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import jmri.util.table.JTableWithColumnToolTips;

public class CbusSlotMonitorPane
extends CanPanel {
    protected CbusSlotMonitorDataModel slotModel;
    private JTable slotTable;
    private final XTableColumnModel tcm = new XTableColumnModel();
    private final JMenu colMenu = new JMenu(Bundle.getMessage("SessCol"));

    @Override
    public void initComponents(CanSystemConnectionMemo memo) {
        super.initComponents(memo);
        this.slotModel = memo.get(CbusSlotMonitorDataModel.class);
        this.slotTable = new JTableWithColumnToolTips((TableModel)this.slotModel, CbusSlotMonitorDataModel.CBUSSLOTMONTOOLTIPS);
        this.init();
    }

    public void init() {
        this.slotTable.setColumnModel(this.tcm);
        this.setupColumnsMenuLinks();
        TableRowSorter<CbusSlotMonitorDataModel> sorter = new TableRowSorter<CbusSlotMonitorDataModel>(this.slotModel);
        this.slotTable.setRowSorter(sorter);
        this.setCellRenderers();
        JScrollPane slotScroll = new JScrollPane(this.slotTable);
        slotScroll.setPreferredSize(new Dimension(400, 200));
        this.setLayout(new BoxLayout(this, 1));
        JScrollPane scrolltablefeedback = new JScrollPane(this.slotModel.tablefeedback());
        scrolltablefeedback.setMinimumSize(new Dimension(150, 20));
        JPanel toppanelcontainer = new JPanel();
        toppanelcontainer.setLayout(new BoxLayout(toppanelcontainer, 0));
        toppanelcontainer.add(this.getStopButton());
        toppanelcontainer.add(new LargePowerManagerButton(true));
        JSplitPane split = new JSplitPane(0, slotScroll, scrolltablefeedback);
        split.setResizeWeight(0.95);
        split.setContinuousLayout(true);
        JPanel p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        p1.add((Component)toppanelcontainer, "First");
        p1.add((Component)split, "Center");
        this.add(p1);
        p1.setMinimumSize(new Dimension(450, 200));
        p1.setVisible(true);
    }

    private void setCellRenderers() {
        block5: for (int i = 0; i < 12; ++i) {
            TableColumn col = this.tcm.getColumnByModelIndex(i);
            switch (i) {
                case 3: {
                    continue block5;
                }
                case 2: {
                    col.setMinWidth(55);
                    col.setCellRenderer(new ButtonRenderer());
                    col.setCellEditor(new ButtonEditor(new JButton()));
                    continue block5;
                }
                case 10: 
                case 11: {
                    col.setCellRenderer(new ButtonRenderer());
                    col.setCellEditor(new ButtonEditor(new JButton()));
                    continue block5;
                }
                default: {
                    col.setCellRenderer(this.getRenderer());
                }
            }
        }
    }

    private JButton getStopButton() {
        JButton estopButton = new JButton("Stop All");
        estopButton.setIcon(new NamedIcon("resources/icons/throttles/estop.png", "resources/icons/throttles/estop.png"));
        estopButton.setToolTipText(Bundle.getMessage("ThrottleToolBarStopAllToolTip"));
        estopButton.addActionListener(e -> this.slotModel.sendcbusestop());
        return estopButton;
    }

    private void setupColumnsMenuLinks() {
        int i;
        CbusCommonSwing.configureTable(this.slotTable);
        this.slotTable.setName("CbusSlotMonitorPane.5.9.7");
        StayOpenCheckBoxItem[] cbArray = new StayOpenCheckBoxItem[this.slotModel.getColumnCount()];
        for (i = 0; i < this.slotModel.getColumnCount(); ++i) {
            StayOpenCheckBoxItem cbi;
            cbArray[i] = cbi = new StayOpenCheckBoxItem(this.slotModel.getColumnName(i));
            TableColumn column = this.tcm.getColumnByModelIndex(i);
            cbi.addActionListener(e -> this.tcm.setColumnVisible(column, cbi.isSelected()));
            int ii = i;
            this.tcm.setColumnVisible(this.tcm.getColumnByModelIndex(i), Arrays.stream(CbusSlotMonitorDataModel.CBUSSLOTMONINITIALCOLS).anyMatch(j -> j == ii));
        }
        InstanceManager.getOptionalDefault(JmriJTablePersistenceManager.class).ifPresent(tpm -> tpm.persist(this.slotTable, true));
        for (i = 0; i < this.slotModel.getColumnCount(); ++i) {
            cbArray[i].setSelected(this.tcm.isColumnVisible(this.tcm.getColumnByModelIndex(i)));
            this.colMenu.add(cbArray[i]);
        }
    }

    @Override
    public String getTitle() {
        return this.prependConnToString(Bundle.getMessage("MenuItemCbusSlotMonitor"));
    }

    @Override
    public List<JMenu> getMenus() {
        ArrayList<JMenu> menuList = new ArrayList<JMenu>();
        menuList.add(this.colMenu);
        return menuList;
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.can.cbus.swing.cbusslotmonitor.CbusSlotMonitorPane";
    }

    private TableCellRenderer getRenderer() {
        return new TableCellRenderer(){
            JTextField f = new JTextField();

            @Override
            public Component getTableCellRendererComponent(JTable table, Object arg1, boolean isSelected, boolean hasFocus, int row, int col) {
                if (arg1 != null) {
                    String string = arg1.toString();
                    this.f.setText(string);
                    this.f.setHorizontalAlignment(0);
                } else {
                    this.f.setText("");
                }
                CbusCommonSwing.setCellBackground(isSelected, this.f, table, row);
                CbusCommonSwing.setCellFocus(hasFocus, this.f, table);
                return this.f;
            }
        };
    }

    @Override
    public void dispose() {
        InstanceManager.getOptionalDefault(JmriJTablePersistenceManager.class).ifPresent(tpm -> tpm.stopPersisting(this.slotTable));
        this.slotTable = null;
        super.dispose();
    }

    public static class Default
    extends CanNamedPaneAction {
        public Default() {
            super(Bundle.getMessage("MenuItemCbusSlotMonitor"), new JmriJFrameInterface(), CbusSlotMonitorPane.class.getName(), InstanceManager.getDefault(CanSystemConnectionMemo.class));
        }
    }
}

