/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.cbusslotmonitor;

import jmri.DccLocoAddress;
import jmri.jmrix.can.cbus.CbusOpCodes;
import jmri.jmrix.can.cbus.swing.cbusslotmonitor.Bundle;

public class CbusSlotMonitorSession {
    private final DccLocoAddress _locoAddr;
    private int _sessionId;
    private int _speed;
    private String _speedSteps;
    private boolean[] function;
    private int _flags;
    private int _consistId;

    protected CbusSlotMonitorSession(DccLocoAddress locoAddr) {
        this._locoAddr = locoAddr;
        this._sessionId = -1;
        this._speed = 0;
        this._speedSteps = "";
        this.function = new boolean[29];
        this._flags = -1;
        this._consistId = 0;
    }

    protected DccLocoAddress getLocoAddr() {
        return this._locoAddr;
    }

    protected void setSessionId(int session) {
        this._sessionId = session;
    }

    protected int getSessionId() {
        return this._sessionId;
    }

    protected void setDccSpeed(int speed) {
        this._speed = speed;
    }

    protected String getCommandedSpeed() {
        return CbusOpCodes.getSpeedFromByte(this._speed);
    }

    protected String getDirection() {
        return CbusOpCodes.getDirectionFromByte(this._speed);
    }

    protected void setSpeedSteps(String steps) {
        this._speedSteps = steps;
    }

    protected String getSpeedSteps() {
        if (this._speedSteps.isEmpty()) {
            return "128";
        }
        return this._speedSteps;
    }

    protected void setFunction(int fn, boolean tof) {
        if (fn >= this.function.length) {
            boolean[] newArray = new boolean[fn + 1];
            System.arraycopy(this.function, 0, newArray, 0, this.function.length);
            this.function = newArray;
        }
        this.function[fn] = tof;
    }

    protected String getFunctionString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.function.length; ++i) {
            if (!this.function[i]) continue;
            buf.append(i);
            buf.append(" ");
        }
        return buf.toString().trim();
    }

    protected void setFlags(int flags) {
        this._flags = flags;
        int mask = 3;
        switch (flags & mask) {
            case 1: {
                this._speedSteps = "14";
                break;
            }
            case 2: {
                this._speedSteps = "28I";
                break;
            }
            case 3: {
                this._speedSteps = "28";
                break;
            }
            default: {
                this._speedSteps = "128";
            }
        }
    }

    protected String getFlagString() {
        if (this._flags < 0) {
            return "";
        }
        StringBuilder flagstring = new StringBuilder();
        boolean esa = (this._flags >> 4 & 1) != 0;
        boolean esb = (this._flags >> 5 & 1) != 0;
        flagstring.append(Bundle.getMessage("EngineState"));
        if (!esa && !esb) {
            flagstring.append(Bundle.getMessage("Active"));
        } else if (!esa && esb) {
            flagstring.append(Bundle.getMessage("Consisted"));
        } else if (esa && !esb) {
            flagstring.append(Bundle.getMessage("Consistmaster"));
        } else if (esa && esb) {
            flagstring.append(Bundle.getMessage("Inactive"));
        }
        flagstring.append(" ");
        flagstring.append(Bundle.getMessage("Lights"));
        flagstring.append(this._flags >> 2 & 1);
        flagstring.append(" ");
        flagstring.append(Bundle.getMessage("RelDirection"));
        flagstring.append(this._flags >> 3 & 1);
        flagstring.append(" ");
        return flagstring.toString();
    }

    protected void setConsistId(int consistid) {
        this._consistId = consistid;
    }

    protected int getConsistId() {
        return this._consistId;
    }
}

