/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.configtool;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import jmri.InstanceManager;
import jmri.LightManager;
import jmri.SensorManager;
import jmri.TurnoutManager;
import jmri.jmrix.AbstractMessage;
import jmri.jmrix.can.CanFrame;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.CbusMessage;
import jmri.jmrix.can.cbus.swing.CbusEventHighlightFrame;
import jmri.jmrix.can.cbus.swing.CbusFilterFrame;
import jmri.jmrix.can.cbus.swing.configtool.Bundle;
import jmri.jmrix.can.cbus.swing.console.CbusConsolePane;
import jmri.jmrix.can.swing.CanNamedPaneAction;
import jmri.jmrix.can.swing.CanPanel;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigToolPane
extends CanPanel
implements CanListener {
    static int configtool_instance_num;
    static final int NRECORDERS = 6;
    private final CbusEventRecorder[] recorders = new CbusEventRecorder[6];
    private CbusFilterFrame _filterFrame;
    private CbusEventHighlightFrame _highlightFrame;
    private final CbusConsolePane _console;
    protected JButton filterButton;
    protected JButton highlightButton;
    private JButton resetCaptureButton;
    private MakeNamedBean makeSensor;
    private MakeNamedBean makeTurnout;
    private MakeNamedBean makeLight;
    private static final Logger log;

    public static void incrementInstance() {
        ++configtool_instance_num;
    }

    public static int getConfigToolInstanceNum() {
        log.debug("instance num {}", (Object)configtool_instance_num);
        return configtool_instance_num;
    }

    public ConfigToolPane() {
        this._filterFrame = null;
        this._highlightFrame = null;
        this._console = null;
    }

    public ConfigToolPane(CbusConsolePane console, CbusFilterFrame filterFrame, CbusEventHighlightFrame highlightFrame) {
        this._filterFrame = filterFrame;
        this._highlightFrame = highlightFrame;
        this._console = console;
    }

    public void init() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 1));
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        this.filterButton = new JButton(Bundle.getMessage("ButtonFilter"));
        this.filterButton.setVisible(true);
        this.filterButton.setToolTipText(Bundle.getMessage("TooltipFilter"));
        buttons.add(this.filterButton);
        this.filterButton.addActionListener(this::filterButtonActionPerformed);
        this.highlightButton = new JButton(Bundle.getMessage("ButtonHighlight"));
        this.highlightButton.setVisible(true);
        this.highlightButton.setToolTipText(Bundle.getMessage("TooltipHighlighter"));
        buttons.add(this.highlightButton);
        this.highlightButton.addActionListener(this::highlightButtonActionPerformed);
        this.resetCaptureButton = new JButton(Bundle.getMessage("ButtonResetCapture"));
        this.resetCaptureButton.setVisible(true);
        this.resetCaptureButton.setHorizontalAlignment(4);
        buttons.add(this.resetCaptureButton);
        this.resetCaptureButton.addActionListener(this::resetCaptureButtonActionPerformed);
        p1.add(buttons);
        for (int i = 0; i < this.recorders.length; ++i) {
            this.recorders[i] = new CbusEventRecorder();
            p1.add(this.recorders[i]);
        }
        p1.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutEvents")));
        this.add(p1);
        this.makeSensor = new MakeNamedBean("LabelEventActive", "LabelEventInactive"){

            @Override
            void create(String name) {
                try {
                    ConfigToolPane.this.memo.get(SensorManager.class).provideSensor(name);
                }
                catch (IllegalArgumentException ex) {
                    JmriJOptionPane.showMessageDialog(this, ex.getMessage(), Bundle.getMessage("WarningTitle"), 0);
                }
            }
        };
        this.makeSensor.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TitleAddX", Bundle.getMessage("BeanNameSensor"))));
        this.add(this.makeSensor);
        this.makeTurnout = new MakeNamedBean("LabelEventThrown", "LabelEventClosed"){

            @Override
            void create(String name) {
                try {
                    ConfigToolPane.this.memo.get(TurnoutManager.class).provideTurnout(name);
                }
                catch (IllegalArgumentException ex) {
                    JmriJOptionPane.showMessageDialog(this, ex.getMessage(), Bundle.getMessage("WarningTitle"), 0);
                }
            }
        };
        this.makeTurnout.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TitleAddX", Bundle.getMessage("BeanNameTurnout"))));
        this.add(this.makeTurnout);
        this.makeLight = new MakeNamedBean("LabelEventLightOn", "LabelEventLightOff"){

            @Override
            void create(String name) {
                try {
                    ConfigToolPane.this.memo.get(LightManager.class).provideLight(name);
                }
                catch (Exception ex) {
                    JmriJOptionPane.showMessageDialog(this, ex.getMessage(), Bundle.getMessage("WarningTitle"), 0);
                }
            }
        };
        this.makeLight.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TitleAddX", Bundle.getMessage("BeanNameLight"))));
        this.add(this.makeLight);
    }

    @Override
    public void initComponents(CanSystemConnectionMemo memo) {
        super.initComponents(memo);
        this.addTc(memo);
        ConfigToolPane.incrementInstance();
        this.init();
    }

    @Override
    public String getTitle() {
        if (this.memo != null) {
            StringBuilder title = new StringBuilder(20);
            title.append(this.memo.getUserName());
            title.append(" ");
            title.append(Bundle.getMessage("CapConfigTitle"));
            if (ConfigToolPane.getConfigToolInstanceNum() > 1) {
                title.append(" ");
                title.append(ConfigToolPane.getConfigToolInstanceNum());
            }
            return title.toString();
        }
        return Bundle.getMessage("CapConfigTitle");
    }

    @Override
    public void reply(CanReply m) {
        this.sendToListeners(m);
    }

    @Override
    public void message(CanMessage m) {
        this.sendToListeners(m);
    }

    private void sendToListeners(AbstractMessage m) {
        if (((CanFrame)((Object)m)).extendedOrRtr()) {
            return;
        }
        if (this._filterFrame != null && this._filterFrame.filter(m)) {
            return;
        }
        this.makeSensor.processFrame(m);
        this.makeTurnout.processFrame(m);
        this.makeLight.processFrame(m);
        for (CbusEventRecorder recorder : this.recorders) {
            if (!recorder.waiting()) continue;
            recorder.processFrame(m);
            break;
        }
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.can.cbus.swing.configtool.ConfigToolFrame";
    }

    @Override
    public void dispose() {
        this.removeTc(this.memo);
        this.clearFilterFrame();
        this.clearHighlightFrame();
        super.dispose();
    }

    private void clearFilterFrame() {
        if (this._filterFrame != null) {
            this._filterFrame.dispose();
        }
        this._filterFrame = null;
    }

    private void clearHighlightFrame() {
        if (this._highlightFrame != null) {
            this._highlightFrame.dispose();
        }
        this._highlightFrame = null;
    }

    public void resetCaptureButtonActionPerformed(ActionEvent e) {
        for (CbusEventRecorder recorder : this.recorders) {
            recorder.capture.setSelected(true);
        }
    }

    public void filterButtonActionPerformed(ActionEvent e) {
        if (this._console != null) {
            this._console.displayPane.filterButton.doClick();
            return;
        }
        if (this._filterFrame == null) {
            this._filterFrame = new CbusFilterFrame(this._console, this);
            this._filterFrame.initComponents();
        } else {
            this._filterFrame.setState(0);
        }
        this._filterFrame.setVisible(true);
    }

    public void highlightButtonActionPerformed(ActionEvent e) {
        if (this._console != null) {
            this._console.displayPane.highlightButton.doClick();
            return;
        }
        if (this._highlightFrame == null) {
            this._highlightFrame = new CbusEventHighlightFrame(null, this);
            this._highlightFrame.initComponents();
        } else {
            this._highlightFrame.setState(0);
        }
        this._highlightFrame.setVisible(true);
    }

    public void setHighlighter(CbusEventHighlightFrame highlightFrame) {
        this._highlightFrame = highlightFrame;
    }

    public void setFilter(CbusFilterFrame filterFrame) {
        this._filterFrame = filterFrame;
    }

    static {
        log = LoggerFactory.getLogger(ConfigToolPane.class);
    }

    public static class Default
    extends CanNamedPaneAction {
        public Default() {
            super(Bundle.getMessage("CapConfigTitle"), new JmriJFrameInterface(), ConfigToolPane.class.getName(), InstanceManager.getDefault(CanSystemConnectionMemo.class));
        }
    }

    private class CbusEventRecorder
    extends JPanel
    implements FocusListener {
        JCheckBox capture = new JCheckBox(Bundle.getMessage("MsgCaptureNext"));
        JTextField event = new JTextField(15);

        CbusEventRecorder() {
            this.init();
            this.event.setEditable(false);
            this.event.setDragEnabled(true);
            this.event.setBackground(Color.WHITE);
            this.capture.setSelected(true);
        }

        final void init() {
            this.event.addFocusListener(this);
            this.setLayout(new BoxLayout(this, 0));
            this.add(this.event);
            this.add(this.capture);
        }

        boolean waiting() {
            return this.capture.isSelected();
        }

        public void processFrame(AbstractMessage m) {
            if (this.capture.isSelected()) {
                int high;
                this.event.setText(CbusMessage.toAddress(m));
                this.capture.setSelected(false);
                int n = high = ConfigToolPane.this._highlightFrame != null ? ConfigToolPane.this._highlightFrame.highlight(m) : -1;
                if (high > -1) {
                    this.event.setBackground(CbusEventHighlightFrame.highlightColors[high]);
                } else {
                    this.event.setBackground(Color.WHITE);
                }
            }
        }

        @Override
        public void focusGained(FocusEvent fe) {
            JTextField txt = (JTextField)fe.getComponent();
            txt.selectAll();
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    private class MakeNamedBean
    extends JPanel {
        private JTextField f1 = new JTextField(15);
        private JTextField f2 = new JTextField(15);
        private JTextField f3 = new JTextField(15);
        private final JButton bc;
        JToggleButton b1 = new JToggleButton(Bundle.getMessage("ButtonCaptureNext"));
        JToggleButton b2 = new JToggleButton(Bundle.getMessage("ButtonCaptureNext"));
        JToggleButton b3 = new JToggleButton(Bundle.getMessage("ButtonCaptureNext"));
        private final JToggleButton[] captureNextButtons = new JToggleButton[]{this.b1, this.b2, this.b3};
        private final JTextField[] fields = new JTextField[]{this.f1, this.f2, this.f3};

        MakeNamedBean(String name1, String name2) {
            this.bc = new JButton(Bundle.getMessage("ButtonCreate"));
            this.bc.addActionListener(e -> {
                if (this.f2.getText().isEmpty()) {
                    this.create(this.f1.getText());
                } else {
                    this.create(this.f1.getText() + ";" + this.f2.getText());
                }
            });
            this.initGui(name1, name2);
        }

        private void initGui(String name1, String name2) {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridwidth = 1;
            c.gridheight = 1;
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 13;
            this.add((Component)new JLabel(Bundle.getMessage(name1)), c);
            c.gridx = 1;
            c.gridy = 0;
            c.anchor = 17;
            this.add((Component)this.f1, c);
            c.gridx = 2;
            c.gridy = 0;
            c.anchor = 17;
            this.add((Component)this.b1, c);
            this.b1.setToolTipText(Bundle.getMessage("CaptureNextTooltip"));
            c.gridx = 0;
            c.gridy = 1;
            c.anchor = 13;
            this.add((Component)new JLabel(Bundle.getMessage(name2)), c);
            c.gridx = 1;
            c.gridy = 1;
            c.anchor = 13;
            this.add((Component)this.f2, c);
            c.gridx = 2;
            c.gridy = 1;
            c.anchor = 17;
            this.add((Component)this.b2, c);
            this.b2.setToolTipText(Bundle.getMessage("CaptureNextTooltip"));
            c.gridx = 1;
            c.gridy = 2;
            c.anchor = 17;
            this.add((Component)this.bc, c);
            this.bc.setToolTipText(Bundle.getMessage("CreateTooltip"));
        }

        void create(String name) {
        }

        public void processFrame(AbstractMessage m) {
            int high = ConfigToolPane.this._highlightFrame != null ? ConfigToolPane.this._highlightFrame.highlight(m) : -1;
            for (int i = 0; i < 3; ++i) {
                if (!this.captureNextButtons[i].isSelected()) continue;
                this.fields[i].setText(CbusMessage.toAddress(m));
                this.captureNextButtons[i].setSelected(false);
                if (high > -1) {
                    this.fields[i].setBackground(CbusEventHighlightFrame.highlightColors[high]);
                    continue;
                }
                this.fields[i].setBackground(Color.WHITE);
            }
        }
    }
}

