/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.console;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrix.AbstractMessage;
import jmri.jmrix.can.CanFrame;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.cbus.CbusEvent;
import jmri.jmrix.can.cbus.CbusMessage;
import jmri.jmrix.can.cbus.CbusNameService;
import jmri.jmrix.can.cbus.CbusOpCodes;
import jmri.jmrix.can.cbus.swing.console.Bundle;
import jmri.jmrix.can.cbus.swing.console.CbusConsolePane;

public class CbusConsoleDecodeOptionsPane
extends JPanel
implements CanListener {
    private final CbusConsolePane _mainPane;
    private final CbusNameService nameService;
    private final UserPreferencesManager p;
    private JCheckBox timeCheckBox;
    private JCheckBox priCheckBox;
    private JCheckBox canidCheckBox;
    private JCheckBox showarrowsCheckBox;
    private JCheckBox showRtrCheckBox;
    private JCheckBox showOpcNameCheckBox;
    private JCheckBox showOpcCheckBox;
    private JCheckBox showOpcExtraCheckBox;
    private JCheckBox showAddressCheckBox;
    private JCheckBox showCanCheckBox;
    private JCheckBox showEvNdName;
    private JCheckBox showJmriBeans;
    private final DateFormat df;
    private static final String SHOWARROWS_CB = ".ShowarrowsCheckBox";
    private static final String TIME_CB = ".TimeCheckBox";
    private static final String SHOWOPC_CB = ".ShowOpcCheckBox";
    private static final String SHOWEVNDNAME_CB = ".ShowEvNdName";
    private static final String SHOWJMRIBEANS_CB = ".ShowJmriBeans";
    private static final String SHOWOPCNAME_CB = ".ShowOpcNameCheckBox";
    private static final String SHOWOPCEXTRA_CB = ".ShowOpcExtraCheckBox";
    private static final String SHOWADDR_CB = ".ShowAddressCheckBox";
    private static final String PRI_CB = ".PriCheckBox";
    private static final String CANID_CB = ".CanidCheckBox";
    private static final String SHOWCAN_CB = ".ShowCanCheckBox";
    private static final String SHOWRTR_CB = ".ShowRtrCheckBox";

    public CbusConsoleDecodeOptionsPane(CbusConsolePane mainPane) {
        this._mainPane = mainPane;
        this.p = InstanceManager.getDefault(UserPreferencesManager.class);
        this.makePane();
        this.df = new SimpleDateFormat("HH:mm:ss.SSS");
        this._mainPane.tc.addCanConsoleListener(this);
        this.nameService = new CbusNameService(this._mainPane.getMemo());
    }

    private void makePane() {
        this.makeCheckBoxes();
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.showarrowsCheckBox);
        this.add(this.timeCheckBox);
        this.add(this.showOpcCheckBox);
        this.add(this.showEvNdName);
        this.add(this.showJmriBeans);
        this.add(this.showOpcNameCheckBox);
        this.add(this.showOpcExtraCheckBox);
        this.add(this.showAddressCheckBox);
        this.add(this.priCheckBox);
        this.add(this.canidCheckBox);
        this.add(this.showCanCheckBox);
        this.add(this.showRtrCheckBox);
    }

    private void makeCheckBoxes() {
        this.timeCheckBox = new JCheckBox(Bundle.getMessage("ButtonShowTimestamp"));
        this.priCheckBox = new JCheckBox(Bundle.getMessage("ButtonShowPriorities"));
        this.canidCheckBox = new JCheckBox(Bundle.getMessage("CanID"));
        this.showarrowsCheckBox = new JCheckBox(Bundle.getMessage("TrafficDirection"));
        this.showRtrCheckBox = new JCheckBox(Bundle.getMessage("RtrCheckbox"));
        this.showOpcCheckBox = new JCheckBox(Bundle.getMessage("showOpcCheckbox"));
        this.showOpcNameCheckBox = new JCheckBox(Bundle.getMessage("OpcName"));
        this.showOpcExtraCheckBox = new JCheckBox(Bundle.getMessage("OpcExtraCheckbox"));
        this.showAddressCheckBox = new JCheckBox(Bundle.getMessage("showAddressCheckBox"));
        this.showCanCheckBox = new JCheckBox(Bundle.getMessage("showCanCheckBox"));
        this.showJmriBeans = new JCheckBox("JMRI");
        this.showEvNdName = new JCheckBox(Bundle.getMessage("MenuItemCBUS"));
        this.initButtonTips();
    }

    private void initButtonTips() {
        this.timeCheckBox.setToolTipText(Bundle.getMessage("TooltipShowTimestamps"));
        this.priCheckBox.setToolTipText(Bundle.getMessage("TooltipShowPrios"));
        this.showarrowsCheckBox.setToolTipText(Bundle.getMessage("TrafficDirectionTip"));
        this.showRtrCheckBox.setToolTipText(Bundle.getMessage("RtrCheckboxTip"));
        this.showOpcCheckBox.setToolTipText(Bundle.getMessage("showOpcCheckboxTip"));
        this.showOpcExtraCheckBox.setToolTipText(Bundle.getMessage("OpcExtraCheckboxTip"));
        this.showAddressCheckBox.setToolTipText(Bundle.getMessage("showAddressCheckBoxTip"));
        this.showCanCheckBox.setToolTipText(Bundle.getMessage("showCanCheckBoxTip"));
        this.showJmriBeans.setToolTipText("<html>Display names from JMRI Turnout, Sensor and Light Table.<br>CBUS Event Table must be Running</html>");
        this.showEvNdName.setToolTipText("<html>Display names from CBUS Event Table and CBUS Node Manager<br>CBUS Event Table and CBUS Node Manager must be started.</html>");
        this.setCheckBoxes();
    }

    private void setCheckBoxes() {
        if (this.p.getSimplePreferenceState(this.getClass().getName() + ".FirstRun")) {
            this.showarrowsCheckBox.setSelected(this.p.getSimplePreferenceState(this.getClass().getName() + SHOWARROWS_CB));
            this.timeCheckBox.setSelected(this.p.getSimplePreferenceState(this.getClass().getName() + TIME_CB));
            this.showOpcCheckBox.setSelected(this.p.getSimplePreferenceState(this.getClass().getName() + SHOWOPC_CB));
            this.showEvNdName.setSelected(this.p.getSimplePreferenceState(this.getClass().getName() + SHOWEVNDNAME_CB));
            this.showJmriBeans.setSelected(this.p.getSimplePreferenceState(this.getClass().getName() + SHOWJMRIBEANS_CB));
            this.showOpcNameCheckBox.setSelected(this.p.getSimplePreferenceState(this.getClass().getName() + SHOWOPCNAME_CB));
            this.showOpcExtraCheckBox.setSelected(this.p.getSimplePreferenceState(this.getClass().getName() + SHOWOPCEXTRA_CB));
            this.showAddressCheckBox.setSelected(this.p.getSimplePreferenceState(this.getClass().getName() + SHOWADDR_CB));
            this.priCheckBox.setSelected(this.p.getSimplePreferenceState(this.getClass().getName() + PRI_CB));
            this.canidCheckBox.setSelected(this.p.getSimplePreferenceState(this.getClass().getName() + CANID_CB));
            this.showCanCheckBox.setSelected(this.p.getSimplePreferenceState(this.getClass().getName() + SHOWCAN_CB));
            this.showRtrCheckBox.setSelected(this.p.getSimplePreferenceState(this.getClass().getName() + SHOWRTR_CB));
        } else {
            this.showarrowsCheckBox.setSelected(true);
            this.showOpcCheckBox.setSelected(true);
            this.showJmriBeans.setSelected(true);
            this.showEvNdName.setSelected(true);
            this.showOpcNameCheckBox.setSelected(true);
        }
    }

    public void addBiDirectionalInfo(AbstractMessage m) {
        if (!(m instanceof CanFrame)) {
            throw new IllegalArgumentException(m + " is Not a CanFrame");
        }
        CanFrame msg = (CanFrame)((Object)m);
        this.updateMainStats(msg);
        StringBuilder output = new StringBuilder();
        this.appendIfChecked(this.showarrowsCheckBox, output, Bundle.getMessage(m instanceof CanMessage ? "CBUS_OUT" : "CBUS_IN"));
        this.appendIfChecked(this.timeCheckBox, output, this.df.format(new Date()));
        if (!msg.isExtended()) {
            this.appendIfChecked(this.showOpcCheckBox, output, CbusOpCodes.decodeopc(m));
        }
        if (msg.isExtended() || this.showEvNdName.isSelected()) {
            output.append(CbusOpCodes.decode(m)).append(" ");
        }
        this.appendJmriBeans(output, m);
        this.processBiDiPt2(output, m, msg);
    }

    private void processBiDiPt2(@Nonnull StringBuilder output, @Nonnull AbstractMessage m, @Nonnull CanFrame msg) {
        if (CbusOpCodes.isKnownOpc(m)) {
            this.appendIfChecked(this.showOpcNameCheckBox, output, Bundle.getMessage("CBUS_" + CbusOpCodes.decodeopc(m)));
            this.appendIfChecked(this.showOpcExtraCheckBox, output, Bundle.getMessage("CTIP_" + CbusOpCodes.decodeopc(m)));
        }
        this.appendIfChecked(this.showAddressCheckBox, output, Bundle.getMessage("addressGrouping", CbusMessage.toAddress(m)));
        this.addPriority(m, msg, output);
        this.appendIfChecked(this.canidCheckBox, output, Bundle.getMessage("CanIDLabel", CbusMessage.getId(m)));
        this.appendIfChecked(this.showCanCheckBox, output, msg.toString());
        this.appendIfChecked(this.showRtrCheckBox, output, Bundle.getMessage(msg.isRtr() ? "IsRtrFrame" : "IsNotRtrFrame"));
        output.append("\n");
        this._mainPane.nextLine((m instanceof CanMessage ? Bundle.getMessage("EventSent") : Bundle.getMessage("EventReceived")) + ": " + m.toMonitorString() + "\n", output.toString(), this._mainPane.displayPane.highlightFrame != null ? this._mainPane.displayPane.highlightFrame.highlight(m) : -1);
    }

    private void updateMainStats(CanFrame msg) {
        this._mainPane.statsPane.incremenetTotal();
        if (CbusMessage.isEvent((AbstractMessage)((Object)msg))) {
            this._mainPane.statsPane.incrementEvents();
        }
        if (!msg.isExtended() && CbusOpCodes.isDcc(CbusMessage.getOpcode((AbstractMessage)((Object)msg)))) {
            this._mainPane.statsPane.incrementDcc();
        }
    }

    private void addPriority(AbstractMessage m, CanFrame cfm, StringBuilder output) {
        if (this.priCheckBox.isSelected() && !cfm.isExtended()) {
            output.append(Bundle.getMessage("DynPriTitle")).append(": ").append(CbusMessage.getPri(m) / 4).append(" ").append(Bundle.getMessage("MinPriTitle")).append(": ").append(CbusMessage.getPri(m) & 3).append(" ");
        }
    }

    private void appendJmriBeans(StringBuilder output, AbstractMessage m) {
        if (this.showJmriBeans.isSelected() && CbusMessage.isEvent(m)) {
            int en = CbusMessage.getEvent(m);
            int nn = CbusMessage.getNodeNumber(m);
            if (!this.showEvNdName.isSelected()) {
                output.append(new CbusEvent(nn, en));
            }
            output.append(this.nameService.getJmriBeans(nn, en, CbusEvent.getEvState(m))).append(" ");
        }
    }

    private void appendIfChecked(JCheckBox box, StringBuilder output, String toAdd) {
        if (box.isSelected()) {
            output.append(toAdd).append(" ");
        }
    }

    @Override
    public void message(CanMessage m) {
        if (this._mainPane.displayPane.filterFrame != null && this._mainPane.displayPane.filterFrame.filter(m)) {
            return;
        }
        this._mainPane.statsPane.incremenetSent();
        this.addBiDirectionalInfo(m);
    }

    @Override
    public void reply(CanReply r) {
        if (this._mainPane.displayPane.filterFrame != null && this._mainPane.displayPane.filterFrame.filter(r)) {
            return;
        }
        this._mainPane.statsPane.incremenetReceived();
        this._mainPane.packetPane.setLastReceived(r);
        this.addBiDirectionalInfo(r);
    }

    public void dispose() {
        this.removeTc(this._mainPane.tc);
        this.p.setSimplePreferenceState(this.getClass().getName() + ".FirstRun", true);
        this.p.setSimplePreferenceState(this.getClass().getName() + SHOWARROWS_CB, this.showarrowsCheckBox.isSelected());
        this.p.setSimplePreferenceState(this.getClass().getName() + TIME_CB, this.timeCheckBox.isSelected());
        this.p.setSimplePreferenceState(this.getClass().getName() + SHOWOPC_CB, this.showOpcCheckBox.isSelected());
        this.p.setSimplePreferenceState(this.getClass().getName() + SHOWEVNDNAME_CB, this.showEvNdName.isSelected());
        this.p.setSimplePreferenceState(this.getClass().getName() + SHOWJMRIBEANS_CB, this.showJmriBeans.isSelected());
        this.p.setSimplePreferenceState(this.getClass().getName() + SHOWOPCNAME_CB, this.showOpcNameCheckBox.isSelected());
        this.p.setSimplePreferenceState(this.getClass().getName() + SHOWOPCEXTRA_CB, this.showOpcExtraCheckBox.isSelected());
        this.p.setSimplePreferenceState(this.getClass().getName() + SHOWADDR_CB, this.showAddressCheckBox.isSelected());
        this.p.setSimplePreferenceState(this.getClass().getName() + PRI_CB, this.priCheckBox.isSelected());
        this.p.setSimplePreferenceState(this.getClass().getName() + CANID_CB, this.canidCheckBox.isSelected());
        this.p.setSimplePreferenceState(this.getClass().getName() + SHOWCAN_CB, this.showCanCheckBox.isSelected());
        this.p.setSimplePreferenceState(this.getClass().getName() + SHOWRTR_CB, this.showRtrCheckBox.isSelected());
    }
}

