/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.console;

import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrix.can.cbus.swing.CbusEventHighlightFrame;
import jmri.jmrix.can.cbus.swing.CbusFilterFrame;
import jmri.jmrix.can.cbus.swing.configtool.ConfigToolPane;
import jmri.jmrix.can.cbus.swing.console.Bundle;
import jmri.jmrix.can.cbus.swing.console.CbusConsolePane;
import jmri.util.JmriJFrame;

public class CbusConsoleDisplayOptionsPane
extends JPanel {
    private final CbusConsolePane _mainPane;
    private final JCheckBox showLogCheckBox;
    private final JCheckBox showStatsCheckBox;
    private final JCheckBox showPacketCheckBox;
    private final JCheckBox showSendEventCheckBox;
    public JButton filterButton;
    public JButton highlightButton;
    protected JButton evCaptureButton;
    protected CbusFilterFrame filterFrame;
    protected CbusEventHighlightFrame highlightFrame;
    private ConfigToolPane _evCapFrame;
    private JmriJFrame _ecf;
    private final UserPreferencesManager p;
    private static final String SHOW_LOG = ".ShowLog";
    private static final String SHOW_STATS = ".ShowStats";
    private static final String SHOW_PACKET = ".ShowPacket";
    private static final String SHOW_SEND_EVENT = ".ShowSendEvent";

    public CbusConsoleDisplayOptionsPane(CbusConsolePane mainPane) {
        this._mainPane = mainPane;
        this.p = InstanceManager.getDefault(UserPreferencesManager.class);
        this.showLogCheckBox = new JCheckBox(Bundle.getMessage("Logging"));
        this.showStatsCheckBox = new JCheckBox(Bundle.getMessage("StatisticsTitle"));
        this.showPacketCheckBox = new JCheckBox(Bundle.getMessage("ButtonShowPackets"));
        this.showSendEventCheckBox = new JCheckBox(Bundle.getMessage("ButtonSendEvent"));
        this.filterButton = new JButton(Bundle.getMessage("ButtonFilter"));
        this.highlightButton = new JButton(Bundle.getMessage("ButtonHighlight"));
        this.evCaptureButton = new JButton(Bundle.getMessage("CapConfigTitle"));
        this.makePane();
    }

    private void makePane() {
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("Display")));
        this.add(this.showLogCheckBox);
        this.add(this.showStatsCheckBox);
        this.add(this.showPacketCheckBox);
        this.add(this.showSendEventCheckBox);
        this.add(this.filterButton);
        this.add(this.highlightButton);
        this.add(this.evCaptureButton);
        this.setDefaults();
        this.setToolTipText();
        this.addListeners();
    }

    private void setDefaults() {
        this.showLogCheckBox.setSelected(this.p.getSimplePreferenceState(this.getClass().getName() + SHOW_LOG));
        this.showStatsCheckBox.setSelected(this.p.getSimplePreferenceState(this.getClass().getName() + SHOW_STATS));
        this.showPacketCheckBox.setSelected(this.p.getSimplePreferenceState(this.getClass().getName() + SHOW_PACKET));
        this.showSendEventCheckBox.setSelected(this.p.getSimplePreferenceState(this.getClass().getName() + SHOW_SEND_EVENT));
    }

    private void setToolTipText() {
        this.showLogCheckBox.setToolTipText(Bundle.getMessage("LoggingTip"));
        this.showStatsCheckBox.setToolTipText(Bundle.getMessage("ButtonShowStats"));
        this.showPacketCheckBox.setToolTipText(Bundle.getMessage("TooltipShowPackets"));
        this.showSendEventCheckBox.setToolTipText(Bundle.getMessage("TooltipShowEvents"));
        this.filterButton.setToolTipText(Bundle.getMessage("TooltipFilter"));
        this.highlightButton.setToolTipText(Bundle.getMessage("TooltipHighlighter"));
    }

    private void addListeners() {
        this.showLogCheckBox.addActionListener(this::matchVisisbleToCheckBoxes);
        this.showStatsCheckBox.addActionListener(this::matchVisisbleToCheckBoxes);
        this.showPacketCheckBox.addActionListener(this::matchVisisbleToCheckBoxes);
        this.showSendEventCheckBox.addActionListener(this::matchVisisbleToCheckBoxes);
        this.filterButton.addActionListener(this::filterButtonActionPerformed);
        this.highlightButton.addActionListener(this::highlightButtonActionPerformed);
        this.evCaptureButton.addActionListener(this::evCaptureButtonActionPerformed);
    }

    public void matchVisisbleToCheckBoxes(ActionEvent e) {
        this._mainPane.logPane.setVisible(this.showLogCheckBox.isSelected());
        this._mainPane.statsPane.setVisible(this.showStatsCheckBox.isSelected());
        this._mainPane.packetPane.setVisible(this.showPacketCheckBox.isSelected());
        this._mainPane.sendPane.setVisible(this.showSendEventCheckBox.isSelected());
        this._mainPane.validate();
    }

    public void filterButtonActionPerformed(ActionEvent e) {
        if (this.filterFrame == null) {
            this.filterFrame = new CbusFilterFrame(this._mainPane, this._evCapFrame);
            this.filterFrame.initComponents();
            if (this._evCapFrame != null) {
                this._evCapFrame.setFilter(this.filterFrame);
            }
        } else {
            this.filterFrame.setState(0);
        }
        this.filterFrame.setVisible(true);
    }

    public void highlightButtonActionPerformed(ActionEvent e) {
        if (this.highlightFrame == null) {
            this.highlightFrame = new CbusEventHighlightFrame(this._mainPane, this._evCapFrame);
            this.highlightFrame.initComponents();
            if (this._evCapFrame != null) {
                this._evCapFrame.setHighlighter(this.highlightFrame);
            }
        } else {
            this.highlightFrame.setState(0);
        }
        this.highlightFrame.setVisible(true);
    }

    public void evCaptureButtonActionPerformed(ActionEvent e) {
        if (this._evCapFrame == null) {
            this._ecf = new JmriJFrame("Event Capture paired to " + this._mainPane.getTitle() + " Filter and Highlighter");
            this._evCapFrame = new ConfigToolPane(this._mainPane, this.filterFrame, this.highlightFrame);
            this._ecf.add(this._evCapFrame);
            this._evCapFrame.initComponents(this._mainPane.getMemo());
            this._ecf.pack();
            this._ecf.setState(0);
        } else {
            this._ecf.setState(0);
        }
        this._ecf.setVisible(true);
    }

    public void dispose() {
        if (this.highlightFrame != null) {
            this.highlightFrame.dispose();
            this.highlightFrame = null;
        }
        if (this.filterFrame != null) {
            this.filterFrame.dispose();
            this.filterFrame = null;
        }
        if (this._ecf != null) {
            this._ecf.dispose();
            this._ecf = null;
        }
        this.p.setSimplePreferenceState(this.getClass().getName() + SHOW_LOG, this.showLogCheckBox.isSelected());
        this.p.setSimplePreferenceState(this.getClass().getName() + SHOW_STATS, this.showStatsCheckBox.isSelected());
        this.p.setSimplePreferenceState(this.getClass().getName() + SHOW_SEND_EVENT, this.showSendEventCheckBox.isSelected());
        this.p.setSimplePreferenceState(this.getClass().getName() + SHOW_PACKET, this.showPacketCheckBox.isSelected());
    }
}

