/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.console;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import jmri.jmrix.can.cbus.swing.console.Bundle;
import jmri.jmrix.can.cbus.swing.console.CbusConsolePane;
import jmri.util.FileUtil;
import jmri.util.swing.JmriJFileChooser;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusConsoleLoggingPane
extends JPanel {
    private final CbusConsolePane _mainPane;
    private final JFileChooser logFileChooser;
    private final JToggleButton startStopLogButton;
    private final JButton openLogFileButton;
    private final JButton openFileChooserButton;
    private final JTextField entryField;
    private final JButton logenterButton;
    private PrintStream logStream;
    private final String newline = System.getProperty("line.separator");
    private static final Logger log = LoggerFactory.getLogger(CbusConsoleLoggingPane.class);

    public CbusConsoleLoggingPane(CbusConsolePane mainPane) {
        this._mainPane = mainPane;
        this.logFileChooser = new JmriJFileChooser(FileUtil.getUserFilesPath());
        this.logFileChooser.setSelectedFile(new File(FileUtil.getUserFilesPath() + "monitorLog.txt"));
        this.startStopLogButton = new JToggleButton();
        this.openLogFileButton = new JButton();
        this.openFileChooserButton = new JButton();
        this.entryField = new JTextField();
        this.logenterButton = new JButton();
        this.setupPane();
    }

    private void setupPane() {
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("Logging")));
        this.setButtonToolTips();
        this.add(this.startStopLogButton);
        this.add(this.openFileChooserButton);
        this.add(this.openLogFileButton);
        this.add(this.logenterButton);
        this.add(this.entryField);
        this.addListeners();
    }

    private void setSelectFileToolTip() {
        this.openFileChooserButton.setToolTipText(this.logFileChooser.getSelectedFile().getPath());
    }

    private void addListeners() {
        this.startStopLogButton.addActionListener(e -> {
            this.openFileChooserButton.setEnabled(!this.startStopLogButton.isSelected());
            if (this.startStopLogButton.isSelected()) {
                this.startLogButtonActionPerformed(e);
            } else {
                this.stopLogButtonActionPerformed(e);
            }
            this.updateStartStopButtonText();
        });
        this.openFileChooserButton.addActionListener(this::openFileChooserButtonActionPerformed);
        this.openLogFileButton.addActionListener(e -> {
            try {
                this.openLogFileActionPerformed(e);
            }
            catch (IOException ex) {
                log.error("log file open exception", (Throwable)ex);
            }
        });
        this.logenterButton.addActionListener(this::textToLogButtonActionPerformed);
        this.entryField.addActionListener(this::textToLogButtonActionPerformed);
        this.updateStartStopButtonText();
    }

    private void setButtonToolTips() {
        this.logenterButton.setText(Bundle.getMessage("ButtonAddMessage"));
        this.logenterButton.setToolTipText(Bundle.getMessage("TooltipAddMessage"));
        this.openFileChooserButton.setText(Bundle.getMessage("ButtonChooseLogFile"));
        this.setSelectFileToolTip();
        this.openLogFileButton.setText(Bundle.getMessage("OpenLogFile"));
        this.openLogFileButton.setToolTipText(Bundle.getMessage("OpenLogFileTip"));
        this.entryField.setToolTipText(Bundle.getMessage("EntryAddtoLogTip"));
    }

    private void updateStartStopButtonText() {
        if (this.startStopLogButton.isSelected()) {
            this.startStopLogButton.setText(Bundle.getMessage("ButtonStopLogging"));
            this.startStopLogButton.setToolTipText(Bundle.getMessage("TooltipStopLogging"));
            this.startStopLogButton.setForeground(Color.red);
        } else {
            this.startStopLogButton.setText(Bundle.getMessage("ButtonStartLogging"));
            this.startStopLogButton.setToolTipText(Bundle.getMessage("TooltipStartLogging") + " " + Bundle.getMessage("ButtonStartLogTipExtra"));
            this.startStopLogButton.setForeground(new JToggleButton().getForeground());
        }
    }

    private void startLogButtonActionPerformed(ActionEvent e) {
        if (this.logStream == null) {
            try {
                this.logStream = new PrintStream(new FileOutputStream(this.logFileChooser.getSelectedFile()));
            }
            catch (FileNotFoundException ex) {
                log.error("exception", (Throwable)ex);
            }
        }
    }

    private void stopLogButtonActionPerformed(ActionEvent e) {
        if (this.logStream != null) {
            this.logStream.flush();
            this.logStream.close();
        }
        this.logStream = null;
    }

    private void openFileChooserButtonActionPerformed(ActionEvent e) {
        int retVal = this.logFileChooser.showSaveDialog(this);
        if (retVal == 0) {
            boolean loggingNow = this.logStream != null;
            this.stopLogButtonActionPerformed(e);
            if (loggingNow) {
                this.startLogButtonActionPerformed(e);
            }
        }
        this.setSelectFileToolTip();
    }

    private void openLogFileActionPerformed(ActionEvent e) throws IOException {
        Desktop desktop = Desktop.getDesktop();
        try {
            File dirToOpen = this.logFileChooser.getSelectedFile();
            desktop.open(dirToOpen);
        }
        catch (IllegalArgumentException iae) {
            JmriJOptionPane.showMessageDialog(this._mainPane, Bundle.getMessage("NoOpenLogFile"), Bundle.getMessage("WarningTitle"), 0);
        }
    }

    private void textToLogButtonActionPerformed(ActionEvent e) {
        this._mainPane.nextLine(this.entryField.getText() + "\n", this.entryField.getText() + "\n", -1);
    }

    protected void sendLogToFile(String sbCbus) {
        if (this.logStream != null) {
            String logLine = sbCbus;
            if (!this.newline.equals("\n")) {
                StringBuilder out = new StringBuilder(sbCbus.length() + 10);
                for (int j = 0; j < sbCbus.length(); ++j) {
                    if (sbCbus.charAt(j) == '\n') {
                        out.append(this.newline);
                        continue;
                    }
                    out.append(sbCbus.charAt(j));
                }
                logLine = new String(out);
            }
            this.logStream.print(logLine);
        }
    }
}

