/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.console;

import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.cbus.CbusMessage;
import jmri.jmrix.can.cbus.swing.console.Bundle;
import jmri.jmrix.can.cbus.swing.console.CbusConsolePane;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.ValidationNotifications;

public class CbusConsolePacketPane
extends JPanel {
    private JTextField[] lastRxDataFields;
    private JPanel rxPacketPane;
    private JPanel sendPacketPane;
    private JTextField lastDynPriField;
    private JTextField lastMinPriField;
    private JTextField dynPriField;
    private JTextField minPriField;
    private JTextField[] dataFields;
    private JButton sendPacketButton;
    private JButton dataClearButton;
    private JButton copyButton;
    private JCheckBox decimalCheckBox;
    private JCheckBox rcvdDecimalCheckBox;
    private final CbusConsolePane _mainPane;
    private int opcToSend;

    public CbusConsolePacketPane(CbusConsolePane mainPane) {
        this._mainPane = mainPane;
        this.initRxPacketPane();
        this.initSendPacketPane();
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.rxPacketPane);
        this.add(this.sendPacketPane);
    }

    private void initRxPacketPane() {
        this.rcvdDecimalCheckBox = new JCheckBox();
        this.rcvdDecimalCheckBox.setText(Bundle.getMessage("ButtonDecimal"));
        this.rcvdDecimalCheckBox.setVisible(true);
        this.rcvdDecimalCheckBox.setToolTipText(Bundle.getMessage("TooltipDecimal"));
        this.rcvdDecimalCheckBox.setSelected(true);
        this.rxPacketPane = new JPanel();
        this.rxPacketPane.setLayout(new BoxLayout(this.rxPacketPane, 0));
        this.rxPacketPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("MostRecentPacketTitle")));
        this.copyButton = new JButton();
        this.copyButton.setText(Bundle.getMessage("ButtonCopy"));
        this.copyButton.setVisible(true);
        this.copyButton.setToolTipText(Bundle.getMessage("TooltipCopyEvent"));
        this.copyButton.addActionListener(this::copyButtonActionPerformed);
        this.initRxPriorityFields();
        this.initRxTextFields();
    }

    private void initSendPacketPane() {
        this.decimalCheckBox = new JCheckBox();
        this.decimalCheckBox.setText(Bundle.getMessage("ButtonDecimal"));
        this.decimalCheckBox.setVisible(true);
        this.decimalCheckBox.setToolTipText(Bundle.getMessage("TooltipDecimal"));
        this.decimalCheckBox.setSelected(true);
        this.sendPacketPane = new JPanel();
        this.sendPacketPane.setLayout(new BoxLayout(this.sendPacketPane, 0));
        this.sendPacketPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("SendPacketTitle")));
        this.dynPriField = new JTextField("2", 4);
        this.dynPriField.setToolTipText(Bundle.getMessage("TooltipDynPri"));
        this.dynPriField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("DynPriTitle")));
        this.sendPacketPane.add(this.dynPriField);
        this.minPriField = new JTextField("3", 4);
        this.minPriField.setToolTipText(Bundle.getMessage("TooltipDinPri03"));
        this.minPriField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("MinPriTitle")));
        this.sendPacketPane.add(this.minPriField);
        this.initSendFields();
    }

    private void initSendFields() {
        this.sendPacketButton = new JButton();
        this.dataClearButton = new JButton();
        this.dataFields = new JTextField[8];
        this.setupTextFields(this.dataFields, this.sendPacketPane);
        this.sendPacketPane.add(this.sendPacketButton);
        this.sendPacketPane.add(this.dataClearButton);
        this.sendPacketPane.add(this.decimalCheckBox);
        this.initButtonBorderToolTips();
        this.sendPacketButton.addActionListener(this::sendPacketButtonActionPerformed);
        this.dataClearButton.addActionListener(this::dataClearButtonActionPerformed);
    }

    private void initRxPriorityFields() {
        this.lastDynPriField = new JTextField("", 4);
        this.lastDynPriField.setToolTipText(Bundle.getMessage("TooltipDynPri"));
        this.lastDynPriField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("DynPriTitle")));
        this.rxPacketPane.add(this.lastDynPriField);
        this.lastMinPriField = new JTextField("", 4);
        this.lastMinPriField.setToolTipText(Bundle.getMessage("TooltipMinPri"));
        this.lastMinPriField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("MinPriTitle")));
        this.rxPacketPane.add(this.lastMinPriField);
    }

    private void initRxTextFields() {
        this.lastRxDataFields = new JTextField[8];
        this.setupTextFields(this.lastRxDataFields, this.rxPacketPane);
        this.rxPacketPane.add(this.copyButton);
        this.rxPacketPane.add(this.rcvdDecimalCheckBox);
    }

    private void setupTextFields(JTextField[] data, JPanel panelToAdd) {
        for (int i = 0; i < 8; ++i) {
            data[i] = new JTextField("", 4);
            if (i == 0) {
                data[i].setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "d0 (OPC)"));
                data[i].setToolTipText(Bundle.getMessage("TooltipOpc"));
            } else {
                data[i].setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "d" + i));
                data[i].setToolTipText(Bundle.getMessage("TooltipDbX", i));
            }
            panelToAdd.add(data[i]);
        }
    }

    private void copyButtonActionPerformed(ActionEvent e) {
        this.dynPriField.setText(this.lastDynPriField.getText());
        this.minPriField.setText(this.lastMinPriField.getText());
        for (int j = 0; j < 8; ++j) {
            this.dataFields[j].setText(this.lastRxDataFields[j].getText());
        }
    }

    private void initButtonBorderToolTips() {
        this.sendPacketButton.setText(Bundle.getMessage("ButtonSend"));
        this.sendPacketButton.setVisible(true);
        this.sendPacketButton.setToolTipText(Bundle.getMessage("TooltipSendPacket"));
        this.dataClearButton.setText(Bundle.getMessage("ButtonClear"));
        this.dataClearButton.setVisible(true);
        this.dataClearButton.setToolTipText(Bundle.getMessage("TooltipClearFields"));
    }

    protected void setLastReceived(CanReply r) {
        if (this.rcvdDecimalCheckBox.isSelected()) {
            this.lastDynPriField.setText(Integer.toString(CbusMessage.getPri(r) / 4));
            this.lastMinPriField.setText(Integer.toString(CbusMessage.getPri(r) & 3));
        } else {
            this.lastDynPriField.setText(Integer.toHexString(CbusMessage.getPri(r) / 4));
            this.lastMinPriField.setText(Integer.toHexString(CbusMessage.getPri(r) & 3));
        }
        for (int j = 0; j < (r.getElement(0) >> 5) + 1; ++j) {
            if (this.rcvdDecimalCheckBox.isSelected()) {
                this.lastRxDataFields[j].setText(Integer.toString(r.getElement(j)));
                continue;
            }
            this.lastRxDataFields[j].setText(Integer.toHexString(r.getElement(j)));
        }
    }

    private void sendPacketButtonActionPerformed(ActionEvent e) {
        CanMessage m = new CanMessage(this._mainPane.tc.getCanid());
        int data = ValidationNotifications.parseBinDecHexByte(this.dynPriField.getText(), 2, this.decimalCheckBox.isSelected(), Bundle.getMessage("DynPriErrorDialog"), this._mainPane);
        if (data == -1) {
            return;
        }
        int data2 = ValidationNotifications.parseBinDecHexByte(this.minPriField.getText(), 3, this.decimalCheckBox.isSelected(), Bundle.getMessage("MinPriErrorDialog"), this._mainPane);
        if (data2 == -1) {
            return;
        }
        m.setHeader(data * 4 + data2);
        int j = this.setPacketData(m);
        if (j < 1) {
            return;
        }
        if (j - 1 != this.opcToSend >> 5) {
            JmriJOptionPane.showMessageDialog(this._mainPane, Bundle.getMessage("OpcCountErrorDialog", this.opcToSend >> 5), Bundle.getMessage("CbusConsoleTitle"), 0);
            return;
        }
        m.setNumDataElements(j);
        this._mainPane.tc.sendCanMessage(m, null);
    }

    private int setPacketData(CanMessage m) {
        int j;
        for (j = 0; j < 8; ++j) {
            if (!this.dataFields[j].getText().isEmpty()) {
                int data = ValidationNotifications.parseBinDecHexByte(this.dataFields[j].getText(), 255, this.decimalCheckBox.isSelected(), Bundle.getMessage("DbxErrorDialog", j), this._mainPane);
                if (data == -1) {
                    return -1;
                }
                m.setElement(j, data);
                if (j != 0) continue;
                this.opcToSend = data;
                continue;
            }
            if (j == 0) {
                JmriJOptionPane.showMessageDialog(this._mainPane, Bundle.getMessage("OpcErrorDialog"), Bundle.getMessage("CbusConsoleTitle"), 0);
            }
            return j;
        }
        return j;
    }

    private void dataClearButtonActionPerformed(ActionEvent e) {
        this.dynPriField.setText("2");
        this.minPriField.setText("3");
        for (int i = 0; i < 8; ++i) {
            this.dataFields[i].setText("");
        }
    }
}

