/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.console;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import jmri.InstanceManager;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.can.cbus.CbusConfigurationManager;
import jmri.jmrix.can.cbus.eventtable.CbusEventTableDataModel;
import jmri.jmrix.can.cbus.swing.CbusEventHighlightFrame;
import jmri.jmrix.can.cbus.swing.CbusSendEventPane;
import jmri.jmrix.can.cbus.swing.console.Bundle;
import jmri.jmrix.can.cbus.swing.console.CbusConsoleDecodeOptionsPane;
import jmri.jmrix.can.cbus.swing.console.CbusConsoleDisplayOptionsPane;
import jmri.jmrix.can.cbus.swing.console.CbusConsoleLogEntry;
import jmri.jmrix.can.cbus.swing.console.CbusConsoleLoggingPane;
import jmri.jmrix.can.cbus.swing.console.CbusConsolePacketPane;
import jmri.jmrix.can.cbus.swing.console.CbusConsoleStatsPane;
import jmri.jmrix.can.swing.CanNamedPaneAction;
import jmri.jmrix.can.swing.CanPanel;
import jmri.util.ThreadingUtil;
import jmri.util.swing.TextAreaFIFO;
import jmri.util.swing.sdi.JmriJFrameInterface;

public class CbusConsolePane
extends CanPanel {
    static int console_instance_num;
    private static final int MAX_LINES = 5000;
    private final ConcurrentLinkedDeque<CbusConsoleLogEntry> logBuffer;
    private JToggleButton freezeButton;
    public TextAreaFIFO monTextPaneCan;
    public TextAreaFIFO monTextPaneCbus;
    private Highlighter cbusHighlighter;
    private Highlighter canHighlighter;
    protected final CbusConsoleStatsPane statsPane;
    protected final CbusConsolePacketPane packetPane;
    protected final CbusSendEventPane sendPane;
    protected CbusConsoleDecodeOptionsPane decodePane;
    protected final CbusConsoleLoggingPane logPane;
    public final CbusConsoleDisplayOptionsPane displayPane;
    protected TrafficController tc;

    public CbusConsolePane() {
        CbusConsolePane.incrementInstance();
        this.logBuffer = new ConcurrentLinkedDeque();
        this.statsPane = new CbusConsoleStatsPane(this);
        this.packetPane = new CbusConsolePacketPane(this);
        this.sendPane = new CbusSendEventPane(this);
        this.logPane = new CbusConsoleLoggingPane(this);
        this.displayPane = new CbusConsoleDisplayOptionsPane(this);
    }

    public static int getConsoleInstanceNum() {
        return console_instance_num;
    }

    public static void incrementInstance() {
        ++console_instance_num;
    }

    @Override
    public String getTitle() {
        if (this.memo != null) {
            StringBuilder title = new StringBuilder(20);
            title.append(this.memo.getUserName()).append(" ");
            title.append(Bundle.getMessage("CbusConsoleTitle"));
            if (CbusConsolePane.getConsoleInstanceNum() > 1) {
                title.append(" ").append(CbusConsolePane.getConsoleInstanceNum());
            }
            return title.toString();
        }
        return Bundle.getMessage("CbusConsoleTitle");
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.can.cbus.swing.console.CbusConsoleFrame";
    }

    @Override
    public void dispose() {
        if (this.decodePane != null) {
            this.decodePane.dispose();
        }
        this.displayPane.dispose();
        this.statsPane.dispose();
        super.dispose();
    }

    @Override
    public void initComponents(CanSystemConnectionMemo memo) {
        this.initComponents(memo, true);
    }

    public void initComponents(CanSystemConnectionMemo memo, boolean launchEvTable) {
        super.initComponents(memo);
        this.tc = memo.getTrafficController();
        this.decodePane = new CbusConsoleDecodeOptionsPane(this);
        if (launchEvTable) {
            memo.get(CbusConfigurationManager.class).provide(CbusEventTableDataModel.class);
        }
        this.init();
    }

    public void init() {
        this.initTextAreas();
        JPanel paneA = new JPanel();
        paneA.setLayout(new BoxLayout(paneA, 1));
        paneA.add(this.getClearFreezeButtonPane());
        paneA.add(this.decodePane);
        JPanel historyPane = new JPanel();
        historyPane.setLayout(new BorderLayout());
        historyPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("PacketHistoryTitle")));
        historyPane.add((Component)this.getSplitPane(), "Center");
        historyPane.add((Component)paneA, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)this.displayPane, "North");
        this.add((Component)historyPane, "Center");
        this.add((Component)this.getAllBottomPanes(), "South");
        this.displayPane.matchVisisbleToCheckBoxes(null);
    }

    private void initTextAreas() {
        this.monTextPaneCan = new TextAreaFIFO(5000);
        this.monTextPaneCan.setVisible(true);
        this.monTextPaneCan.setToolTipText(Bundle.getMessage("TooltipMonTextPaneCan"));
        this.monTextPaneCan.setEditable(false);
        this.monTextPaneCan.setRows(5);
        this.monTextPaneCan.setColumns(5);
        this.monTextPaneCbus = new TextAreaFIFO(5000);
        this.monTextPaneCbus.setVisible(true);
        this.monTextPaneCbus.setToolTipText(Bundle.getMessage("TooltipMonTextPaneCbus"));
        this.monTextPaneCbus.setEditable(false);
        this.monTextPaneCbus.setRows(5);
        this.monTextPaneCbus.setColumns(20);
        this.cbusHighlighter = this.monTextPaneCbus.getHighlighter();
        this.canHighlighter = this.monTextPaneCan.getHighlighter();
    }

    private JSplitPane getSplitPane() {
        JScrollPane jScrollPane1Can = new JScrollPane();
        jScrollPane1Can.getViewport().add(this.monTextPaneCan);
        jScrollPane1Can.setVisible(true);
        jScrollPane1Can.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("CanFrameTitle")));
        JScrollPane jScrollPane1Cbus = new JScrollPane();
        jScrollPane1Cbus.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("CbusMessageTitle")));
        jScrollPane1Cbus.getViewport().add(this.monTextPaneCbus);
        jScrollPane1Cbus.setVisible(true);
        jScrollPane1Can.setHorizontalScrollBarPolicy(31);
        jScrollPane1Cbus.setHorizontalScrollBarPolicy(31);
        jScrollPane1Can.setVerticalScrollBar(jScrollPane1Cbus.getVerticalScrollBar());
        JSplitPane split = new JSplitPane(1, jScrollPane1Can, jScrollPane1Cbus);
        split.setResizeWeight(0.3);
        split.setContinuousLayout(true);
        return split;
    }

    private JPanel getClearFreezeButtonPane() {
        JPanel messageButtonOptionpane = new JPanel();
        JButton clearButton = new JButton();
        this.freezeButton = new JToggleButton();
        clearButton.setText(Bundle.getMessage("ButtonClearScreen"));
        clearButton.setToolTipText(Bundle.getMessage("ButtonClearLogTip"));
        this.freezeButton.setText(Bundle.getMessage("ButtonFreezeScreen"));
        this.freezeButton.setToolTipText(Bundle.getMessage("TooltipStopScroll"));
        messageButtonOptionpane.setLayout(new BoxLayout(messageButtonOptionpane, 0));
        messageButtonOptionpane.add(clearButton);
        messageButtonOptionpane.add(this.freezeButton);
        clearButton.addActionListener(this::clearButtonActionPerformed);
        this.freezeButton.addActionListener(this::freezeButtonActionPerformed);
        return messageButtonOptionpane;
    }

    private JPanel getAllBottomPanes() {
        JPanel southPane = new JPanel();
        southPane.setLayout(new BoxLayout(southPane, 1));
        this.logPane.setVisible(false);
        this.statsPane.setVisible(false);
        this.packetPane.setVisible(false);
        this.sendPane.setVisible(false);
        southPane.add(this.logPane);
        southPane.add(this.statsPane);
        southPane.add(this.packetPane);
        southPane.add(this.sendPane);
        return southPane;
    }

    public void nextLine(String line, String decoded, int highlight) {
        this.logBuffer.add(new CbusConsoleLogEntry(line, decoded, highlight));
        if (!this.freezeButton.isSelected()) {
            ThreadingUtil.runOnGUIEventually(() -> this.processLogBuffer());
        }
        this.logPane.sendLogToFile(decoded);
    }

    private void processLogBuffer() {
        while (!this.logBuffer.isEmpty()) {
            CbusConsoleLogEntry next = this.logBuffer.removeFirst();
            int start = this.monTextPaneCbus.getText().length();
            int startc = this.monTextPaneCan.getText().length();
            this.monTextPaneCan.append(next.getFrameText());
            this.monTextPaneCbus.append(next.getDecodedText());
            if (next.getHighlighter() <= -1) continue;
            try {
                CbusHighlightPainter cbusHighlightPainter = new CbusHighlightPainter(CbusEventHighlightFrame.highlightColors[next.getHighlighter()]);
                this.cbusHighlighter.addHighlight(start, this.monTextPaneCbus.getText().length() - 1, cbusHighlightPainter);
                this.canHighlighter.addHighlight(startc, this.monTextPaneCan.getText().length() - 1, cbusHighlightPainter);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private void clearButtonActionPerformed(ActionEvent e) {
        this.logBuffer.clear();
        this.monTextPaneCan.setText("");
        this.monTextPaneCbus.setText("");
    }

    private void freezeButtonActionPerformed(ActionEvent e) {
        if (this.freezeButton.isSelected()) {
            this.freezeButton.setForeground(Color.red);
        } else {
            this.freezeButton.setForeground(new JTextField().getForeground());
            this.nextLine("", "", -1);
        }
    }

    public static class Default
    extends CanNamedPaneAction {
        public Default() {
            super(Bundle.getMessage("CbusConsoleTitle"), new JmriJFrameInterface(), CbusConsolePane.class.getName(), InstanceManager.getDefault(CanSystemConnectionMemo.class));
        }
    }

    private class CbusHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        protected CbusHighlightPainter(Color color) {
            super(color);
        }
    }
}

