/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.console;

import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.jmrix.can.cbus.swing.console.Bundle;
import jmri.jmrix.can.cbus.swing.console.CbusConsolePane;
import jmri.util.TimerUtil;
import jmri.util.swing.WrapLayout;

public class CbusConsoleStatsPane
extends JPanel {
    private JTextField sentCountField;
    private JTextField rcvdCountField;
    private JTextField eventsCountField;
    private JTextField dccCountField;
    private JTextField totalCountField;
    private JTextField framesLastSecondField;
    private JTextField meanFramesPerSecondField;
    private JTextField maxFramesPerSecondField;
    private JButton statsClearButton;
    private int sentTotal = 0;
    private int rcvdTotal = 0;
    private int eventTotal = 0;
    private int dccTotal = 0;
    private int total = 0;
    private int maxPerSecondCount = 0;
    private long startTime;
    private final LinkedList<Long> frameTimes = new LinkedList();
    private transient TimerTask keepAliveTimer = null;
    private boolean disposed = false;

    public CbusConsoleStatsPane(CbusConsolePane mainPane) {
        this.initButtons();
        this.addToPanel();
        this.setLayout(new WrapLayout());
    }

    private void addToPanel() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("StatisticsTitle")));
        this.add(this.sentCountField);
        this.add(this.rcvdCountField);
        this.add(this.totalCountField);
        this.add(this.eventsCountField);
        this.add(this.dccCountField);
        this.add(this.framesLastSecondField);
        this.add(this.meanFramesPerSecondField);
        this.add(this.maxFramesPerSecondField);
        this.add(this.statsClearButton);
        this.statsClearButton.addActionListener(this::statsClearButtonActionPerformed);
        this.startUpdateTimer();
    }

    protected void incremenetTotal() {
        ++this.total;
        long currentTime = System.currentTimeMillis();
        this.frameTimes.add(currentTime);
        this.countFramesInLastSecond(currentTime);
    }

    protected void incremenetReceived() {
        ++this.rcvdTotal;
    }

    protected void incremenetSent() {
        ++this.sentTotal;
    }

    protected void incrementEvents() {
        ++this.eventTotal;
    }

    protected void incrementDcc() {
        ++this.dccTotal;
    }

    private void initButtons() {
        this.sentCountField = new JTextField("0", 7);
        this.rcvdCountField = new JTextField("0", 7);
        this.eventsCountField = new JTextField("0", 7);
        this.dccCountField = new JTextField("0", 7);
        this.totalCountField = new JTextField("0", 7);
        this.framesLastSecondField = new JTextField("0", 7);
        this.meanFramesPerSecondField = new JTextField("0", 7);
        this.maxFramesPerSecondField = new JTextField("0", 7);
        this.statsClearButton = new JButton();
        this.initButtonBorderToolTips();
    }

    private void initButtonBorderToolTips() {
        this.sentCountField.setToolTipText(Bundle.getMessage("TooltipSent"));
        this.sentCountField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("SentTitle")));
        this.rcvdCountField.setToolTipText(Bundle.getMessage("TooltipReceived"));
        this.rcvdCountField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("ReceivedTitle")));
        this.eventsCountField.setToolTipText(Bundle.getMessage("eventsCountFieldTip"));
        this.eventsCountField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("CbusEvents")));
        this.dccCountField.setToolTipText(Bundle.getMessage("dccCountFieldTip"));
        this.dccCountField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("dccCountField")));
        this.totalCountField.setToolTipText(Bundle.getMessage("totalCountFieldTip"));
        this.totalCountField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("totalCountField")));
        this.framesLastSecondField.setToolTipText(Bundle.getMessage("FramesPerSecondTip"));
        this.framesLastSecondField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("FramesPerSecond")));
        this.meanFramesPerSecondField.setToolTipText(Bundle.getMessage("AverageFramesPerSecondTip"));
        this.meanFramesPerSecondField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("AverageFramesPerSecond")));
        this.maxFramesPerSecondField.setToolTipText(Bundle.getMessage("MaxFramesPerSecondTip"));
        this.maxFramesPerSecondField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("MaxFramesPerSecond")));
        this.statsClearButton.setText(Bundle.getMessage("ButtonReset"));
        this.statsClearButton.setVisible(true);
    }

    private void statsClearButtonActionPerformed(ActionEvent e) {
        this.frameTimes.clear();
        this.startTime = System.currentTimeMillis();
        this.sentTotal = 0;
        this.rcvdTotal = 0;
        this.eventTotal = 0;
        this.dccTotal = 0;
        this.total = 0;
        this.maxPerSecondCount = 0;
    }

    private void startUpdateTimer() {
        this.disposed = false;
        this.startTime = System.currentTimeMillis();
        this.keepAliveTimer = new TimerTask(){

            @Override
            public void run() {
                if (CbusConsoleStatsPane.this.disposed) {
                    return;
                }
                long currentTime = System.currentTimeMillis();
                float secsDuration = (float)(currentTime - CbusConsoleStatsPane.this.startTime) / 1000.0f;
                CbusConsoleStatsPane.this.framesLastSecondField.setText(Integer.toString(CbusConsoleStatsPane.this.countFramesInLastSecond(currentTime)));
                CbusConsoleStatsPane.this.maxFramesPerSecondField.setText(Integer.toString(CbusConsoleStatsPane.this.maxPerSecondCount));
                float average = (float)CbusConsoleStatsPane.this.total / secsDuration;
                CbusConsoleStatsPane.this.meanFramesPerSecondField.setText(String.format(Locale.getDefault(), "%.01f", Float.valueOf(average)));
                CbusConsoleStatsPane.this.totalCountField.setText(Integer.toString(CbusConsoleStatsPane.this.total));
                CbusConsoleStatsPane.this.rcvdCountField.setText(Integer.toString(CbusConsoleStatsPane.this.rcvdTotal));
                CbusConsoleStatsPane.this.sentCountField.setText(Integer.toString(CbusConsoleStatsPane.this.sentTotal));
                CbusConsoleStatsPane.this.eventsCountField.setText(Integer.toString(CbusConsoleStatsPane.this.eventTotal));
                CbusConsoleStatsPane.this.dccCountField.setText(Integer.toString(CbusConsoleStatsPane.this.dccTotal));
                CbusConsoleStatsPane.this.statsClearButton.setToolTipText(Bundle.getMessage("ResetButtonLastRestTip", String.format(Locale.getDefault(), "%.01f", Float.valueOf(secsDuration))));
                TimerUtil.scheduleOnGUIThread(CbusConsoleStatsPane.this.keepAliveTimer, 500L);
            }
        };
        TimerUtil.scheduleOnGUIThread(this.keepAliveTimer, 500L);
    }

    private int countFramesInLastSecond(long currentTime) {
        while (!this.frameTimes.isEmpty() && currentTime - this.frameTimes.peek() > 1000L) {
            this.frameTimes.remove();
        }
        this.maxPerSecondCount = Math.max(this.maxPerSecondCount, this.frameTimes.size());
        return this.frameTimes.size();
    }

    public void dispose() {
        this.disposed = true;
        if (this.keepAliveTimer != null) {
            this.keepAliveTimer.cancel();
            this.keepAliveTimer = null;
        }
    }
}

