/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.eventrequestmonitor;

import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.Timer;
import jmri.jmrix.can.cbus.CbusEvent;
import jmri.jmrix.can.cbus.CbusEventDataElements;
import jmri.jmrix.can.cbus.swing.eventrequestmonitor.Bundle;
import jmri.jmrix.can.cbus.swing.eventrequestmonitor.CbusEventRequestDataModel;

public class CbusEventRequestMonitorEvent
extends CbusEvent {
    private ActionListener eventFeedbackListener;
    private final CbusEventRequestDataModel _model;
    private Date _timestamp;
    private int _feedbackTimeout;
    private int _feedbackTotReqd;
    private int _extraEvent;
    private int _extraNode;
    private int _feedbackOutstanding;
    private FbState _lfb;
    private Timer _timer;

    public CbusEventRequestMonitorEvent(int nn, int en, CbusEventDataElements.EvState state, Date timestamp, int feedbackTimeout, int feedbackTotReqd, CbusEventRequestDataModel model) {
        super(nn, en);
        this._state = state;
        this._model = model;
        this._timestamp = timestamp;
        this._feedbackTimeout = feedbackTimeout;
        this._feedbackTotReqd = feedbackTotReqd;
        this._extraEvent = 0;
        this._extraNode = 0;
        this._feedbackOutstanding = 0;
        this._lfb = FbState.LfbUnknown;
        this._timer = null;
    }

    public Boolean matchesFeedback(int nn, int en) {
        return nn == this._extraNode && en == this._extraEvent;
    }

    protected Date getDate() {
        return this._timestamp;
    }

    protected void setDate(Date newval) {
        this._timestamp = newval;
    }

    protected void setFeedbackTimeout(int newval) {
        this._feedbackTimeout = newval;
    }

    protected int getFeedbackTimeout() {
        return this._feedbackTimeout;
    }

    protected int getFeedbackTotReqd() {
        return this._feedbackTotReqd;
    }

    protected void setFeedbackTotReqd(int newval) {
        this._feedbackTotReqd = newval;
    }

    protected int getExtraEvent() {
        return this._extraEvent;
    }

    protected int getExtraNode() {
        return this._extraNode;
    }

    protected void setExtraEvent(int newval) {
        this._extraEvent = newval;
    }

    protected void setExtraNode(int newval) {
        this._extraNode = newval;
    }

    protected void setFeedbackOutstanding(int newval) {
        this._feedbackOutstanding = newval;
    }

    protected int getFeedbackOutstanding() {
        return this._feedbackOutstanding;
    }

    protected FbState getLastFb() {
        return this._lfb;
    }

    protected void setLastFb(FbState newval) {
        this._lfb = newval;
    }

    protected void setRequestReceived() {
        this._feedbackOutstanding = this._feedbackTotReqd;
        this._model.setValueAt((Object)FbState.LfbFinding, this._model.eventRow(this.getNn(), this.getEn()), 5);
        this._model.setValueAt(this.getFeedbackOutstanding(), this._model.eventRow(this.getNn(), this.getEn()), 6);
        if (this.getFeedbackTotReqd() > 0) {
            this.startTheTimer();
        }
    }

    private void startTheTimer() {
        String _evName = this.toString();
        this.eventFeedbackListener = e -> {
            this._model.setValueAt(0, this._model.eventRow(this.getNn(), this.getEn()), 6);
            this._model.setValueAt((Object)FbState.LfbBad, this._model.eventRow(this.getNn(), this.getEn()), 5);
            this._model.addToLog(3, Bundle.getMessage("FeedBackNotOK", _evName));
            this._timer.stop();
            this._timer = null;
        };
        this._timer = new Timer(this.getFeedbackTimeout(), this.eventFeedbackListener);
        this._timer.setRepeats(false);
        this._timer.start();
    }

    protected void stopTheTimer() {
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
        }
        this.eventFeedbackListener = null;
    }

    protected void setResponseReceived() {
        if (this._feedbackOutstanding < 0) {
            return;
        }
        --this._feedbackOutstanding;
        if (this._feedbackOutstanding > 0) {
            this._model.setValueAt(this._feedbackOutstanding, this._model.eventRow(this.getNn(), this.getEn()), 6);
        }
        if (this._feedbackOutstanding == 0) {
            this._model.setValueAt(this._feedbackOutstanding, this._model.eventRow(this.getNn(), this.getEn()), 6);
            if (this._timer != null) {
                this.stopTheTimer();
                this._model.setValueAt((Object)FbState.LfbGood, this._model.eventRow(this.getNn(), this.getEn()), 5);
                this._model.addToLog(2, Bundle.getMessage("FeedBackOK", this.toString()));
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public static enum FbState {
        LfbFinding,
        LfbGood,
        LfbBad,
        LfbUnknown;

    }
}

