/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.eventrequestmonitor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jmri.InstanceManager;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.CbusEventDataElements;
import jmri.jmrix.can.cbus.swing.CbusCommonSwing;
import jmri.jmrix.can.cbus.swing.CbusNewEventPane;
import jmri.jmrix.can.cbus.swing.eventrequestmonitor.Bundle;
import jmri.jmrix.can.cbus.swing.eventrequestmonitor.CbusEventRequestDataModel;
import jmri.jmrix.can.cbus.swing.eventrequestmonitor.CbusEventRequestMonitorEvent;
import jmri.jmrix.can.swing.CanNamedPaneAction;
import jmri.jmrix.can.swing.CanPanel;
import jmri.util.swing.StayOpenCheckBoxItem;
import jmri.util.swing.XTableColumnModel;
import jmri.util.swing.sdi.JmriJFrameInterface;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import jmri.util.table.JTableWithColumnToolTips;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusEventRequestTablePane
extends CanPanel
implements TableModelListener {
    protected CbusEventRequestDataModel eventModel;
    protected JTable eventTable;
    private JScrollPane eventScroll;
    private JSplitPane split;
    private CbusNewEventPane neweventcontainer;
    private final double _splitratio = 0.95;
    private JScrollPane scrolltablefeedback;
    public static final Color VERY_LIGHT_RED = new Color(255, 176, 173);
    public static final Color VERY_LIGHT_GREEN = new Color(165, 255, 164);
    public static final Color GOLD = new Color(255, 204, 51);
    private final JMenu evColMenu = new JMenu(Bundle.getMessage("evColMenuName"));
    private final JMenu evFbMenu = new JMenu(Bundle.getMessage("evFbMenuName"));
    private static final Logger log = LoggerFactory.getLogger(CbusEventRequestTablePane.class);

    @Override
    public void initComponents(CanSystemConnectionMemo memo) {
        super.initComponents(memo);
        this.eventModel = new CbusEventRequestDataModel(memo, 10, 12);
        this.init();
    }

    public void init() {
        JTableWithColumnToolTips _evReqTable = new JTableWithColumnToolTips((TableModel)this.eventModel, CbusEventRequestDataModel.columnToolTips);
        XTableColumnModel tcm = new XTableColumnModel();
        _evReqTable.setColumnModel(tcm);
        this.scrolltablefeedback = new JScrollPane(this.eventModel.tablefeedback());
        CbusCommonSwing.configureTable(_evReqTable);
        tcm.getColumn(7).setCellRenderer(new OsRenderer());
        tcm.getColumn(6).setCellRenderer(new OsRenderer());
        tcm.getColumn(9).setCellRenderer(new OsRenderer());
        tcm.getColumn(10).setCellRenderer(new OsRenderer());
        tcm.getColumn(8).setCellRenderer(new OsRenderer());
        tcm.getColumn(5).setCellRenderer(new LafbRenderer());
        tcm.getColumn(3).setCellRenderer(new TimeStampRenderer());
        TableColumn delBColumn = tcm.getColumn(11);
        delBColumn.setCellEditor(new ButtonEditor(new JButton()));
        delBColumn.setCellRenderer(new ButtonRenderer());
        TableColumn rqStatColumn = tcm.getColumn(4);
        rqStatColumn.setCellEditor(new ButtonEditor(new JButton()));
        rqStatColumn.setCellRenderer(new ButtonRenderer());
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            int colnumber = i;
            String colName = _evReqTable.getColumnName(colnumber);
            StayOpenCheckBoxItem showcol = new StayOpenCheckBoxItem(colName);
            showcol.setToolTipText(CbusEventRequestDataModel.columnToolTips[i]);
            showcol.setSelected(true);
            switch (colnumber) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 11: {
                    this.evColMenu.add(showcol);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    this.evFbMenu.add(showcol);
                    break;
                }
                default: {
                    log.warn("No menuitem defined for {}", (Object)colnumber);
                }
            }
            showcol.addActionListener(e -> {
                TableColumn column;
                boolean visible1 = tcm.isColumnVisible(column = tcm.getColumnByModelIndex(colnumber));
                tcm.setColumnVisible(column, !visible1);
            });
        }
        this.eventModel.addTableModelListener(this);
        this.setLayout(new BoxLayout(this, 1));
        JPanel _pane1 = new JPanel();
        _pane1.setLayout(new BorderLayout());
        JPanel _toppanelcontainer = new JPanel();
        _toppanelcontainer.setLayout(new BoxLayout(_toppanelcontainer, 0));
        this.eventScroll = new JScrollPane(_evReqTable);
        this.eventScroll.setPreferredSize(new Dimension(450, 200));
        this.neweventcontainer = new CbusNewEventPane(this);
        _toppanelcontainer.add(this.neweventcontainer);
        _pane1.add((Component)_toppanelcontainer, "First");
        this.split = new JSplitPane(0, this.eventScroll, this.scrolltablefeedback);
        this.split.setResizeWeight(0.95);
        this.split.setContinuousLayout(true);
        _pane1.add((Component)this.split, "Center");
        this.add(_pane1);
        _pane1.setVisible(true);
    }

    public void addEvent(int nn, int en) {
        if (this.eventModel.eventRow(nn, en) < 0) {
            this.eventModel.addEvent(nn, en, CbusEventDataElements.EvState.UNKNOWN, null);
        }
        this.tableChanged(null);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.neweventcontainer.setNewButtonActive(this.eventModel.eventRow(this.neweventcontainer.getNn(), this.neweventcontainer.getEn()) < 0);
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.can.cbus.swing.eventrequestmonitor.CbusEventRequestTablePane";
    }

    @Override
    public List<JMenu> getMenus() {
        ArrayList<JMenu> menuList = new ArrayList<JMenu>();
        JMenu displayMenu = new JMenu(Bundle.getMessage("Display"));
        JCheckBoxMenuItem shownewevent = new JCheckBoxMenuItem(Bundle.getMessage("NewEvent"));
        shownewevent.setSelected(true);
        shownewevent.addActionListener(e -> this.neweventcontainer.setVisible(shownewevent.isSelected()));
        JCheckBoxMenuItem showinfopanel = new JCheckBoxMenuItem(Bundle.getMessage("ShowInfoPanel"));
        showinfopanel.setSelected(true);
        showinfopanel.addActionListener(e -> {
            this.scrolltablefeedback.setVisible(showinfopanel.isSelected());
            this.validate();
            this.repaint();
            this.split.setDividerLocation(0.95);
        });
        displayMenu.add(shownewevent);
        displayMenu.add(showinfopanel);
        menuList.add(this.evColMenu);
        menuList.add(this.evFbMenu);
        menuList.add(displayMenu);
        return menuList;
    }

    @Override
    public String getTitle() {
        return this.prependConnToString(Bundle.getMessage("MenuItemEvRequestMon"));
    }

    @Override
    public void dispose() {
        this.eventModel.removeTableModelListener(this);
        this.eventModel.dispose();
        this.eventModel = null;
        this.eventTable = null;
        this.eventScroll = null;
        super.dispose();
    }

    public static class Default
    extends CanNamedPaneAction {
        public Default() {
            super(Bundle.getMessage("MenuItemEvRequestMon"), new JmriJFrameInterface(), CbusEventRequestTablePane.class.getName(), InstanceManager.getDefault(CanSystemConnectionMemo.class));
        }
    }

    private static class LafbRenderer
    extends DefaultTableCellRenderer {
        private LafbRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel c = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof CbusEventRequestMonitorEvent.FbState) {
                if (Objects.equals(value, (Object)CbusEventRequestMonitorEvent.FbState.LfbFinding)) {
                    c.setText(Bundle.getMessage("LfbFinding"));
                    c.setBackground(GOLD);
                    c.setForeground(table.getForeground());
                } else if (Objects.equals(value, (Object)CbusEventRequestMonitorEvent.FbState.LfbGood)) {
                    c.setText(Bundle.getMessage("LfbGood"));
                    c.setBackground(VERY_LIGHT_GREEN);
                    c.setForeground(table.getForeground());
                } else if (Objects.equals(value, (Object)CbusEventRequestMonitorEvent.FbState.LfbBad)) {
                    c.setText(Bundle.getMessage("LfbBad"));
                    c.setBackground(VERY_LIGHT_RED);
                    c.setForeground(table.getForeground());
                } else if (isSelected) {
                    c.setBackground(table.getSelectionBackground());
                    c.setForeground(table.getSelectionBackground());
                } else {
                    c.setBackground(table.getBackground());
                    c.setForeground(table.getBackground());
                }
            }
            return c;
        }
    }

    private static class OsRenderer
    extends DefaultTableCellRenderer {
        private OsRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cellComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int val = (Integer)value;
            if (val > 0) {
                cellComponent.setBackground(GOLD);
                cellComponent.setForeground(table.getForeground());
            } else if (isSelected) {
                cellComponent.setBackground(table.getSelectionBackground());
                cellComponent.setForeground(table.getSelectionBackground());
            } else {
                cellComponent.setBackground(table.getBackground());
                cellComponent.setForeground(table.getBackground());
            }
            return cellComponent;
        }
    }

    private static class TimeStampRenderer
    extends DefaultTableCellRenderer {
        private TimeStampRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel c = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null && value instanceof Date) {
                c.setText(new SimpleDateFormat("HH:mm:ss").format((Date)value));
            }
            return c;
        }
    }
}

