/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.eventtable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import jmri.Light;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.Turnout;
import jmri.jmrix.can.cbus.eventtable.CbusEventBeanData;
import jmri.jmrix.can.cbus.swing.CbusCommonSwing;
import jmri.jmrix.can.cbus.swing.eventtable.CbusBeanRenderer;

public class CbusEventBeanCellRenderer
implements TableCellRenderer {
    private final JTextField _filterText;
    private final CbusBeanRenderer _beanImages;
    private JPanel f;

    public CbusEventBeanCellRenderer(@Nonnull JTextField filterText, int iconHeight) {
        this._filterText = filterText;
        this._beanImages = new CbusBeanRenderer(iconHeight);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.f = new JPanel();
        this.f.setLayout(new BorderLayout());
        if (value instanceof CbusEventBeanData && !value.toString().isEmpty()) {
            JTextField tf = new JTextField(value.toString());
            CbusCommonSwing.setCellTextHighlighter(this._filterText.getText(), value.toString(), tf);
            tf.setBorder(null);
            tf.setOpaque(false);
            tf.setHorizontalAlignment(0);
            this.f.add((Component)tf, "Center");
            JPanel yy = new JPanel();
            yy.setLayout(new GridBagLayout());
            yy.setOpaque(false);
            ((CbusEventBeanData)value).getActionA().forEach(n -> this.appendImgToPanel(yy, (NamedBean)n, true));
            ((CbusEventBeanData)value).getActionB().forEach(n -> this.appendImgToPanel(yy, (NamedBean)n, false));
            this.f.add((Component)yy, "Before");
        }
        CbusCommonSwing.setCellBackground(isSelected, this.f, table, row);
        CbusCommonSwing.setCellFocus(hasFocus, this.f, table);
        return this.f;
    }

    private void appendImgToPanel(JPanel pnl, NamedBean bean, boolean beanOn) {
        JLabel lbl;
        if (bean instanceof Turnout) {
            lbl = new JLabel(this._beanImages.getBeanIcon("T", beanOn ? 2 : 4));
        } else if (bean instanceof Sensor) {
            lbl = new JLabel(this._beanImages.getBeanIcon("S", beanOn ? 2 : 4));
        } else if (bean instanceof Light) {
            lbl = new JLabel(this._beanImages.getBeanIcon("L", beanOn ? 2 : 4));
        } else {
            return;
        }
        lbl.setOpaque(false);
        JPanel tmp = new JPanel();
        tmp.setLayout(new GridBagLayout());
        tmp.setOpaque(false);
        tmp.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        tmp.add(lbl);
        pnl.add(tmp);
    }
}

