/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.eventtable;

import java.awt.Component;
import java.awt.Dimension;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.regex.PatternSyntaxException;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import jmri.InstanceManager;
import jmri.jmrix.can.cbus.eventtable.CbusEventTableDataModel;
import jmri.jmrix.can.cbus.eventtable.CbusTableEvent;
import jmri.jmrix.can.cbus.swing.CbusCommonSwing;
import jmri.jmrix.can.cbus.swing.CbusTableRowEventDnDHandler;
import jmri.jmrix.can.cbus.swing.eventtable.Bundle;
import jmri.jmrix.can.cbus.swing.eventtable.CbusEventBeanCellRenderer;
import jmri.jmrix.can.cbus.swing.eventtable.CbusEventTablePane;
import jmri.swing.JmriJTablePersistenceManager;
import jmri.util.swing.StayOpenCheckBoxItem;
import jmri.util.swing.XTableColumnModel;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;

public class CbusEventTable
extends JScrollPane
implements TableModelListener {
    private final CbusEventTablePane _mainPane;
    private CbusTableRowEventDnDHandler eventDragHandler;
    private TableRowSorter<CbusEventTableDataModel> sorter;
    private final DateFormat DATE_FORMAT = new SimpleDateFormat("HH:mm:ss EEE d MMM yyyy");
    private static final int[] EVENT_COL_MENU = new int[]{2, 0, 1, 3, 4, 23, 24};
    private static final int[] LATEST_COL_MENU = new int[]{5, 9, 10, 25, 26, 27};

    public CbusEventTable(CbusEventTablePane mainPane) {
        super(mainPane.eventTable);
        this._mainPane = mainPane;
        this.init();
    }

    final void init() {
        CbusCommonSwing.configureTable(this._mainPane.eventTable);
        this.setPreferredSize(new Dimension(450, 200));
        this.setColumnRenderers((XTableColumnModel)this._mainPane.eventTable.getColumnModel());
        this.initColumnVisibleCheckboxes();
        this._mainPane.eventModel.addTableModelListener(this);
        this.sorter = new TableRowSorter<CbusEventTableDataModel>(this._mainPane.eventModel);
        this._mainPane.eventTable.setRowSorter(this.sorter);
        this._mainPane.eventTable.setDragEnabled(true);
        this._mainPane.eventTable.setDropMode(DropMode.ON);
        this.eventDragHandler = new CbusTableRowEventDnDHandler(this._mainPane.getMemo(), this._mainPane.eventTable);
        this._mainPane.eventTable.setTransferHandler(this.eventDragHandler);
    }

    private void initColumnVisibleCheckboxes() {
        JMenuItem resetSession = new JMenuItem(Bundle.getMessage("ResetSessionCount"));
        resetSession.addActionListener(e -> this._mainPane.eventModel.ta.resetAllSessionTotals());
        this._mainPane.evStatMenu.add(resetSession);
        this._mainPane.evStatMenu.add(new JSeparator());
        StayOpenCheckBoxItem[] cbArray = new StayOpenCheckBoxItem[this._mainPane.eventModel.getColumnCount()];
        for (int i = 0; i < this._mainPane.eventModel.getColumnCount(); ++i) {
            StayOpenCheckBoxItem cbi;
            cbArray[i] = cbi = new StayOpenCheckBoxItem(this._mainPane.eventModel.getColumnName(i));
            cbArray[i].setToolTipText(CbusEventTableDataModel.CBUS_EV_TABLE_COL_TOOLTIPS[i]);
            TableColumn column = ((XTableColumnModel)this._mainPane.eventTable.getColumnModel()).getColumnByModelIndex(i);
            cbi.addActionListener(e -> ((XTableColumnModel)this._mainPane.eventTable.getColumnModel()).setColumnVisible(column, cbi.isSelected()));
            int ii = i;
            ((XTableColumnModel)this._mainPane.eventTable.getColumnModel()).setColumnVisible(((XTableColumnModel)this._mainPane.eventTable.getColumnModel()).getColumnByModelIndex(i), Arrays.stream(CbusEventTableDataModel.INITIAL_COLS).anyMatch(j -> j == ii));
        }
        InstanceManager.getOptionalDefault(JmriJTablePersistenceManager.class).ifPresent(tpm -> tpm.persist(this._mainPane.eventTable, true));
        XTableColumnModel tcm = (XTableColumnModel)this._mainPane.eventTable.getColumnModel();
        for (int i = 0; i < this._mainPane.eventModel.getColumnCount(); ++i) {
            cbArray[i].setSelected(tcm.isColumnVisible(tcm.getColumnByModelIndex(i)));
            int finali = i;
            if (Arrays.stream(EVENT_COL_MENU).anyMatch(j -> j == finali)) {
                this._mainPane.evColMenu.add(cbArray[i]);
                continue;
            }
            if (Arrays.stream(LATEST_COL_MENU).anyMatch(j -> j == finali)) {
                this._mainPane.evJmMenu.add(cbArray[i]);
                continue;
            }
            if (Arrays.stream(CbusEventTableDataModel.BUTTON_COLUMNS).anyMatch(j -> j == finali)) {
                this._mainPane.buttonMenu.add(cbArray[i]);
                continue;
            }
            this._mainPane.evStatMenu.add(cbArray[i]);
        }
        this._mainPane.evStatMenu.add((Component)new JSeparator(), 7);
        this._mainPane.evColMenu.add((Component)new JSeparator(), 5);
        this._mainPane.evJmMenu.add((Component)new JSeparator(), 3);
    }

    private void setColumnRenderers(XTableColumnModel tcm) {
        for (int i = 0; i < 28; ++i) {
            int finali = i;
            if (Arrays.stream(CbusEventTableDataModel.BUTTON_COLUMNS).anyMatch(j -> j == finali)) {
                tcm.getColumn(i).setCellEditor(new ButtonEditor(new JButton()));
                tcm.getColumn(i).setCellRenderer(new ButtonRenderer());
                continue;
            }
            if (i == 23 || i == 24) {
                tcm.getColumn(i).setCellRenderer(new CbusEventBeanCellRenderer(this._mainPane.filterText, 22));
                continue;
            }
            tcm.getColumn(i).setCellRenderer(this.getRenderer());
        }
    }

    private TableCellRenderer getRenderer() {
        return new TableCellRenderer(){
            JTextField f = new JTextField();

            @Override
            public Component getTableCellRendererComponent(JTable table, Object arg1, boolean isSelected, boolean hasFocus, int row, int col) {
                if (arg1 != null) {
                    String string = arg1.toString();
                    this.f.setText(string);
                    this.f.setHorizontalAlignment(0);
                    if (col != 1) {
                        CbusCommonSwing.hideNumbersLessThan(1, string, this.f);
                    }
                    CbusCommonSwing.setCellTextHighlighter(CbusEventTable.this._mainPane.filterText.getText(), string, this.f);
                    CbusCommonSwing.setCellFromDate(arg1, this.f, CbusEventTable.this.DATE_FORMAT);
                } else {
                    this.f.setText("");
                    this.f.getHighlighter().removeAllHighlights();
                }
                CbusCommonSwing.setCellBackground(isSelected, this.f, table, row);
                CbusCommonSwing.setCellFocus(hasFocus, this.f, table);
                CbusCommonSwing.setCellFromCbusEventEnum(arg1, this.f);
                return this.f;
            }
        };
    }

    protected void addFilterListener(JTextField filter) {
        filter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CbusEventTable.this.update(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CbusEventTable.this.update(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CbusEventTable.this.update(e);
            }
        });
    }

    public void update(DocumentEvent e) {
        String textForSearch = this._mainPane.filterText.getText();
        if (textForSearch.length() == 0) {
            this.sorter.setRowFilter(null);
            this._mainPane.clearfilterButton.setEnabled(false);
        } else {
            this._mainPane.clearfilterButton.setEnabled(true);
            try {
                this.sorter.setRowFilter(RowFilter.regexFilter("(?i)" + textForSearch, new int[0]));
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this._mainPane.neweventcontainer.setNewButtonActive(!this._mainPane.eventModel.getEvents().contains(new CbusTableEvent(null, this._mainPane.neweventcontainer.getNn(), this._mainPane.neweventcontainer.getEn())));
    }

    public void addEvent(int nn, int en) {
        this._mainPane.eventModel.provideEvent(nn, en);
        this.tableChanged(null);
    }

    public void dispose() {
        this._mainPane.eventModel.removeTableModelListener(this);
        this.eventDragHandler.dispose();
    }
}

