/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.eventtable;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import jmri.jmrix.can.cbus.eventtable.CbusEventTableDataModel;
import jmri.util.ThreadingUtil;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusEventTablePrintAction
extends AbstractAction {
    private static final int[] whichPrintColumns = new int[]{0, 1, 2, 3, 4};
    private final String _title;
    private final CbusEventTableDataModel _model;
    private final boolean _preview;
    private static final Logger log = LoggerFactory.getLogger(CbusEventTablePrintAction.class);

    public CbusEventTablePrintAction(String actionName, @Nonnull CbusEventTableDataModel model, @Nonnull String title, boolean preview) {
        super(actionName);
        this._model = model;
        this._title = title;
        this._preview = preview;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ThreadingUtil.runOnGUIEventually(() -> {
            HardcopyWriter writer;
            try {
                writer = new HardcopyWriter(new Frame(), this._title, 10, 0.8, 0.5, 0.5, 0.5, this._preview);
            }
            catch (HardcopyWriter.PrintCanceledException ex) {
                return;
            }
            writer.increaseLineSpacing(20);
            this.printTable(writer);
            writer.close();
        });
    }

    private void printTable(HardcopyWriter w) {
        String[] columnStrings = new String[whichPrintColumns.length];
        int[] columnWidth = new int[whichPrintColumns.length];
        this.colWidthLoop(columnStrings, columnWidth, w);
        w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), w.getCharactersPerLine());
        w.setFontStyle(1);
        this.printColumns(w, columnStrings, columnWidth);
        w.setFontStyle(0);
        w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), w.getCharactersPerLine());
        this.getEachRow(w, columnStrings, columnWidth);
    }

    private void colWidthLoop(String[] columnStrings, int[] columnWidth, HardcopyWriter w) {
        int columnTotal = 0;
        for (int i = 0; i < whichPrintColumns.length; ++i) {
            columnStrings[i] = this._model.getColumnName(whichPrintColumns[i]);
            int columnworkedon = whichPrintColumns[i];
            if (CbusEventTablePrintAction.getColumnWidth(columnworkedon) == 0) {
                columnWidth[i] = w.getCharactersPerLine() - columnTotal;
                continue;
            }
            columnWidth[i] = CbusEventTablePrintAction.getColumnWidth(columnworkedon);
            columnTotal = columnTotal + columnWidth[i] + 1;
        }
    }

    private void getEachRow(HardcopyWriter w, String[] columnStrings, int[] columnWidth) {
        for (int i = 0; i < this._model.getRowCount(); ++i) {
            for (int k = 0; k < whichPrintColumns.length; ++k) {
                int j = whichPrintColumns[k];
                columnStrings[k] = this._model.getValueAt(i, j) instanceof Integer ? this._model.getValueAt(i, j).toString() : (String)this._model.getValueAt(i, j);
            }
            this.printColumns(w, columnStrings, columnWidth);
            w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), w.getCharactersPerLine());
        }
    }

    private void printColumns(HardcopyWriter w, String[] columnStrings, int[] columnWidth) {
        Object columnString = "";
        StringBuilder lineString = new StringBuilder();
        boolean complete = false;
        while (!complete) {
            complete = true;
            for (int i = 0; i < columnStrings.length; ++i) {
                StringBuilder buf = new StringBuilder();
                for (int j = 0; j < columnWidth[i]; ++j) {
                    buf.append(" ");
                }
                String spaces = buf.toString();
                if (columnStrings[i].length() > columnWidth[i]) {
                    boolean noWord = true;
                    for (int k = columnWidth[i]; k >= 1; --k) {
                        if (!columnStrings[i].substring(k - 1, k).equals(" ") && !columnStrings[i].substring(k - 1, k).equals("-") && !columnStrings[i].substring(k - 1, k).equals("_")) continue;
                        columnString = columnStrings[i].substring(0, k) + spaces.substring(k);
                        columnStrings[i] = columnStrings[i].substring(k);
                        noWord = false;
                        complete = false;
                        break;
                    }
                    if (noWord) {
                        columnString = columnStrings[i].substring(0, columnWidth[i]);
                        columnStrings[i] = columnStrings[i].substring(columnWidth[i]);
                        complete = false;
                    }
                } else {
                    columnString = columnStrings[i] + spaces.substring(columnStrings[i].length());
                    columnStrings[i] = "";
                }
                lineString.append((String)columnString).append(" ");
            }
            try {
                w.write(lineString.toString());
                int column = 0;
                for (int i = 0; i < whichPrintColumns.length; ++i) {
                    w.write(w.getCurrentLineNumber(), column, w.getCurrentLineNumber() + 1, column);
                    column = column + columnWidth[i] + 1;
                }
                w.write(w.getCurrentLineNumber(), w.getCharactersPerLine(), w.getCurrentLineNumber() + 1, w.getCharactersPerLine());
                w.write("\n");
            }
            catch (IOException e) {
                log.warn("error during printing", (Throwable)e);
            }
        }
    }

    private static int getColumnWidth(int col) {
        switch (col) {
            case 2: {
                return 14;
            }
            case 4: {
                return 0;
            }
        }
        return 8;
    }
}

