/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.modeswitcher;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.ConfigurationManager;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.can.cbus.CbusDccProgrammerManager;
import jmri.jmrix.can.cbus.CbusPreferences;
import jmri.jmrix.can.cbus.CbusSend;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeTableDataModel;
import jmri.jmrix.can.cbus.swing.modeswitcher.Bundle;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogCbusModeSwitcherFrame
extends JmriJFrame
implements CanListener {
    protected static final int PROP_CMD_STATION = 5;
    protected CbusPreferences preferences;
    protected CbusDccProgrammerManager pm = null;
    protected CanSystemConnectionMemo _memo = null;
    protected ConfigurationManager.ProgModeSwitch _pms;
    protected TrafficController tc;
    protected CbusSend send;
    protected JLabel label = null;
    protected JPanel panel = null;
    protected JPanel modePane = null;
    protected int mode;
    int csNode;
    private static final Logger log = LoggerFactory.getLogger(SprogCbusModeSwitcherFrame.class);

    public SprogCbusModeSwitcherFrame(CanSystemConnectionMemo memo, String s) {
        super(s);
        this._memo = memo;
        this._pms = memo.getProgModeSwitch();
        this.preferences = memo.get(CbusPreferences.class);
        this.pm = (CbusDccProgrammerManager)InstanceManager.getNullableDefault(GlobalProgrammerManager.class);
        this.tc = this._memo.getTrafficController();
        this.addTc(this.tc);
    }

    protected boolean initSetup() {
        this.label = new JLabel();
        this.panel = new JPanel(new BorderLayout());
        if (this.pm == null) {
            this.label.setText("<html>" + Bundle.getMessage("NoCbusProgrammer") + "</html>");
            this.panel.add((Component)this.label, "North");
            return false;
        }
        this.csNode = 65534;
        CbusNodeTableDataModel cs = this._memo.get(CbusNodeTableDataModel.class);
        if (cs != null) {
            CbusNode csnode = cs.getCsByNum(0);
            if (csnode != null) {
                this.csNode = csnode.getNodeNumber();
            }
        } else {
            log.info("Unable to fetch Master Command Station from Node Manager");
        }
        this.send = new CbusSend(this._memo);
        this.label.setText("<html>" + Bundle.getMessage("HardwareModeLabel") + "</html>");
        this.modePane = new JPanel();
        this.modePane.setLayout(new BoxLayout(this.modePane, 1));
        this.modePane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("HardwareMode")));
        return true;
    }

    protected void setHardwareMode(int mode) {
        this.send.nVSET(this.csNode, 5, mode);
    }

    @Override
    public void message(CanMessage m) {
    }

    @Override
    public void reply(CanReply r) {
        if (r.isRtr()) {
            return;
        }
        if (!r.isExtended()) {
            log.debug("Standard Reply {}", (Object)r);
        }
    }

    @Override
    public void dispose() {
        this.tc.removeCanListener(this);
        super.dispose();
    }
}

