/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.modeswitcher;

import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.swing.modeswitcher.Bundle;
import jmri.jmrix.can.cbus.swing.modeswitcher.SprogCbusModeSwitcherFrame;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SprogCbusSprog3PlusModeSwitcherFrame
extends SprogCbusModeSwitcherFrame {
    public static final int PROG_OFF_MODE = 0;
    public static final int PROG_ON_MODE = 1;
    public static final int PROG_AR_MODE = 2;
    private JRadioButton progOffButton;
    private JRadioButton progOnButton;
    private JRadioButton progArButton;
    private static final Logger log = LoggerFactory.getLogger(SprogCbusSprog3PlusModeSwitcherFrame.class);

    public SprogCbusSprog3PlusModeSwitcherFrame(CanSystemConnectionMemo memo) {
        super(memo, Bundle.getMessage("SprogCbusPlusModeSwitcher"));
    }

    @Override
    public void initComponents() {
        if (this.initSetup()) {
            this.progOffButton = new JRadioButton(Bundle.getMessage("ProgOffMode"));
            this.progOnButton = new JRadioButton(Bundle.getMessage("ProgOnMode"));
            this.progArButton = new JRadioButton(Bundle.getMessage("ProgArMode"));
            ButtonGroup buttons = new ButtonGroup();
            buttons.add(this.progOffButton);
            buttons.add(this.progOnButton);
            buttons.add(this.progArButton);
            this.mode = 0;
            if (this.preferences.getProgTrackMode() == 0) {
                this.progOffButton.setSelected(true);
                this.pm.setGlobalProgrammerAvailable(true);
            } else if (this.preferences.getProgTrackMode() == 1) {
                this.progOnButton.setSelected(true);
                this.mode = 1;
                this.pm.setGlobalProgrammerAvailable(true);
            } else if (this.preferences.getProgTrackMode() == 2) {
                this.progArButton.setSelected(true);
                this.mode = 2;
                this.pm.setGlobalProgrammerAvailable(false);
            } else {
                this.progOffButton.setSelected(true);
                this.pm.setGlobalProgrammerAvailable(true);
            }
            this.setHardwareMode(this.mode);
            this.preferences.setProgTrackMode(this.mode);
            ActionListener listener = ae -> {
                if (this.progOnButton.isSelected()) {
                    log.info("Setting prog track on when not programming");
                    this.mode = 1;
                    this.setHardwareMode(this.mode);
                    this.pm.setGlobalProgrammerAvailable(true);
                } else if (this.progArButton.isSelected()) {
                    log.info("Setting prog track to auto-reverse");
                    this.mode = 2;
                    this.setHardwareMode(this.mode);
                    this.pm.setGlobalProgrammerAvailable(false);
                } else {
                    log.info("Setting prog track off when not programming");
                    this.mode = 0;
                    this.setHardwareMode(this.mode);
                    this.pm.setGlobalProgrammerAvailable(true);
                }
                this.preferences.setProgTrackMode(this.mode);
            };
            this.progOffButton.addActionListener(listener);
            this.progOnButton.addActionListener(listener);
            this.progArButton.addActionListener(listener);
            this.modePane.add(this.progOffButton);
            this.modePane.add(this.progOnButton);
            this.modePane.add(this.progArButton);
            this.panel.add((Component)this.label, "North");
            this.panel.add((Component)this.modePane, "Center");
        }
        this.setHelp();
        this.add(this.panel);
        ThreadingUtil.runOnGUI(() -> {
            this.pack();
            this.setVisible(true);
        });
    }

    protected void setHelp() {
        this.addHelpMenu("package.jmri.jmrix.can.cbus.swing.modeswitcher.SprogCbusSprog3PlusModeSwitcherFrame", true);
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

