/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.modules;

import javax.swing.event.TableModelEvent;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeNVTableDataModel;
import jmri.jmrix.can.swing.CanPanel;

public abstract class AbstractEditNVPane
extends CanPanel {
    protected CbusNodeNVTableDataModel _dataModel;
    protected CbusNode _node;
    protected int _fwMaj = -1;
    protected int _fwMin = -1;
    protected int _fwBuild = -1;

    public AbstractEditNVPane(CbusNodeNVTableDataModel dataModel, CbusNode node) {
        this._dataModel = dataModel;
        this._node = node;
        this._fwMaj = node.getNodeParamManager().getParameter(7);
        this._fwMin = node.getNodeParamManager().getParameter(2);
        this._fwBuild = node.getNodeParamManager().getParameter(20);
    }

    public abstract AbstractEditNVPane getContent();

    public abstract void tableChanged(TableModelEvent var1);

    protected int getSelectValue8(int row) {
        try {
            return (Integer)this._dataModel.getValueAt(row - 1, 5);
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    protected int getSelectValue8(int row, int min) {
        try {
            int val = (Integer)this._dataModel.getValueAt(row - 1, 5);
            if (val < min) {
                return min;
            }
            return val;
        }
        catch (NullPointerException ex) {
            return min;
        }
    }

    protected int getSelectValue8(int row, int min, int max) {
        try {
            int val = (Integer)this._dataModel.getValueAt(row - 1, 5);
            if (val < min) {
                return min;
            }
            if (val > max) {
                return max;
            }
            return val;
        }
        catch (NullPointerException ex) {
            return min;
        }
    }

    protected int getSelectValue16(int rowHi, int rowLo, int min, int max) {
        try {
            int hi = (Integer)this._dataModel.getValueAt(rowHi - 1, 5);
            int lo = (Integer)this._dataModel.getValueAt(rowLo - 1, 5);
            int val = hi * 256 + lo;
            if (val < min) {
                return min;
            }
            if (val > max) {
                return max;
            }
            return val;
        }
        catch (NullPointerException ex) {
            return min;
        }
    }

    protected int getSelectValue32(int rowT) {
        try {
            int t = (Integer)this._dataModel.getValueAt(rowT - 1, 5);
            int u = (Integer)this._dataModel.getValueAt(rowT, 5);
            int h = (Integer)this._dataModel.getValueAt(rowT + 1, 5);
            int l = (Integer)this._dataModel.getValueAt(rowT + 2, 5);
            int val = ((t * 256 + u) * 256 + h) * 256 + l;
            if (val < 0) {
                return 0;
            }
            return val;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }
}

