/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.modules;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import jmri.jmrix.can.cbus.swing.modules.UpdateNV;

public class CmdStaFlags
extends JPanel {
    protected int _index;
    protected int _nv;
    protected String _title;
    protected int flags;
    protected JRadioButton[] buttons;
    protected UpdateNV _flagUpdateFn;

    public CmdStaFlags(int index, int nv, String title, String[] flagStrings, String[] flagTtStrings, UpdateNV update) {
        this._index = index;
        this._nv = nv;
        this._title = title;
        this._flagUpdateFn = update;
        this.buttons = new JRadioButton[8];
        for (int i = 0; i < 8; ++i) {
            this.buttons[i] = new JRadioButton(flagStrings[i]);
            this.buttons[i].setToolTipText(flagTtStrings[i]);
            this.buttons[i].addActionListener(e -> this.flagActionListener());
        }
    }

    public JPanel getContents() {
        JPanel gridPane = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        Border border = BorderFactory.createEtchedBorder(1);
        TitledBorder t = BorderFactory.createTitledBorder(border, this._title);
        gridPane.setBorder(t);
        for (int i = 0; i < 8; ++i) {
            gridPane.add((Component)this.buttons[i], c);
            ++c.gridy;
        }
        this.setButtons();
        return gridPane;
    }

    protected void flagActionListener() {
        int value = this.buttons[7].isSelected() ? 1 : 0;
        for (int i = 6; i >= 0; --i) {
            value = (value << 1) + (this.buttons[i].isSelected() ? 1 : 0);
        }
        this.setFlags(value);
        this._flagUpdateFn.setNewVal(this._index);
    }

    public void setFlags(int value) {
        this.flags = value;
        this.setButtons();
    }

    public int getFlags() {
        return this.flags;
    }

    public int getNv() {
        return this._nv;
    }

    protected void setButtons() {
        for (int i = 0; i < 8; ++i) {
            if ((this.flags & 1 << i) > 0) {
                this.buttons[i].setSelected(true);
                continue;
            }
            this.buttons[i].setSelected(false);
        }
    }
}

