/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.modules;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jmri.jmrix.can.cbus.swing.modules.UpdateNV;
import jmri.util.TimerUtil;

public class TitledSlider
extends JPanel
implements ChangeListener {
    protected JSlider tSlide;
    protected int _index;
    protected String _title;
    protected UpdateNV _update;
    private TimerTask timerTask;

    public TitledSlider(String title, int index, UpdateNV update) {
        this._title = title;
        this._index = index;
        this._update = update;
        this.tSlide = new JSlider();
    }

    public void init(int min, int max, int init) {
        GridLayout grid = new GridLayout(1, 1);
        this.setLayout(grid);
        Border border = BorderFactory.createEtchedBorder(1);
        TitledBorder titled = BorderFactory.createTitledBorder(border, this._title);
        this.setBorder(titled);
        this.tSlide.setMinimum(min);
        this.tSlide.setMaximum(max);
        this.tSlide.setValue(init);
        this.tSlide.addChangeListener(this);
        this.add(this.tSlide);
    }

    public void setValue(int v) {
        if (v != this.tSlide.getValue()) {
            this.tSlide.setValue(v);
        }
    }

    public int getValue() {
        return this.tSlide.getValue();
    }

    public void setToolTip(String tt) {
        this.tSlide.setToolTipText(tt);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        if (!source.getValueIsAdjusting()) {
            this._update.setNewVal(this._index);
            if (this.timerTask != null) {
                this.timerTask.cancel();
                this.timerTask = null;
            }
        } else if (this.timerTask == null) {
            this._update.setNewVal(this._index);
            this.startTimer();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        Border border = this.getBorder();
        int borderWidth = 0;
        if (border instanceof TitledBorder) {
            Insets insets = this.getInsets();
            TitledBorder titledBorder = (TitledBorder)border;
            borderWidth = titledBorder.getMinimumSize((Component)this).width + insets.left + insets.right;
        }
        int preferredWidth = Math.max(preferredSize.width, borderWidth);
        return new Dimension(preferredWidth, preferredSize.height);
    }

    private void startTimer() {
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                TitledSlider.this.timerTask = null;
            }
        };
        TimerUtil.schedule(this.timerTask, 100L);
    }
}

