/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.modules;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jmri.jmrix.can.cbus.swing.modules.UpdateNV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitledSpinner
extends JPanel
implements ChangeListener {
    protected JSpinner tSpin;
    protected int _index;
    protected String _title;
    protected UpdateNV _update;
    protected Object lastValue;
    private static final Logger log = LoggerFactory.getLogger(TitledSpinner.class);

    public TitledSpinner(String title, int index, UpdateNV update) {
        this._title = title;
        this._index = index;
        this._update = update;
        this.tSpin = new JSpinner();
    }

    public void init(double init, double min, double max, double step) {
        SpinnerNumberModel spinModel = init >= 0.0 ? new SpinnerNumberModel(init, min, max, step) : new SpinnerNumberModel(min, min, max, step);
        this.init(spinModel);
    }

    public void init(int init, int min, int max, int step) {
        SpinnerNumberModel spinModel = (double)init >= 0.0 ? new SpinnerNumberModel(init, min, max, step) : new SpinnerNumberModel(min, min, max, step);
        this.init(spinModel);
    }

    private void init(SpinnerNumberModel spinModel) {
        GridLayout grid = new GridLayout(1, 1);
        this.setLayout(grid);
        Border border = BorderFactory.createEtchedBorder(1);
        TitledBorder titled = BorderFactory.createTitledBorder(border, this._title);
        this.setBorder(titled);
        this.tSpin.setModel(spinModel);
        this.tSpin.addChangeListener(this);
        this.add(this.tSpin);
    }

    public void setToolTip(String tt) {
        this.tSpin.setToolTipText(tt);
    }

    @Override
    public void setEnabled(boolean b) {
        this.tSpin.setEnabled(b);
    }

    @Override
    public boolean isEnabled() {
        return this.tSpin.isEnabled();
    }

    public void setValue(Number val) {
        if (val.getClass() == ((SpinnerNumberModel)this.tSpin.getModel()).getValue().getClass()) {
            this.tSpin.getModel().setValue(val);
        } else {
            log.error("Expected {} given {}", ((SpinnerNumberModel)this.tSpin.getModel()).getValue().getClass(), val.getClass());
        }
    }

    public Double getDoubleValue() {
        return ((SpinnerNumberModel)this.tSpin.getModel()).getNumber().doubleValue();
    }

    public int getIntegerValue() {
        return ((SpinnerNumberModel)this.tSpin.getModel()).getNumber().intValue();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this._update.setNewVal(this._index);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        Border border = this.getBorder();
        int borderWidth = 0;
        if (border instanceof TitledBorder) {
            Insets insets = this.getInsets();
            TitledBorder titledBorder = (TitledBorder)border;
            borderWidth = titledBorder.getMinimumSize((Component)this).width + insets.left + insets.right;
        }
        int preferredWidth = Math.max(preferredSize.width, borderWidth);
        return new Dimension(preferredWidth, preferredSize.height);
    }
}

