/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.modules.base;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeNVTableDataModel;
import jmri.jmrix.can.cbus.swing.modules.AbstractEditNVPane;
import jmri.jmrix.can.cbus.swing.modules.TitledSlider;
import jmri.jmrix.can.cbus.swing.modules.TitledSpinner;
import jmri.jmrix.can.cbus.swing.modules.UpdateNV;
import jmri.jmrix.can.cbus.swing.modules.base.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Servo8BaseEditNVPane
extends AbstractEditNVPane {
    public static final int OUTPUTS = 8;
    public static final int ACTION_OFF = 3;
    public static final int ACTION_SAVED = 1;
    public static final int ACTION_NONE = 0;
    private ServoPane[] servo = new ServoPane[9];
    private final UpdateNV onPosUpdateFn = new UpdateOnPos();
    private final UpdateNV offPosUpdateFn = new UpdateOffPos();
    private final UpdateNV onSpdUpdateFn = new UpdateOnSpd();
    private final UpdateNV offSpdUpdateFn = new UpdateOffSpd();
    private final UpdateNV startupUpdateFn = new UpdateStartup();
    protected JButton save;
    private static final Logger log = LoggerFactory.getLogger(Servo8BaseEditNVPane.class);

    protected Servo8BaseEditNVPane(CbusNodeNVTableDataModel dataModel, CbusNode node) {
        super(dataModel, node);
    }

    @Override
    public AbstractEditNVPane getContent() {
        JPanel gridPane = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        for (int y = 0; y < 4; ++y) {
            c.gridx = 0;
            for (int x = 0; x < 2; ++x) {
                int index = y * 2 + x + 1;
                this.servo[index] = new ServoPane(index);
                gridPane.add((Component)this.servo[index], c);
                ++c.gridx;
            }
            ++c.gridy;
        }
        JScrollPane scroll = new JScrollPane(gridPane);
        this.add(scroll);
        return this;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 0) {
            int value;
            int row = e.getFirstRow();
            int nv = row + 1;
            int sv = (nv - 5) / 4 + 1;
            try {
                value = (Integer)this._dataModel.getValueAt(row, 5);
            }
            catch (NullPointerException ex) {
                return;
            }
            log.debug("servo gui table changed NV: {} Value: {}", (Object)nv, (Object)value);
            if (nv == 1) {
                for (int i = 1; i <= 8; ++i) {
                    this.servo[i].cutoff.setSelected((value & 1 << i - 1) > 0);
                }
            } else if (nv == 2 || nv == 3) {
                for (int i = 1; i <= 8; ++i) {
                    this.servo[i].action.setButtons();
                }
            } else if (nv == 4) {
                for (int i = 1; i <= 8; ++i) {
                    this.servo[i].seq.setSelected((value & 1 << i - 1) > 0);
                }
            } else if (nv <= 36 && nv > 0) {
                if ((nv - 5) % 4 == 0) {
                    this.servo[sv].onPosSlider.setValue(value);
                } else if ((nv - 6) % 4 == 0) {
                    this.servo[sv].offPosSlider.setValue(value);
                } else if ((nv - 7) % 4 == 0) {
                    this.servo[sv].onSpdSpinner.setValue(value & 7);
                } else {
                    this.servo[sv].offSpdSpinner.setValue(value & 7);
                }
            }
        }
    }

    private class StartupActionPane
    extends JPanel {
        int _index;
        JRadioButton off;
        JRadioButton none;
        JRadioButton saved;

        public StartupActionPane(int index) {
            this._index = index;
            JPanel gridPane = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridx = 0;
            c.gridy = 0;
            Border border = BorderFactory.createEtchedBorder(1);
            TitledBorder title = BorderFactory.createTitledBorder(border, Bundle.getMessage("StartupAction"));
            this.setBorder(title);
            this.off = new JRadioButton(Bundle.getMessage("Off"));
            this.off.setToolTipText(Bundle.getMessage("OffTt"));
            this.none = new JRadioButton(Bundle.getMessage("None"));
            this.none.setToolTipText(Bundle.getMessage("NoneTt"));
            this.saved = new JRadioButton(Bundle.getMessage("SavedAction"));
            this.saved.setToolTipText(Bundle.getMessage("SavedActionTt"));
            this.off.addActionListener(e -> this.startupActionListener());
            this.none.addActionListener(e -> this.startupActionListener());
            this.saved.addActionListener(e -> this.startupActionListener());
            ButtonGroup buttons = new ButtonGroup();
            buttons.add(this.off);
            buttons.add(this.none);
            buttons.add(this.saved);
            this.setButtons();
            if ((Servo8BaseEditNVPane.this.getSelectValue8(2) & 1 << this._index - 1) > 0) {
                this.off.setSelected(true);
            } else if ((Servo8BaseEditNVPane.this.getSelectValue8(3) & 1 << this._index - 1) > 0) {
                this.saved.setSelected(true);
            } else {
                this.none.setSelected(true);
            }
            gridPane.add((Component)this.off, c);
            ++c.gridy;
            gridPane.add((Component)this.none, c);
            ++c.gridy;
            gridPane.add((Component)this.saved, c);
            this.add(gridPane);
        }

        public void setButtons() {
            if ((Servo8BaseEditNVPane.this.getSelectValue8(2) & 1 << this._index - 1) > 0) {
                this.off.setSelected(true);
            } else if ((Servo8BaseEditNVPane.this.getSelectValue8(3) & 1 << this._index - 1) > 0) {
                this.saved.setSelected(true);
            } else {
                this.none.setSelected(true);
            }
        }

        protected void startupActionListener() {
            Servo8BaseEditNVPane.this.startupUpdateFn.setNewVal(this._index);
        }
    }

    private class ServoPane
    extends JPanel {
        int _index;
        protected JButton testOn;
        protected JButton testOff;
        protected JCheckBox cutoff;
        protected JCheckBox seq;
        protected TitledSlider onPosSlider;
        protected TitledSlider offPosSlider;
        protected TitledSpinner onSpdSpinner;
        protected TitledSpinner offSpdSpinner;
        protected StartupActionPane action;

        public ServoPane(int index) {
            this._index = index;
            JPanel gridPane = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.weightx = 1.0;
            c.weighty = 1.0;
            Border border = BorderFactory.createEtchedBorder(1);
            TitledBorder title = BorderFactory.createTitledBorder(border, Bundle.getMessage("OutputX", this._index));
            this.setBorder(title);
            this.testOn = new JButton(Bundle.getMessage("TestOn"));
            this.testOff = new JButton(Bundle.getMessage("TestOff"));
            this.cutoff = new JCheckBox(Bundle.getMessage("Cutoff"));
            this.seq = new JCheckBox(Bundle.getMessage("SequentialOp"));
            this.testOn.setToolTipText(Bundle.getMessage("TestOnTt"));
            this.testOff.setToolTipText(Bundle.getMessage("TestOffTt"));
            this.cutoff.setToolTipText(Bundle.getMessage("CutoffTt"));
            this.seq.setToolTipText(Bundle.getMessage("SequentialOpTt"));
            this.testOn.addActionListener(e -> this.testActionListener(e));
            this.testOff.addActionListener(e -> this.testActionListener(e));
            this.cutoff.addActionListener(e -> this.cutoffActionListener());
            this.seq.addActionListener(e -> this.seqActionListener());
            this.onPosSlider = new TitledSlider(Bundle.getMessage("OnPos"), this._index, Servo8BaseEditNVPane.this.onPosUpdateFn);
            this.onPosSlider.setToolTip(Bundle.getMessage("OnPosTt"));
            this.onPosSlider.init(0, 255, 127);
            this.offPosSlider = new TitledSlider(Bundle.getMessage("OffPos"), this._index, Servo8BaseEditNVPane.this.offPosUpdateFn);
            this.offPosSlider.setToolTip(Bundle.getMessage("OffPosTt"));
            this.offPosSlider.init(0, 255, 127);
            this.onSpdSpinner = new TitledSpinner(Bundle.getMessage("OnSpd"), this._index, Servo8BaseEditNVPane.this.onSpdUpdateFn);
            this.onSpdSpinner.setToolTip(Bundle.getMessage("OnSpdTt"));
            this.onSpdSpinner.init(0, 0, 7, 1);
            this.offSpdSpinner = new TitledSpinner(Bundle.getMessage("OffSpd"), this._index, Servo8BaseEditNVPane.this.offSpdUpdateFn);
            this.offSpdSpinner.setToolTip(Bundle.getMessage("OffSpdTt"));
            this.offSpdSpinner.init(0, 0, 7, 1);
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 3;
            c.weighty = 1.0;
            gridPane.add((Component)this.onPosSlider, c);
            ++c.gridy;
            gridPane.add((Component)this.offPosSlider, c);
            ++c.gridy;
            c.gridwidth = 1;
            gridPane.add((Component)this.testOn, c);
            ++c.gridx;
            gridPane.add((Component)this.testOff, c);
            ++c.gridx;
            gridPane.add((Component)this.cutoff, c);
            c.gridx = 3;
            c.gridy = 0;
            gridPane.add((Component)this.onSpdSpinner, c);
            ++c.gridy;
            gridPane.add((Component)this.offSpdSpinner, c);
            ++c.gridy;
            gridPane.add((Component)this.seq, c);
            c.gridx = 4;
            c.gridy = 0;
            c.gridheight = 3;
            this.action = new StartupActionPane(this._index);
            gridPane.add((Component)this.action, c);
            this.add(gridPane);
        }

        protected void testActionListener(ActionEvent e) {
            for (int i = 1; i <= 8; ++i) {
                int val = 0;
                if (e.getSource() == Servo8BaseEditNVPane.this.servo[i].testOn) {
                    log.debug("Servo {} test ON", (Object)i);
                    val = 128 + i;
                } else if (e.getSource() == Servo8BaseEditNVPane.this.servo[i].testOff) {
                    log.debug("Servo {} test OFF", (Object)i);
                    val = i;
                }
                if (val <= 0) continue;
                ((Servo8BaseEditNVPane)Servo8BaseEditNVPane.this)._node.send.nVSET(Servo8BaseEditNVPane.this._node.getNodeNumber(), 37, val);
            }
        }

        protected void cutoffActionListener() {
            int newCutoff = 0;
            for (int i = 8; i > 0; --i) {
                newCutoff = (newCutoff << 1) + (Servo8BaseEditNVPane.this.servo[i].cutoff.isSelected() ? 1 : 0);
            }
            log.debug("Cutoff Action now {}", (Object)newCutoff);
            Servo8BaseEditNVPane.this._dataModel.setValueAt(newCutoff, 0, 5);
            if (Servo8BaseEditNVPane.this._node.getliveUpdate()) {
                ((Servo8BaseEditNVPane)Servo8BaseEditNVPane.this)._node.send.nVSET(Servo8BaseEditNVPane.this._node.getNodeNumber(), 1, newCutoff);
            }
        }

        protected void seqActionListener() {
            int newSeq = 0;
            for (int i = 8; i > 0; --i) {
                newSeq = (newSeq << 1) + (Servo8BaseEditNVPane.this.servo[i].seq.isSelected() ? 1 : 0);
            }
            log.debug("Sequential Action now {}", (Object)newSeq);
            Servo8BaseEditNVPane.this._dataModel.setValueAt(newSeq, 3, 5);
            if (Servo8BaseEditNVPane.this._node.getliveUpdate()) {
                ((Servo8BaseEditNVPane)Servo8BaseEditNVPane.this)._node.send.nVSET(Servo8BaseEditNVPane.this._node.getNodeNumber(), 4, newSeq);
            }
        }
    }

    protected class UpdateStartup
    implements UpdateNV {
        protected UpdateStartup() {
        }

        @Override
        public void setNewVal(int index) {
            int newPos = Servo8BaseEditNVPane.this.getSelectValue8(2) & ~(1 << index - 1);
            int newMove = Servo8BaseEditNVPane.this.getSelectValue8(3) & ~(1 << index - 1);
            if (Servo8BaseEditNVPane.this.servo[index].action.off.isSelected()) {
                newPos |= 1 << index - 1;
                newMove |= 1 << index - 1;
            } else if (Servo8BaseEditNVPane.this.servo[index].action.saved.isSelected()) {
                newMove |= 1 << index - 1;
            }
            Servo8BaseEditNVPane.this._dataModel.setValueAt(newPos, 1, 5);
            Servo8BaseEditNVPane.this._dataModel.setValueAt(newMove, 2, 5);
            if (Servo8BaseEditNVPane.this._node.getliveUpdate()) {
                ((Servo8BaseEditNVPane)Servo8BaseEditNVPane.this)._node.send.nVSET(Servo8BaseEditNVPane.this._node.getNodeNumber(), 2, newPos);
                ((Servo8BaseEditNVPane)Servo8BaseEditNVPane.this)._node.send.nVSET(Servo8BaseEditNVPane.this._node.getNodeNumber(), 3, newMove);
            }
        }
    }

    protected class UpdateOffSpd
    implements UpdateNV {
        protected UpdateOffSpd() {
        }

        @Override
        public void setNewVal(int index) {
            int spd = Servo8BaseEditNVPane.this.servo[index].offSpdSpinner.getIntegerValue();
            int nv_index = (index - 1) * 4 + 8;
            Servo8BaseEditNVPane.this._dataModel.setValueAt(spd, nv_index - 1, 5);
            if (Servo8BaseEditNVPane.this._node.getliveUpdate()) {
                ((Servo8BaseEditNVPane)Servo8BaseEditNVPane.this)._node.send.nVSET(Servo8BaseEditNVPane.this._node.getNodeNumber(), nv_index, spd);
            }
        }
    }

    protected class UpdateOnSpd
    implements UpdateNV {
        protected UpdateOnSpd() {
        }

        @Override
        public void setNewVal(int index) {
            int spd = Servo8BaseEditNVPane.this.servo[index].onSpdSpinner.getIntegerValue();
            int nv_index = (index - 1) * 4 + 7;
            Servo8BaseEditNVPane.this._dataModel.setValueAt(spd, nv_index - 1, 5);
            if (Servo8BaseEditNVPane.this._node.getliveUpdate()) {
                ((Servo8BaseEditNVPane)Servo8BaseEditNVPane.this)._node.send.nVSET(Servo8BaseEditNVPane.this._node.getNodeNumber(), nv_index, spd);
            }
        }
    }

    protected class UpdateOffPos
    implements UpdateNV {
        protected UpdateOffPos() {
        }

        @Override
        public void setNewVal(int index) {
            int pos = Servo8BaseEditNVPane.this.servo[index].offPosSlider.getValue();
            int nv_index = (index - 1) * 4 + 6;
            Servo8BaseEditNVPane.this._dataModel.setValueAt(pos, nv_index - 1, 5);
            if (Servo8BaseEditNVPane.this._node.getliveUpdate()) {
                ((Servo8BaseEditNVPane)Servo8BaseEditNVPane.this)._node.send.nVSET(Servo8BaseEditNVPane.this._node.getNodeNumber(), nv_index, pos);
            }
        }
    }

    protected class UpdateOnPos
    implements UpdateNV {
        protected UpdateOnPos() {
        }

        @Override
        public void setNewVal(int index) {
            int pos = Servo8BaseEditNVPane.this.servo[index].onPosSlider.getValue();
            int nv_index = (index - 1) * 4 + 5;
            Servo8BaseEditNVPane.this._dataModel.setValueAt(pos, nv_index - 1, 5);
            if (Servo8BaseEditNVPane.this._node.getliveUpdate()) {
                ((Servo8BaseEditNVPane)Servo8BaseEditNVPane.this)._node.send.nVSET(Servo8BaseEditNVPane.this._node.getNodeNumber(), nv_index, pos);
            }
        }
    }
}

