/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.modules.base;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeNVTableDataModel;
import jmri.jmrix.can.cbus.swing.modules.AbstractEditNVPane;
import jmri.jmrix.can.cbus.swing.modules.TitledSpinner;
import jmri.jmrix.can.cbus.swing.modules.UpdateNV;
import jmri.jmrix.can.cbus.swing.modules.base.Bundle;

public class Sol8BaseEditNVPane
extends AbstractEditNVPane {
    public static final int OUTPUTS = 8;
    public static final int TIME_STEP_SIZE = 10;
    private final UpdateNV pulseUpdateFn = new UpdatePulse();
    private final UpdateNV rechargeUpdateFn = new UpdateRecharge();
    private final UpdateNV fireDelayUpdateFn = new UpdateFireDelay();
    private final UpdateNV enableDelayUpdateFn = new UpdateEnableDelay();
    private TitledSpinner[] pulse = new TitledSpinner[9];
    private TitledSpinner rechargeSpinner;
    private TitledSpinner fireDelaySpinner;
    private TitledSpinner enableDelaySpinner;

    protected Sol8BaseEditNVPane(CbusNodeNVTableDataModel dataModel, CbusNode node) {
        super(dataModel, node);
        this.initSpinners();
    }

    private void initSpinners() {
        this.rechargeSpinner = new TitledSpinner(Bundle.getMessage("RechargeTimeUnits"), 9, this.rechargeUpdateFn);
        this.rechargeSpinner.setToolTip(Bundle.getMessage("RechargeTimeTt"));
        this.fireDelaySpinner = new TitledSpinner(Bundle.getMessage("FireDelayUnits"), 10, this.fireDelayUpdateFn);
        this.fireDelaySpinner.setToolTip(Bundle.getMessage("FireDelayTt"));
        this.enableDelaySpinner = new TitledSpinner(Bundle.getMessage("EnableDelayUnits"), 11, this.enableDelayUpdateFn);
        this.enableDelaySpinner.setToolTip(Bundle.getMessage("EnableDelayTt"));
    }

    @Override
    public AbstractEditNVPane getContent() {
        JPanel gridPane = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridy = 0;
        for (int y = 0; y < 2; ++y) {
            c.gridx = 0;
            for (int x = 0; x < 4; ++x) {
                int index = y * 4 + x + 1;
                this.pulse[index] = new TitledSpinner(Bundle.getMessage("OutputX", index) + " " + Bundle.getMessage("PulseWidthUnits"), index, this.pulseUpdateFn);
                this.pulse[index].setToolTip(Bundle.getMessage("CanSolOutputTt"));
                this.pulse[index].init(this.getSelectValue8(index) * 10, 0, 2550, 10);
                gridPane.add((Component)this.pulse[index], c);
                ++c.gridx;
            }
            ++c.gridy;
        }
        c.gridx = 0;
        this.rechargeSpinner.init(this.getSelectValue8(9) * 10, 0, 2550, 10);
        gridPane.add((Component)this.rechargeSpinner, c);
        ++c.gridx;
        this.fireDelaySpinner.init(this.getSelectValue8(10) * 10, 0, 2550, 10);
        gridPane.add((Component)this.fireDelaySpinner, c);
        ++c.gridx;
        this.enableDelaySpinner.init(this.getSelectValue8(11) * 10, 0, 2550, 10);
        gridPane.add((Component)this.enableDelaySpinner, c);
        JScrollPane scroll = new JScrollPane(gridPane);
        this.add(scroll);
        return this;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 0) {
            int row = e.getFirstRow();
            int nv = row + 1;
            int value = this.getSelectValue8(nv);
            if (nv > 0 && nv <= 8) {
                this.pulse[nv].setValue(value * 10);
            } else if (nv == 9) {
                this.rechargeSpinner.setValue(value * 10);
            } else if (nv == 10) {
                this.fireDelaySpinner.setValue(value * 10);
            } else if (nv == 11) {
                this.enableDelaySpinner.setValue(value * 10);
            }
        }
    }

    protected class UpdateEnableDelay
    implements UpdateNV {
        protected UpdateEnableDelay() {
        }

        @Override
        public void setNewVal(int index) {
            int delay = Sol8BaseEditNVPane.this.enableDelaySpinner.getIntegerValue() / 10;
            Sol8BaseEditNVPane.this._dataModel.setValueAt(delay, index - 1, 5);
        }
    }

    protected class UpdateFireDelay
    implements UpdateNV {
        protected UpdateFireDelay() {
        }

        @Override
        public void setNewVal(int index) {
            int delay = Sol8BaseEditNVPane.this.fireDelaySpinner.getIntegerValue() / 10;
            Sol8BaseEditNVPane.this._dataModel.setValueAt(delay, index - 1, 5);
        }
    }

    protected class UpdateRecharge
    implements UpdateNV {
        protected UpdateRecharge() {
        }

        @Override
        public void setNewVal(int index) {
            int delay = Sol8BaseEditNVPane.this.rechargeSpinner.getIntegerValue() / 10;
            Sol8BaseEditNVPane.this._dataModel.setValueAt(delay, index - 1, 5);
        }
    }

    protected class UpdatePulse
    implements UpdateNV {
        protected UpdatePulse() {
        }

        @Override
        public void setNewVal(int index) {
            int delay = Sol8BaseEditNVPane.this.pulse[index].getIntegerValue() / 10;
            Sol8BaseEditNVPane.this._dataModel.setValueAt(delay, index - 1, 5);
        }
    }
}

