/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.modules.merg;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.TableModelEvent;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeNVTableDataModel;
import jmri.jmrix.can.cbus.swing.modules.AbstractEditNVPane;
import jmri.jmrix.can.cbus.swing.modules.CmdStaFlags;
import jmri.jmrix.can.cbus.swing.modules.TitledSpinner;
import jmri.jmrix.can.cbus.swing.modules.UpdateNV;
import jmri.jmrix.can.cbus.swing.modules.merg.Bundle;
import jmri.jmrix.can.cbus.swing.modules.merg.CanCmdPaneProvider;

public class CanCmdEditNVPane
extends AbstractEditNVPane {
    private static final int USER_FLAGS = 0;
    private static final int OPS_FLAGS = 1;
    private static final int DEBUG_FLAGS = 2;
    private CmdStaFlags[] csFlags = new CmdStaFlags[3];
    private final UpdateNV cmdStaNoUpdateFn = new UpdateCmdStaNo();
    private final UpdateNV currentLimitUpdateFn = new UpdateCurrentLimit();
    private final UpdateNV nnMapUpdateFn = new UpdateNnMap();
    private final UpdateNV flagUpdateFn = new UpdateFlags();
    private final UpdateNV sodDelayUpdateFn = new UpdateSodDelay();
    private final UpdateNV intervalUpdateFn = new UpdateInterval();
    private final UpdateNV ackUpdateFn = new UpdateAck();
    private final UpdateNV multUpdateFn = new UpdateMult();
    private final UpdateNV walkaboutUpdateFn = new UpdateWalkabout();
    private TitledSpinner cmdStaNoSpinner;
    private TitledSpinner mainSpinner;
    private TitledSpinner progSpinner;
    private TitledSpinner nnMapDccSpinner;
    private TitledSpinner sodDelaySpinner;
    private TitledSpinner intervalSpinner;
    private TitledSpinner ackSpinner;
    private TitledSpinner multSpinner;
    private TitledSpinner walkaboutSpinner;
    protected String[] flagTitleStrings = new String[]{Bundle.getMessage("UserFlags"), Bundle.getMessage("OperationsFlags"), Bundle.getMessage("DebugFlags")};
    protected String[][] flagStrings = new String[][]{{Bundle.getMessage("Silent"), Bundle.getMessage("PermitSteal"), Bundle.getMessage("PermitShare"), Bundle.getMessage("PermitEvReset"), Bundle.getMessage("MapEvents"), Bundle.getMessage("StopOnTimeout"), Bundle.getMessage("StartOfDay"), Bundle.getMessage("Reserved")}, {Bundle.getMessage("JumperControl"), Bundle.getMessage("MainOnBoard"), Bundle.getMessage("AnalogDetect"), Bundle.getMessage("ZtcMode"), Bundle.getMessage("AllStopTrackOff"), Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved")}, {Bundle.getMessage("PriPkts"), Bundle.getMessage("SpdPkts"), Bundle.getMessage("FnPkts"), Bundle.getMessage("ServicePkts"), Bundle.getMessage("AccyPkts"), Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved")}};
    protected String[][] flagTtStrings = new String[][]{{Bundle.getMessage("SilentTt"), Bundle.getMessage("PermitStealTt"), Bundle.getMessage("PermitShareTt"), Bundle.getMessage("PermitEvResetTt"), Bundle.getMessage("MapEventsTt"), Bundle.getMessage("StopOnTimeoutTt"), Bundle.getMessage("StartOfDayTt"), Bundle.getMessage("ReservedTt")}, {Bundle.getMessage("JumperControlTt"), Bundle.getMessage("MainOnBoardTt"), Bundle.getMessage("AnalogDetectTt"), Bundle.getMessage("ZtcModeTt"), Bundle.getMessage("AllStopTrackOffTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt")}, {Bundle.getMessage("PriPktsTt"), Bundle.getMessage("SpdPktsTt"), Bundle.getMessage("FnPktsTt"), Bundle.getMessage("ServicePktsTt"), Bundle.getMessage("AccyPktsTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt")}};

    protected CanCmdEditNVPane(CbusNodeNVTableDataModel dataModel, CbusNode node) {
        super(dataModel, node);
    }

    @Override
    public AbstractEditNVPane getContent() {
        JTabbedPane tabbedPane = new JTabbedPane();
        CmdStaPane cmdStaPane = new CmdStaPane();
        DccPane dccPane = new DccPane();
        CbusPane cbusPane = new CbusPane();
        tabbedPane.addTab(Bundle.getMessage("CmdSta"), cmdStaPane);
        tabbedPane.addTab("DCC", dccPane);
        tabbedPane.addTab("CBUS", cbusPane);
        JScrollPane scroll = new JScrollPane(tabbedPane);
        this.add(scroll);
        return this;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 0) {
            int row = e.getFirstRow();
            int nv = row + 1;
            int value = this.getSelectValue8(nv);
            switch (nv) {
                case 1: {
                    this.cmdStaNoSpinner.setValue(value);
                    break;
                }
                case 2: {
                    this.csFlags[0].setFlags(value);
                    break;
                }
                case 3: {
                    this.csFlags[1].setFlags(value);
                    break;
                }
                case 4: {
                    this.csFlags[2].setFlags(value);
                    break;
                }
                case 7: {
                    this.progSpinner.setValue(value);
                    break;
                }
                case 6: {
                    this.mainSpinner.setValue(value);
                    break;
                }
                case 11: 
                case 12: {
                    this.nnMapDccSpinner.setValue(this.getSelectValue16(11, 12, CanCmdPaneProvider.MIN_NN, CanCmdPaneProvider.MAX_NN));
                    break;
                }
                case 5: {
                    this.walkaboutSpinner.setValue(value);
                    break;
                }
                case 8: {
                    this.multSpinner.setValue(value);
                    break;
                }
                case 9: {
                    this.ackSpinner.setValue(value);
                    break;
                }
                case 13: {
                    this.intervalSpinner.setValue(value);
                    break;
                }
                case 14: {
                    this.sodDelaySpinner.setValue(value);
                    break;
                }
                case 10: 
                case 15: 
                case 16: {
                    break;
                }
            }
        }
    }

    public class CbusPane
    extends JPanel {
        public CbusPane() {
            JPanel gridPane = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridx = 0;
            c.gridy = 0;
            CanCmdEditNVPane.this.sodDelaySpinner = new TitledSpinner(Bundle.getMessage("SodDelay"), 14, CanCmdEditNVPane.this.sodDelayUpdateFn);
            CanCmdEditNVPane.this.sodDelaySpinner.setToolTip(Bundle.getMessage("SodDelayTt"));
            CanCmdEditNVPane.this.sodDelaySpinner.init(CanCmdEditNVPane.this.getSelectValue8(14), 0, 255, 1);
            gridPane.add((Component)CanCmdEditNVPane.this.sodDelaySpinner, c);
            ++c.gridy;
            this.add(gridPane);
        }
    }

    public class DccPane
    extends JPanel {
        public DccPane() {
            JPanel gridPane = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridx = 0;
            c.gridy = 0;
            ++c.gridy;
            CanCmdEditNVPane.this.nnMapDccSpinner = new TitledSpinner(Bundle.getMessage("NnMapDcc"), 11, CanCmdEditNVPane.this.nnMapUpdateFn);
            CanCmdEditNVPane.this.nnMapDccSpinner.setToolTip(Bundle.getMessage("NnMapDccTt"));
            int nn = CanCmdEditNVPane.this.getSelectValue16(11, 12, CanCmdPaneProvider.MIN_NN, CanCmdPaneProvider.MAX_NN);
            CanCmdEditNVPane.this.nnMapDccSpinner.init(nn, 0, 65535, 1);
            gridPane.add((Component)CanCmdEditNVPane.this.nnMapDccSpinner, c);
            ++c.gridy;
            gridPane.add((Component)CanCmdEditNVPane.this.nnMapDccSpinner, c);
            ++c.gridy;
            this.add(gridPane);
        }
    }

    public class CmdStaPane
    extends JPanel {
        public CmdStaPane() {
            JPanel gridPane = new JPanel(new GridBagLayout());
            JPanel[] flagPane = new JPanel[3];
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            for (int i = 0; i < 3; ++i) {
                CanCmdEditNVPane.this.csFlags[i] = new CmdStaFlags(i, 2 + i, CanCmdEditNVPane.this.flagTitleStrings[i], CanCmdEditNVPane.this.flagStrings[i], CanCmdEditNVPane.this.flagTtStrings[i], CanCmdEditNVPane.this.flagUpdateFn);
                CanCmdEditNVPane.this.csFlags[i].setFlags(CanCmdEditNVPane.this.getSelectValue8(2 + i));
                flagPane[i] = CanCmdEditNVPane.this.csFlags[i].getContents();
            }
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridx = 0;
            c.gridy = 0;
            CanCmdEditNVPane.this.cmdStaNoSpinner = new TitledSpinner(Bundle.getMessage("CmdStaNo"), 1, CanCmdEditNVPane.this.cmdStaNoUpdateFn);
            CanCmdEditNVPane.this.cmdStaNoSpinner.setToolTip(Bundle.getMessage("CmdStaNoTt"));
            CanCmdEditNVPane.this.cmdStaNoSpinner.init(0, 0, 255, 1);
            gridPane.add((Component)CanCmdEditNVPane.this.cmdStaNoSpinner, c);
            ++c.gridy;
            CanCmdEditNVPane.this.walkaboutSpinner = new TitledSpinner(Bundle.getMessage("WalkaboutTimeout"), 5, CanCmdEditNVPane.this.walkaboutUpdateFn);
            CanCmdEditNVPane.this.walkaboutSpinner.setToolTip(Bundle.getMessage("WalkaboutTimeoutTt"));
            CanCmdEditNVPane.this.walkaboutSpinner.init(CanCmdEditNVPane.this.getSelectValue8(5, 1), 1, 60, 255);
            gridPane.add((Component)CanCmdEditNVPane.this.walkaboutSpinner, c);
            ++c.gridy;
            CanCmdEditNVPane.this.multSpinner = new TitledSpinner(Bundle.getMessage("CurrentMultiplier"), 8, CanCmdEditNVPane.this.multUpdateFn);
            CanCmdEditNVPane.this.multSpinner.setToolTip(Bundle.getMessage("CurrentMultiplierTt"));
            CanCmdEditNVPane.this.multSpinner.init(CanCmdEditNVPane.this.getSelectValue8(8, 1), 1, 10, 255);
            gridPane.add((Component)CanCmdEditNVPane.this.multSpinner, c);
            ++c.gridy;
            CanCmdEditNVPane.this.ackSpinner = new TitledSpinner(Bundle.getMessage("IncCurrentForAck"), 9, CanCmdEditNVPane.this.ackUpdateFn);
            CanCmdEditNVPane.this.ackSpinner.setToolTip(Bundle.getMessage("IncCurrentForAckTt"));
            CanCmdEditNVPane.this.ackSpinner.init(CanCmdEditNVPane.this.getSelectValue8(9, 1), 1, 3, 255);
            gridPane.add((Component)CanCmdEditNVPane.this.ackSpinner, c);
            ++c.gridy;
            CanCmdEditNVPane.this.intervalSpinner = new TitledSpinner(Bundle.getMessage("SendCurrentInterval"), 13, CanCmdEditNVPane.this.intervalUpdateFn);
            CanCmdEditNVPane.this.intervalSpinner.setToolTip(Bundle.getMessage("SendCurrentIntervalTt"));
            CanCmdEditNVPane.this.intervalSpinner.init(CanCmdEditNVPane.this.getSelectValue8(13), 0, 255, 1);
            gridPane.add((Component)CanCmdEditNVPane.this.intervalSpinner, c);
            ++c.gridy;
            c.gridwidth = 3;
            CanCmdEditNVPane.this.mainSpinner = new TitledSpinner(Bundle.getMessage("MainLimit"), 6, CanCmdEditNVPane.this.currentLimitUpdateFn);
            CanCmdEditNVPane.this.mainSpinner.setToolTip(Bundle.getMessage("MainLimitTt"));
            CanCmdEditNVPane.this.mainSpinner.init((double)CanCmdEditNVPane.this.getSelectValue8(6, 1), 1.0, 96.0, 255.0);
            gridPane.add((Component)CanCmdEditNVPane.this.mainSpinner, c);
            ++c.gridy;
            CanCmdEditNVPane.this.progSpinner = new TitledSpinner(Bundle.getMessage("ProgLimit"), 7, CanCmdEditNVPane.this.currentLimitUpdateFn);
            CanCmdEditNVPane.this.progSpinner.setToolTip(Bundle.getMessage("ProgLimitTt"));
            CanCmdEditNVPane.this.progSpinner.init((double)CanCmdEditNVPane.this.getSelectValue8(7, 1), 1.0, 96.0, 255.0);
            gridPane.add((Component)CanCmdEditNVPane.this.progSpinner, c);
            ++c.gridy;
            c.gridx = 0;
            gridPane.add((Component)flagPane[0], c);
            ++c.gridx;
            gridPane.add((Component)flagPane[1], c);
            ++c.gridx;
            gridPane.add((Component)flagPane[2], c);
            ++c.gridx;
            this.add(gridPane);
        }
    }

    protected class UpdateWalkabout
    implements UpdateNV {
        protected UpdateWalkabout() {
        }

        @Override
        public void setNewVal(int index) {
            int delay = CanCmdEditNVPane.this.multSpinner.getIntegerValue();
            CanCmdEditNVPane.this._dataModel.setValueAt(delay, index - 1, 5);
        }
    }

    protected class UpdateMult
    implements UpdateNV {
        protected UpdateMult() {
        }

        @Override
        public void setNewVal(int index) {
            int mult = CanCmdEditNVPane.this.multSpinner.getIntegerValue();
            CanCmdEditNVPane.this._dataModel.setValueAt(mult, index - 1, 5);
        }
    }

    protected class UpdateAck
    implements UpdateNV {
        protected UpdateAck() {
        }

        @Override
        public void setNewVal(int index) {
            int ack = CanCmdEditNVPane.this.ackSpinner.getIntegerValue();
            CanCmdEditNVPane.this._dataModel.setValueAt(ack, index - 1, 5);
        }
    }

    protected class UpdateInterval
    implements UpdateNV {
        protected UpdateInterval() {
        }

        @Override
        public void setNewVal(int index) {
            int interval = CanCmdEditNVPane.this.intervalSpinner.getIntegerValue();
            CanCmdEditNVPane.this._dataModel.setValueAt(interval, index - 1, 5);
        }
    }

    protected class UpdateSodDelay
    implements UpdateNV {
        protected UpdateSodDelay() {
        }

        @Override
        public void setNewVal(int index) {
            int sodDelay = CanCmdEditNVPane.this.sodDelaySpinner.getIntegerValue();
            CanCmdEditNVPane.this._dataModel.setValueAt(sodDelay, index - 1, 5);
        }
    }

    protected class UpdateNnMap
    implements UpdateNV {
        protected UpdateNnMap() {
        }

        @Override
        public void setNewVal(int index) {
            int mapNn = CanCmdEditNVPane.this.nnMapDccSpinner.getIntegerValue();
            int mapNnHi = mapNn / 256;
            int mapNnLo = mapNn % 256;
            CanCmdEditNVPane.this._dataModel.setValueAt(mapNnHi, index - 1, 5);
            CanCmdEditNVPane.this._dataModel.setValueAt(mapNnLo, index, 5);
        }
    }

    protected class UpdateCurrentLimit
    implements UpdateNV {
        protected UpdateCurrentLimit() {
        }

        @Override
        public void setNewVal(int index) {
            double fLimit = index == 6 ? CanCmdEditNVPane.this.mainSpinner.getDoubleValue().doubleValue() : CanCmdEditNVPane.this.progSpinner.getDoubleValue().doubleValue();
            int limit = (int)(fLimit * 100.0 + 0.5);
            CanCmdEditNVPane.this._dataModel.setValueAt(limit, index - 1, 5);
        }
    }

    protected class UpdateFlags
    implements UpdateNV {
        protected UpdateFlags() {
        }

        @Override
        public void setNewVal(int index) {
            int flags = CanCmdEditNVPane.this.csFlags[index].getFlags();
            CanCmdEditNVPane.this._dataModel.setValueAt(flags, CanCmdEditNVPane.this.csFlags[index].getNv() - 1, 5);
        }
    }

    protected class UpdateCmdStaNo
    implements UpdateNV {
        protected UpdateCmdStaNo() {
        }

        @Override
        public void setNewVal(int index) {
            int cmdStaNo = CanCmdEditNVPane.this.cmdStaNoSpinner.getIntegerValue();
            CanCmdEditNVPane.this._dataModel.setValueAt(cmdStaNo, index - 1, 5);
        }
    }
}

