/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.modules.merg;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeNVTableDataModel;
import jmri.jmrix.can.cbus.swing.modules.AbstractEditNVPane;
import jmri.jmrix.can.cbus.swing.modules.TitledSpinner;
import jmri.jmrix.can.cbus.swing.modules.UpdateNV;
import jmri.jmrix.can.cbus.swing.modules.merg.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Canacc8EditNVPane
extends AbstractEditNVPane {
    public static final int OUTPUTS = 8;
    public static final int TYPE_CONTINUOUS = 0;
    public static final int TYPE_SINGLE = 1;
    public static final int TYPE_REPEAT = 2;
    public static final int ACTION_OFF = 3;
    public static final int ACTION_SAVED = 1;
    public static final int ACTION_NONE = 0;
    public static final int PULSE_WIDTH_STEP_SIZE = 20;
    public static final int PULSE_WIDTH_NUM_STEPS = 127;
    public static final double FEEDBACK_DELAY_STEP_SIZE = 0.5;
    OutPane[] out = new OutPane[9];
    private final UpdateNV pulseUpdateFn = new UpdatePulse();
    private final UpdateNV startupUpdateFn = new UpdateStartup();
    private final UpdateNV feedbackUpdateFn = new UpdateFeedback();
    private TitledSpinner feedbackSpinner;
    private static final Logger log = LoggerFactory.getLogger(Canacc8EditNVPane.class);

    protected Canacc8EditNVPane(CbusNodeNVTableDataModel dataModel, CbusNode node) {
        super(dataModel, node);
    }

    @Override
    public AbstractEditNVPane getContent() {
        JPanel gridPane = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridy = 0;
        for (int y = 0; y < 2; ++y) {
            c.gridx = 0;
            for (int x = 0; x < 4; ++x) {
                int index = y * 4 + x + 1;
                this.out[index] = new OutPane(index);
                gridPane.add((Component)this.out[index], c);
                ++c.gridx;
            }
            ++c.gridy;
        }
        c.gridx = 0;
        c.gridy = 3;
        this.feedbackSpinner = new TitledSpinner(Bundle.getMessage("FeedbackDelayUnits"), 9, this.feedbackUpdateFn);
        this.feedbackSpinner.setToolTip(Bundle.getMessage("FeedbackDelayTt"));
        this.feedbackSpinner.init((double)this.getSelectValue8(9) * 0.5, 0.0, 127.5, 0.5);
        gridPane.add((Component)this.feedbackSpinner, c);
        JScrollPane scroll = new JScrollPane(gridPane);
        this.add(scroll);
        return this;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 0) {
            int row = e.getFirstRow();
            int nv = row + 1;
            int value = this.getSelectValue8(nv);
            if (nv > 0 && nv <= 8) {
                int oldSpinnerValue = this.out[nv].pulseSpinner.getIntegerValue() / 20;
                this.out[nv].setButtons(value, oldSpinnerValue);
                this.out[nv].pulseSpinner.setValue((value & 0x7F) * 20);
                log.debug("NV {} Now {}", (Object)nv, (Object)this.out[nv].pulseSpinner.getIntegerValue());
            } else if (nv == 9) {
                this.feedbackSpinner.setValue((double)value * 0.5);
            } else if (nv == 10 || nv == 11) {
                for (int i = 1; i <= 8; ++i) {
                    this.out[i].action.setButtons();
                }
            }
        }
    }

    private class StartupActionPane
    extends JPanel {
        int _index;
        JRadioButton off;
        JRadioButton none;
        JRadioButton saved;

        public StartupActionPane(int index) {
            this._index = index;
            JPanel gridPane = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridx = 0;
            c.gridy = 0;
            Border border = BorderFactory.createEtchedBorder(1);
            TitledBorder title = BorderFactory.createTitledBorder(border, Bundle.getMessage("StartupAction"));
            this.setBorder(title);
            this.off = new JRadioButton(Bundle.getMessage("Off"));
            this.off.setToolTipText(Bundle.getMessage("OffTt"));
            this.none = new JRadioButton(Bundle.getMessage("None"));
            this.none.setToolTipText(Bundle.getMessage("NoneTt"));
            this.saved = new JRadioButton(Bundle.getMessage("SavedAction"));
            this.saved.setToolTipText(Bundle.getMessage("SavedActionTt"));
            this.off.addActionListener(e -> this.startupActionListener());
            this.none.addActionListener(e -> this.startupActionListener());
            this.saved.addActionListener(e -> this.startupActionListener());
            ButtonGroup buttons = new ButtonGroup();
            buttons.add(this.off);
            buttons.add(this.none);
            buttons.add(this.saved);
            this.setButtons();
            if ((Canacc8EditNVPane.this.getSelectValue8(10) & 1 << this._index - 1) > 0) {
                this.off.setSelected(true);
            } else if ((Canacc8EditNVPane.this.getSelectValue8(11) & 1 << this._index - 1) > 0) {
                this.saved.setSelected(true);
            } else {
                this.none.setSelected(true);
            }
            gridPane.add((Component)this.off, c);
            ++c.gridy;
            gridPane.add((Component)this.none, c);
            ++c.gridy;
            gridPane.add((Component)this.saved, c);
            this.add(gridPane);
        }

        public void setButtons() {
            if ((Canacc8EditNVPane.this.getSelectValue8(10) & 1 << this._index - 1) > 0) {
                this.off.setSelected(true);
            } else if ((Canacc8EditNVPane.this.getSelectValue8(11) & 1 << this._index - 1) > 0) {
                this.saved.setSelected(true);
            } else {
                this.none.setSelected(true);
            }
        }

        protected void startupActionListener() {
            Canacc8EditNVPane.this.startupUpdateFn.setNewVal(this._index);
        }
    }

    private class OutPane
    extends JPanel {
        int _index;
        protected JRadioButton cont;
        protected JRadioButton single;
        protected JRadioButton repeat;
        protected TitledSpinner pulseSpinner;
        protected StartupActionPane action;
        protected boolean buttonFlag = false;

        public OutPane(int index) {
            this._index = index;
            JPanel gridPane = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridx = 0;
            c.gridy = 0;
            Border border = BorderFactory.createEtchedBorder(1);
            TitledBorder title = BorderFactory.createTitledBorder(border, Bundle.getMessage("OutputX", this._index));
            this.setBorder(title);
            this.cont = new JRadioButton(Bundle.getMessage("Continuous"));
            this.cont.setToolTipText(Bundle.getMessage("ContinuousTt"));
            this.single = new JRadioButton(Bundle.getMessage("Single"));
            this.single.setToolTipText(Bundle.getMessage("SingleTt"));
            this.repeat = new JRadioButton(Bundle.getMessage("Repeat"));
            this.repeat.setToolTipText(Bundle.getMessage("RepeatTt"));
            this.cont.addActionListener(e -> this.typeActionListener());
            this.single.addActionListener(e -> this.typeActionListener());
            this.repeat.addActionListener(e -> this.typeActionListener());
            ButtonGroup buttons = new ButtonGroup();
            buttons.add(this.cont);
            buttons.add(this.single);
            buttons.add(this.repeat);
            this.pulseSpinner = new TitledSpinner(Bundle.getMessage("PulseWidth"), this._index, Canacc8EditNVPane.this.pulseUpdateFn);
            this.pulseSpinner.setToolTip(Bundle.getMessage("PulseWidthTt"));
            this.pulseSpinner.init((Canacc8EditNVPane.this.getSelectValue8(this._index) & 0x7F) * 20, 0, 2540, 20);
            this.setButtonsInit(Canacc8EditNVPane.this.getSelectValue8(index));
            gridPane.add((Component)this.cont, c);
            ++c.gridy;
            gridPane.add((Component)this.single, c);
            ++c.gridy;
            gridPane.add((Component)this.repeat, c);
            ++c.gridy;
            gridPane.add((Component)this.pulseSpinner, c);
            c.gridx = 1;
            c.gridy = 0;
            c.gridheight = 4;
            this.action = new StartupActionPane(this._index);
            gridPane.add((Component)this.action, c);
            this.add(gridPane);
        }

        protected void setButtonsInit(int pulseWidth) {
            if (pulseWidth == 0 || pulseWidth == 128) {
                this.cont.setSelected(true);
                this.pulseSpinner.setEnabled(false);
            } else if (pulseWidth > 128) {
                this.repeat.setSelected(true);
            } else {
                this.single.setSelected(true);
            }
        }

        protected void setButtons(int pulseWidth, int oldPulseWidth) {
            if (this.buttonFlag) {
                if (this.cont.isSelected()) {
                    this.pulseSpinner.setEnabled(false);
                } else {
                    this.pulseSpinner.setEnabled(true);
                }
                this.buttonFlag = false;
            } else if (!this.pulseSpinner.isEnabled()) {
                if (pulseWidth != 0 && pulseWidth != 128) {
                    this.pulseSpinner.setEnabled(true);
                    if (pulseWidth >= 128) {
                        this.repeat.setSelected(true);
                    } else {
                        this.single.setSelected(true);
                    }
                } else {
                    this.cont.setSelected(true);
                }
            } else if (pulseWidth != oldPulseWidth) {
                if ((pulseWidth & 0x7F) == 0) {
                    this.cont.setSelected(true);
                    this.pulseSpinner.setEnabled(false);
                } else if (pulseWidth >= 128) {
                    this.repeat.setSelected(true);
                } else {
                    this.single.setSelected(true);
                }
            } else if ((pulseWidth & 0x7F) == 0) {
                this.cont.setSelected(true);
                this.pulseSpinner.setEnabled(false);
            }
        }

        protected void typeActionListener() {
            this.buttonFlag = true;
            Canacc8EditNVPane.this.pulseUpdateFn.setNewVal(this._index);
        }
    }

    protected class UpdateFeedback
    implements UpdateNV {
        protected UpdateFeedback() {
        }

        @Override
        public void setNewVal(int index) {
            double delay = Canacc8EditNVPane.this.feedbackSpinner.getDoubleValue();
            int newInt = (int)(delay / 0.5);
            Canacc8EditNVPane.this._dataModel.setValueAt(newInt, index - 1, 5);
        }
    }

    protected class UpdateStartup
    implements UpdateNV {
        protected UpdateStartup() {
        }

        @Override
        public void setNewVal(int index) {
            int newNV10 = Canacc8EditNVPane.this.getSelectValue8(10) & ~(1 << index - 1);
            int newNV11 = Canacc8EditNVPane.this.getSelectValue8(11) & ~(1 << index - 1);
            if (Canacc8EditNVPane.this.out[index].action.off.isSelected()) {
                newNV10 |= 1 << index - 1;
                newNV11 |= 1 << index - 1;
            } else if (Canacc8EditNVPane.this.out[index].action.saved.isSelected()) {
                newNV11 |= 1 << index - 1;
            }
            Canacc8EditNVPane.this._dataModel.setValueAt(newNV10, 9, 5);
            Canacc8EditNVPane.this._dataModel.setValueAt(newNV11, 10, 5);
        }
    }

    protected class UpdatePulse
    implements UpdateNV {
        protected UpdatePulse() {
        }

        @Override
        public void setNewVal(int index) {
            int pulseWidth = Canacc8EditNVPane.this.out[index].pulseSpinner.getIntegerValue();
            pulseWidth /= 20;
            if (Canacc8EditNVPane.this.out[index].cont.isSelected()) {
                pulseWidth = 0;
            }
            if (Canacc8EditNVPane.this.out[index].repeat.isSelected()) {
                pulseWidth |= 0x80;
            }
            if (!(Canacc8EditNVPane.this.getSelectValue8(index) < 128 || Canacc8EditNVPane.this.out[index].buttonFlag && Canacc8EditNVPane.this.out[index].single.isSelected())) {
                pulseWidth |= 0x80;
            }
            Canacc8EditNVPane.this._dataModel.setValueAt(pulseWidth, index - 1, 5);
        }
    }
}

