/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.modules.merg;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeNVTableDataModel;
import jmri.jmrix.can.cbus.swing.modules.AbstractEditNVPane;
import jmri.jmrix.can.cbus.swing.modules.CbusConfigPaneProvider;
import jmri.jmrix.can.cbus.swing.modules.merg.Bundle;
import jmri.jmrix.can.cbus.swing.modules.merg.Canacc8EditNVPane;

public class Canacc8PaneProvider
extends CbusConfigPaneProvider {
    String type = "CANACC8";
    public static final int OUTPUT1 = 1;
    public static final int OUTPUT2 = 2;
    public static final int OUTPUT3 = 3;
    public static final int OUTPUT4 = 4;
    public static final int OUTPUT5 = 5;
    public static final int OUTPUT6 = 6;
    public static final int OUTPUT7 = 7;
    public static final int OUTPUT8 = 8;
    public static final int FEEDBACK_DELAY = 9;
    public static final int STARTUP_POSITION = 10;
    public static final int STARTUP_MOVE = 11;
    private static final Map<Integer, String> nvMap = Canacc8PaneProvider.createNvMap();

    @Override
    @Nonnull
    public String getModuleType() {
        return this.type;
    }

    private static Map<Integer, String> createNvMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(0, "Error - invalid NV index");
        result.put(1, Bundle.getMessage("OutputX", 1));
        result.put(2, Bundle.getMessage("OutputX", 2));
        result.put(3, Bundle.getMessage("OutputX", 3));
        result.put(4, Bundle.getMessage("OutputX", 4));
        result.put(5, Bundle.getMessage("OutputX", 5));
        result.put(6, Bundle.getMessage("OutputX", 6));
        result.put(7, Bundle.getMessage("OutputX", 7));
        result.put(8, Bundle.getMessage("OutputX", 8));
        result.put(9, Bundle.getMessage("FeedbackDelay"));
        result.put(10, Bundle.getMessage("StartupPosition"));
        result.put(11, Bundle.getMessage("StartupMove"));
        return Collections.unmodifiableMap(result);
    }

    @Override
    public String getNVNameByIndex(int index) {
        String nv = nvMap.get(index);
        if (nv == null) {
            return Bundle.getMessage("UnknownNv");
        }
        return nv;
    }

    @Override
    public AbstractEditNVPane getEditNVFrameInstance() {
        return this._nVarEditFrame;
    }

    @Override
    public AbstractEditNVPane getEditNVFrame(CbusNodeNVTableDataModel dataModel, CbusNode node) {
        this._nVarEditFrame = new Canacc8EditNVPane(dataModel, node);
        return this._nVarEditFrame.getContent();
    }
}

