/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.modules.sprogdcc;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeNVTableDataModel;
import jmri.jmrix.can.cbus.swing.modules.AbstractEditNVPane;
import jmri.jmrix.can.cbus.swing.modules.TitledSpinner;
import jmri.jmrix.can.cbus.swing.modules.UpdateNV;
import jmri.jmrix.can.cbus.swing.modules.sprogdcc.Bundle;
import jmri.jmrix.can.cbus.swing.modules.sprogdcc.CanisbPaneProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanisbEditNVPane
extends AbstractEditNVPane {
    private final UpdateNV canIdUpdateFn = new UpdateCanId();
    private final UpdateNV nodeNumberUpdateFn = new UpdateNodeNumber();
    private final UpdateNV arbDelayUpdateFn = new UpdateArbDelay();
    private JRadioButton setup;
    private TitledSpinner canIdSpinner;
    private TitledSpinner nodeNumberSpinner;
    private JRadioButton disable;
    private TitledSpinner arbDelaySpinner;
    String[] rcTitle = new String[]{Bundle.getMessage("CanErrStatus") + " 1", Bundle.getMessage("CanErrStatus") + " 2", Bundle.getMessage("CanTxFailureCount"), Bundle.getMessage("CanRxOverflowCount"), Bundle.getMessage("CanNomBitRateRxCount"), Bundle.getMessage("CanNomBitRateTxCount"), Bundle.getMessage("CanDiagnostics") + " Hi", Bundle.getMessage("CanDiagnostics") + " Lo", Bundle.getMessage("CanErrFreeCount")};
    String[] rcTt = new String[]{Bundle.getMessage("CanErrStatus1Tt"), Bundle.getMessage("CanErrStatus2Tt"), Bundle.getMessage("CanTxFailureCountTt"), Bundle.getMessage("CanRxOverflowCountTt"), Bundle.getMessage("CanNomBitRateRxCountTt"), Bundle.getMessage("CanNomBitRateTxCountTt"), Bundle.getMessage("CanDiagnosticsHiTt"), Bundle.getMessage("CanDiagnosticsLoTt"), Bundle.getMessage("CanErrFreeCountTt")};
    int clearableErrors = this.rcTitle.length;
    JLabel[] rcText = new JLabel[this.clearableErrors];
    JTextField[] rcCount = new JTextField[this.clearableErrors];
    JButton[] rcButton = new JButton[this.clearableErrors];
    JButton rcAllButton = new JButton();
    JButton[] rcUpButton = new JButton[this.clearableErrors];
    JButton rcAllUpButton = new JButton();
    int[] rcNvOffset = new int[]{10, 11, 3, 4, 13, 14, 17, 18, 15};
    String[] rTitle = new String[]{Bundle.getMessage("CanRxErrorCount"), Bundle.getMessage("CanTxErrorCount")};
    String[] rTt = new String[]{Bundle.getMessage("CanRxErrorCountTt"), Bundle.getMessage("CanTxErrorCountTt")};
    int rErrors = this.rTitle.length;
    JLabel[] rText = new JLabel[this.rErrors];
    JTextField[] rCount = new JTextField[this.rErrors];
    JButton[] rUpButton = new JButton[this.rErrors];
    String[] commsTitle = new String[]{Bundle.getMessage("HostTxCnt"), Bundle.getMessage("HostRxCnt"), Bundle.getMessage("CanTxCnt"), Bundle.getMessage("CanRxCnt")};
    String[] commsToolTips = new String[]{Bundle.getMessage("HostTxCntTt"), Bundle.getMessage("HostRxCntTt"), Bundle.getMessage("CanTxCntTt"), Bundle.getMessage("CanRxCntTt")};
    int commsItems = this.commsTitle.length;
    JLabel[] commsText = new JLabel[this.commsItems];
    JTextField[] commsCount = new JTextField[this.commsItems];
    JButton[] commsButton = new JButton[this.commsItems];
    JButton commsAllButton = new JButton();
    JButton[] commsUpButton = new JButton[this.commsItems];
    JButton commsAllUpButton = new JButton();
    int[] commsNvOffset = new int[]{19, 23, 27, 31};
    private static final Logger log = LoggerFactory.getLogger(CanisbEditNVPane.class);

    protected CanisbEditNVPane(CbusNodeNVTableDataModel dataModel, CbusNode node) {
        super(dataModel, node);
    }

    @Override
    public AbstractEditNVPane getContent() {
        JTabbedPane tabbedPane = new JTabbedPane();
        CbusPane cbusPane = new CbusPane();
        DiagnosticsPane diagnosticsPane = new DiagnosticsPane();
        CommsPane commsPane = new CommsPane();
        tabbedPane.addTab("CBUS", cbusPane);
        tabbedPane.addTab(Bundle.getMessage("CanDiagnostics"), diagnosticsPane);
        tabbedPane.addTab(Bundle.getMessage("PacketCounts"), commsPane);
        JScrollPane scroll = new JScrollPane(tabbedPane);
        this.add(scroll);
        return this;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 0) {
            int row = e.getFirstRow();
            int nv = row + 1;
            int value = this.getSelectValue8(nv);
            log.debug("canisb gui table changed NV: {} Value: {}", (Object)nv, (Object)value);
            if (value >= -1) {
                switch (nv) {
                    case 5: {
                        this.setup.setSelected(value != 0);
                        break;
                    }
                    case 7: {
                        this.canIdSpinner.setValue(this.getSelectValue8(7, CanisbPaneProvider.MIN_CANID, CanisbPaneProvider.MAX_CANID));
                        break;
                    }
                    case 8: 
                    case 9: {
                        this.nodeNumberSpinner.setValue(this.getSelectValue16(8, 9, CanisbPaneProvider.MIN_NN, CanisbPaneProvider.MAX_NN));
                        break;
                    }
                    case 1: {
                        this.rCount[0].setText(Integer.toString(value));
                        break;
                    }
                    case 2: {
                        this.rCount[1].setText(Integer.toString(value));
                        break;
                    }
                    case 10: {
                        this.rcCount[0].setText(Integer.toString(value));
                        break;
                    }
                    case 11: {
                        this.rcCount[1].setText(Integer.toString(value));
                        break;
                    }
                    case 3: {
                        this.rcCount[2].setText(Integer.toString(value));
                        break;
                    }
                    case 4: {
                        this.rcCount[3].setText(Integer.toString(value));
                        break;
                    }
                    case 13: {
                        this.rcCount[4].setText(Integer.toString(value));
                        break;
                    }
                    case 14: {
                        this.rcCount[5].setText(Integer.toString(value));
                        break;
                    }
                    case 17: {
                        this.rcCount[6].setText(Integer.toString(value));
                        break;
                    }
                    case 18: {
                        this.rcCount[7].setText(Integer.toString(value));
                        break;
                    }
                    case 15: {
                        break;
                    }
                    case 16: {
                        this.rcCount[8].setText(Integer.toString(value + (Integer)this._dataModel.getValueAt(14, 5) * 256));
                        break;
                    }
                    case 19: 
                    case 20: 
                    case 21: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 31: 
                    case 32: 
                    case 33: {
                        break;
                    }
                    case 22: 
                    case 26: 
                    case 30: 
                    case 34: {
                        int top = nv - 19;
                        top -= top % 4;
                        int topNv = top + 19;
                        this.commsCount[top / 4].setText(Integer.toString(this.getSelectValue32(topNv)));
                        break;
                    }
                    case 35: {
                        this.arbDelaySpinner.setValue(this.getSelectValue8(35, 0, 15));
                        break;
                    }
                }
            }
        }
    }

    public void rcButtonActionPerformed(int button) {
        this._dataModel.setValueAt(0, this.rcNvOffset[button] - 1, 5);
        if (this.rcNvOffset[button] == 15) {
            this._dataModel.setValueAt(0, this.rcNvOffset[button], 5);
        }
    }

    public void allButtonActionPerformed() {
        for (int i = 0; i < this.clearableErrors; ++i) {
            this.rcButtonActionPerformed(i);
        }
    }

    public void rcUpButtonActionPerformed(int button) {
        this._node.send.nVRD(this._node.getNodeNumber(), this.rcNvOffset[button]);
        if (this.rcNvOffset[button] == 15) {
            this._node.send.nVRD(this._node.getNodeNumber() + 1, this.rcNvOffset[button]);
        }
    }

    public void rUpButtonActionPerformed(int button) {
        this._node.send.nVRD(this._node.getNodeNumber(), this.rcNvOffset[button]);
    }

    public void rcAllUpButtonActionPerformed() {
        int i;
        for (i = 0; i < this.clearableErrors; ++i) {
            this.rcUpButtonActionPerformed(i);
        }
        for (i = 0; i < this.rErrors; ++i) {
            this.rUpButtonActionPerformed(i);
        }
    }

    public void commsButtonActionPerformed(int button) {
        this._dataModel.setValueAt(0, this.commsNvOffset[button] - 1, 5);
        this._dataModel.setValueAt(0, this.commsNvOffset[button], 5);
        this._dataModel.setValueAt(0, this.commsNvOffset[button] + 1, 5);
        this._dataModel.setValueAt(0, this.commsNvOffset[button] + 2, 5);
    }

    public void commsAllButtonActionPerformed() {
        for (int i = 0; i < this.commsItems; ++i) {
            this.commsButtonActionPerformed(i);
        }
    }

    public void commsUpButtonActionPerformed(int button) {
        this._node.send.nVRD(this._node.getNodeNumber(), this.commsNvOffset[button]);
        this._node.send.nVRD(this._node.getNodeNumber() + 1, this.commsNvOffset[button]);
        this._node.send.nVRD(this._node.getNodeNumber() + 2, this.commsNvOffset[button]);
        this._node.send.nVRD(this._node.getNodeNumber() + 3, this.commsNvOffset[button]);
    }

    public void commsAllUpButtonActionPerformed() {
        for (int i = 0; i < this.commsItems; ++i) {
            this.commsUpButtonActionPerformed(i);
        }
    }

    public class CommsPane
    extends JPanel {
        public CommsPane() {
            JPanel gridPane = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridx = 0;
            c.gridy = 0;
            JLabel statusCol = new JLabel("");
            gridPane.add((Component)statusCol, c);
            ++c.gridx;
            JLabel col = new JLabel("");
            gridPane.add((Component)col, c);
            ++c.gridx;
            CanisbEditNVPane.this.commsAllButton = new JButton(Bundle.getMessage("ClearAll"));
            CanisbEditNVPane.this.commsAllButton.addActionListener(e -> CanisbEditNVPane.this.commsAllButtonActionPerformed());
            gridPane.add((Component)CanisbEditNVPane.this.commsAllButton, c);
            ++c.gridx;
            CanisbEditNVPane.this.commsAllUpButton = new JButton(Bundle.getMessage("UpdateAll"));
            CanisbEditNVPane.this.commsAllUpButton.addActionListener(e -> CanisbEditNVPane.this.commsAllUpButtonActionPerformed());
            gridPane.add((Component)CanisbEditNVPane.this.commsAllUpButton, c);
            c.gridx = 0;
            ++c.gridy;
            for (int i = 0; i < CanisbEditNVPane.this.commsItems; ++i) {
                CanisbEditNVPane.this.commsText[i] = new JLabel();
                CanisbEditNVPane.this.commsText[i].setText(CanisbEditNVPane.this.commsTitle[i]);
                gridPane.add((Component)CanisbEditNVPane.this.commsText[i], c);
                ++c.gridx;
                CanisbEditNVPane.this.commsCount[i] = new JTextField("0", 10);
                CanisbEditNVPane.this.commsCount[i].setHorizontalAlignment(4);
                CanisbEditNVPane.this.commsCount[i].setToolTipText(CanisbEditNVPane.this.commsToolTips[i]);
                CanisbEditNVPane.this.commsCount[i].setEditable(false);
                gridPane.add((Component)CanisbEditNVPane.this.commsCount[i], c);
                ++c.gridx;
                int button = i;
                CanisbEditNVPane.this.commsButton[i] = new JButton(Bundle.getMessage("Clear"));
                CanisbEditNVPane.this.commsButton[i].addActionListener(e -> CanisbEditNVPane.this.commsButtonActionPerformed(button));
                gridPane.add((Component)CanisbEditNVPane.this.commsButton[i], c);
                ++c.gridx;
                CanisbEditNVPane.this.commsUpButton[i] = new JButton(Bundle.getMessage("Update"));
                CanisbEditNVPane.this.commsUpButton[i].addActionListener(e -> CanisbEditNVPane.this.commsUpButtonActionPerformed(button));
                gridPane.add((Component)CanisbEditNVPane.this.commsUpButton[i], c);
                c.gridx = 0;
                ++c.gridy;
            }
            this.add(gridPane);
        }
    }

    public class DiagnosticsPane
    extends JPanel {
        public DiagnosticsPane() {
            JPanel gridPane = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridx = 0;
            c.gridy = 0;
            JLabel errControl = new JLabel(Bundle.getMessage("CanErrControl"));
            gridPane.add((Component)errControl, c);
            ++c.gridx;
            JTextField errControlBits = new JTextField("0", 5);
            errControlBits.setToolTipText(Bundle.getMessage("CanErrControlTt"));
            errControlBits.setHorizontalAlignment(4);
            gridPane.add((Component)errControlBits, c);
            c.gridx = 0;
            ++c.gridy;
            ++c.gridy;
            JLabel statusCol = new JLabel(Bundle.getMessage("CanErrStatus"));
            gridPane.add((Component)statusCol, c);
            ++c.gridx;
            ++c.gridx;
            CanisbEditNVPane.this.rcAllButton = new JButton(Bundle.getMessage("ClearAll"));
            CanisbEditNVPane.this.rcAllButton.addActionListener(e -> CanisbEditNVPane.this.allButtonActionPerformed());
            gridPane.add((Component)CanisbEditNVPane.this.rcAllButton, c);
            ++c.gridx;
            CanisbEditNVPane.this.rcAllUpButton = new JButton(Bundle.getMessage("UpdateAll"));
            CanisbEditNVPane.this.rcAllUpButton.addActionListener(e -> CanisbEditNVPane.this.rcAllUpButtonActionPerformed());
            gridPane.add((Component)CanisbEditNVPane.this.rcAllUpButton, c);
            c.gridx = 0;
            ++c.gridy;
            for (int i = 0; i < CanisbEditNVPane.this.clearableErrors; ++i) {
                CanisbEditNVPane.this.rcText[i] = new JLabel();
                CanisbEditNVPane.this.rcText[i].setText(CanisbEditNVPane.this.rcTitle[i]);
                gridPane.add((Component)CanisbEditNVPane.this.rcText[i], c);
                ++c.gridx;
                CanisbEditNVPane.this.rcCount[i] = new JTextField("0", 5);
                CanisbEditNVPane.this.rcCount[i].setHorizontalAlignment(4);
                CanisbEditNVPane.this.rcCount[i].setToolTipText(CanisbEditNVPane.this.rcTt[i]);
                CanisbEditNVPane.this.rcCount[i].setEditable(false);
                gridPane.add((Component)CanisbEditNVPane.this.rcCount[i], c);
                ++c.gridx;
                int button = i;
                CanisbEditNVPane.this.rcButton[i] = new JButton(Bundle.getMessage("Clear"));
                CanisbEditNVPane.this.rcButton[i].addActionListener(e -> CanisbEditNVPane.this.rcButtonActionPerformed(button));
                gridPane.add((Component)CanisbEditNVPane.this.rcButton[i], c);
                ++c.gridx;
                CanisbEditNVPane.this.rcUpButton[i] = new JButton(Bundle.getMessage("Update"));
                CanisbEditNVPane.this.rcUpButton[i].addActionListener(e -> CanisbEditNVPane.this.rcUpButtonActionPerformed(button));
                gridPane.add((Component)CanisbEditNVPane.this.rcUpButton[i], c);
                c.gridx = 0;
                ++c.gridy;
            }
            JLabel roHeader = new JLabel(Bundle.getMessage("ReadOnly"));
            gridPane.add((Component)roHeader, c);
            ++c.gridy;
            for (int i = 0; i < CanisbEditNVPane.this.rErrors; ++i) {
                CanisbEditNVPane.this.rText[i] = new JLabel();
                CanisbEditNVPane.this.rText[i].setText(CanisbEditNVPane.this.rTitle[i]);
                gridPane.add((Component)CanisbEditNVPane.this.rText[i], c);
                ++c.gridx;
                CanisbEditNVPane.this.rCount[i] = new JTextField("0", 5);
                CanisbEditNVPane.this.rCount[i].setHorizontalAlignment(4);
                CanisbEditNVPane.this.rCount[i].setToolTipText(CanisbEditNVPane.this.rTt[i]);
                CanisbEditNVPane.this.rCount[i].setEditable(false);
                gridPane.add((Component)CanisbEditNVPane.this.rCount[i], c);
                ++c.gridx;
                ++c.gridx;
                int button = i;
                CanisbEditNVPane.this.rUpButton[i] = new JButton(Bundle.getMessage("Update"));
                CanisbEditNVPane.this.rUpButton[i].addActionListener(e -> CanisbEditNVPane.this.rUpButtonActionPerformed(button));
                gridPane.add((Component)CanisbEditNVPane.this.rUpButton[i], c);
                c.gridx = 0;
                ++c.gridy;
            }
            this.add(gridPane);
        }
    }

    public class CbusPane
    extends JPanel {
        public CbusPane() {
            JPanel gridPane = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridx = 0;
            c.gridy = 0;
            CanisbEditNVPane.this.canIdSpinner = new TitledSpinner(Bundle.getMessage("CanId"), 7, CanisbEditNVPane.this.canIdUpdateFn);
            CanisbEditNVPane.this.canIdSpinner.setToolTip(Bundle.getMessage("CanIdTt"));
            CanisbEditNVPane.this.canIdSpinner.init(CanisbEditNVPane.this.getSelectValue8(7, 100, 127), CanisbPaneProvider.MIN_CANID, CanisbPaneProvider.MAX_CANID, 1);
            gridPane.add((Component)CanisbEditNVPane.this.canIdSpinner, c);
            ++c.gridy;
            CanisbEditNVPane.this.nodeNumberSpinner = new TitledSpinner(Bundle.getMessage("NodeNumber"), 8, CanisbEditNVPane.this.nodeNumberUpdateFn);
            CanisbEditNVPane.this.nodeNumberSpinner.setToolTip(Bundle.getMessage("NodeNumberTt"));
            int nn = CanisbEditNVPane.this.getSelectValue16(8, 9, CanisbPaneProvider.MIN_NN, CanisbPaneProvider.MAX_NN);
            CanisbEditNVPane.this.nodeNumberSpinner.init(nn, CanisbPaneProvider.MIN_NN, CanisbPaneProvider.MAX_NN, 1);
            gridPane.add((Component)CanisbEditNVPane.this.nodeNumberSpinner, c);
            ++c.gridy;
            CanisbEditNVPane.this.setup = new JRadioButton("SetupMode");
            CanisbEditNVPane.this.setup.setSelected(false);
            CanisbEditNVPane.this.setup.setToolTipText(Bundle.getMessage("SetupModeTt"));
            gridPane.add((Component)CanisbEditNVPane.this.setup, c);
            ++c.gridy;
            CanisbEditNVPane.this.disable = new JRadioButton("DisableCan");
            CanisbEditNVPane.this.disable.setSelected(false);
            CanisbEditNVPane.this.disable.setToolTipText(Bundle.getMessage("DisableCanTt"));
            gridPane.add((Component)CanisbEditNVPane.this.disable, c);
            ++c.gridy;
            CanisbEditNVPane.this.arbDelaySpinner = new TitledSpinner(Bundle.getMessage("TxArbDelay"), 35, CanisbEditNVPane.this.arbDelayUpdateFn);
            CanisbEditNVPane.this.arbDelaySpinner.setToolTip(Bundle.getMessage("TxArbDelayTt"));
            CanisbEditNVPane.this.arbDelaySpinner.init(CanisbEditNVPane.this.getSelectValue8(35, 0, 15), 0, 15, 1);
            gridPane.add((Component)CanisbEditNVPane.this.arbDelaySpinner, c);
            ++c.gridy;
            this.add(gridPane);
        }
    }

    protected class UpdateArbDelay
    implements UpdateNV {
        protected UpdateArbDelay() {
        }

        @Override
        public void setNewVal(int index) {
            int cnt = CanisbEditNVPane.this.arbDelaySpinner.getIntegerValue();
            CanisbEditNVPane.this._dataModel.setValueAt(cnt, index - 1, 5);
        }
    }

    protected class UpdateNodeNumber
    implements UpdateNV {
        protected UpdateNodeNumber() {
        }

        @Override
        public void setNewVal(int index) {
            int nn = CanisbEditNVPane.this.nodeNumberSpinner.getIntegerValue();
            int nnHi = nn / 256;
            int nnLo = nn % 256;
            CanisbEditNVPane.this._dataModel.setValueAt(nnHi, index - 1, 5);
            CanisbEditNVPane.this._dataModel.setValueAt(nnLo, index, 5);
        }
    }

    protected class UpdateCanId
    implements UpdateNV {
        protected UpdateCanId() {
        }

        @Override
        public void setNewVal(int index) {
            int canId = CanisbEditNVPane.this.canIdSpinner.getIntegerValue();
            CanisbEditNVPane.this._dataModel.setValueAt(canId, index - 1, 5);
        }
    }
}

