/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.modules.sprogdcc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeNVTableDataModel;
import jmri.jmrix.can.cbus.swing.modules.AbstractEditNVPane;
import jmri.jmrix.can.cbus.swing.modules.CbusConfigPaneProvider;
import jmri.jmrix.can.cbus.swing.modules.sprogdcc.Bundle;
import jmri.jmrix.can.cbus.swing.modules.sprogdcc.CanisbEditNVPane;

public class CanisbPaneProvider
extends CbusConfigPaneProvider {
    String type = "CANISB";
    public static final int RX_ERR_CNT = 1;
    public static final int TX_ERR_CNT = 2;
    public static final int TX_FAIL_CNT = 3;
    public static final int RX_OVFLW_COUNT = 4;
    public static final int SETUP = 5;
    public static final int CAN_DISABLE = 6;
    public static final int CANID = 7;
    public static final int NN_HI = 8;
    public static final int NN_LO = 9;
    public static final int CAN_ERR_STATUS_1 = 10;
    public static final int CAN_ERR_STATUS_2 = 11;
    public static final int CAN_ERR_CONTROL = 12;
    public static final int CAN_NOM_BIT_RATE_RX_COUNT = 13;
    public static final int CAN_NOM_BIT_RATE_TX_COUNT = 14;
    public static final int CAN_ERR_FREE_COUNT_HI = 15;
    public static final int CAN_ERR_FREE_COUNT_LO = 16;
    public static final int CAN_DIAGNOSTICS_HI = 17;
    public static final int CAN_DIAGNOSTICS_LO = 18;
    public static final int HOST_TX_CNT_T = 19;
    public static final int HOST_TX_CNT_U = 20;
    public static final int HOST_TX_CNT_H = 21;
    public static final int HOST_TX_CNT_L = 22;
    public static final int HOST_RX_CNT_T = 23;
    public static final int HOST_RX_CNT_U = 24;
    public static final int HOST_RX_CNT_H = 25;
    public static final int HOST_RX_CNT_L = 26;
    public static final int CAN_TX_CNT_T = 27;
    public static final int CAN_TX_CNT_U = 28;
    public static final int CAN_TX_CNT_H = 29;
    public static final int CAN_TX_CNT_L = 30;
    public static final int CAN_RX_CNT_T = 31;
    public static final int CAN_RX_CNT_U = 32;
    public static final int CAN_RX_CNT_H = 33;
    public static final int CAN_RX_CNT_L = 34;
    public static final int CAN_TX_ARB_DELAY = 35;
    public static int MIN_CANID = 100;
    public static int MAX_CANID = 127;
    public static int MIN_NN = 65520;
    public static int MAX_NN = 65534;
    protected static final Map<Integer, String> nvMap = CanisbPaneProvider.createNvMap();

    @Override
    @Nonnull
    public String getModuleType() {
        return this.type;
    }

    protected static Map<Integer, String> createNvMap() {
        HashMap<Integer, Object> result = new HashMap<Integer, Object>();
        result.put(0, "Error - invalid NV index");
        result.put(1, Bundle.getMessage("CanRxErrorCount"));
        result.put(2, Bundle.getMessage("CanTxErrorCount"));
        result.put(3, Bundle.getMessage("CanTxFailureCount"));
        result.put(4, Bundle.getMessage("CanRxOverflowCount"));
        result.put(5, Bundle.getMessage("SetupMode"));
        result.put(6, Bundle.getMessage("CanDisable"));
        result.put(7, Bundle.getMessage("CanId"));
        result.put(8, Bundle.getMessage("NodeNumberHi"));
        result.put(9, Bundle.getMessage("NodeNumberLo"));
        result.put(10, Bundle.getMessage("CanErrStatus") + " 1");
        result.put(11, Bundle.getMessage("CanErrStatus") + " 2");
        result.put(12, Bundle.getMessage("CanErrControl"));
        result.put(13, Bundle.getMessage("CanNomBitRateRxCount"));
        result.put(14, Bundle.getMessage("CanNomBitRateTxCount"));
        result.put(15, Bundle.getMessage("CanErrFreeCount") + " Hi");
        result.put(16, Bundle.getMessage("CanErrFreeCount") + " Lo");
        result.put(17, Bundle.getMessage("CanDiagnostics") + " Hi");
        result.put(18, Bundle.getMessage("CanDiagnostics") + " Lo");
        result.put(19, Bundle.getMessage("HostTxCnt") + " Top");
        result.put(20, Bundle.getMessage("HostTxCnt") + " Upper");
        result.put(21, Bundle.getMessage("HostTxCnt") + " Hi");
        result.put(22, Bundle.getMessage("HostTxCnt") + " Lo");
        result.put(23, Bundle.getMessage("HostRxCnt") + " Top");
        result.put(24, Bundle.getMessage("HostRxCnt") + " Upper");
        result.put(25, Bundle.getMessage("HostRxCnt") + " Hi");
        result.put(26, Bundle.getMessage("HostRxCnt") + " Lo");
        result.put(27, Bundle.getMessage("CanTxCnt") + " Top");
        result.put(28, Bundle.getMessage("CanTxCnt") + " Upper");
        result.put(29, Bundle.getMessage("CanTxCnt") + " Hi");
        result.put(30, Bundle.getMessage("CanTxCnt") + " Lo");
        result.put(31, Bundle.getMessage("CanRxCnt") + " Top");
        result.put(32, Bundle.getMessage("CanRxCnt") + " Upper");
        result.put(33, Bundle.getMessage("CanRxCnt") + " Hi");
        result.put(34, Bundle.getMessage("CanRxCnt") + " Lo");
        result.put(35, Bundle.getMessage("TxArbDelay"));
        return Collections.unmodifiableMap(result);
    }

    @Override
    public String getNVNameByIndex(int index) {
        String nv = nvMap.get(index);
        if (nv == null) {
            return Bundle.getMessage("UnknownNv");
        }
        return nv;
    }

    @Override
    public AbstractEditNVPane getEditNVFrameInstance() {
        return this._nVarEditFrame;
    }

    @Override
    public AbstractEditNVPane getEditNVFrame(CbusNodeNVTableDataModel dataModel, CbusNode node) {
        this._nVarEditFrame = new CanisbEditNVPane(dataModel, node);
        return this._nVarEditFrame.getContent();
    }
}

