/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.modules.sprogdcc;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.TableModelEvent;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeNVTableDataModel;
import jmri.jmrix.can.cbus.swing.modules.AbstractEditNVPane;
import jmri.jmrix.can.cbus.swing.modules.CmdStaFlags;
import jmri.jmrix.can.cbus.swing.modules.TitledSpinner;
import jmri.jmrix.can.cbus.swing.modules.UpdateNV;
import jmri.jmrix.can.cbus.swing.modules.sprogdcc.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PiSprog3EditNVPane
extends AbstractEditNVPane {
    private static final int USER_FLAGS = 0;
    private static final int OPS_FLAGS = 1;
    private CmdStaFlags[] csFlags = new CmdStaFlags[2];
    private final UpdateNV currentLimitUpdateFn = new UpdateCurrentLimit();
    private final UpdateNV accyPktUpdateFn = new UpdateAccyCount();
    private final UpdateNV preambleUpdateFn = new UpdatePreamble();
    private final UpdateNV modeUpdateFn = new UpdatePowerMode();
    private final UpdateNV meterUpdateFn = new UpdateMeter();
    private final UpdateNV flagUpdateFn = new UpdateFlags();
    private JComboBox<String> modeList;
    private TitledSpinner mainSpinner;
    private TitledSpinner accyPktSpinner;
    private JRadioButton meter;
    private JRadioButton setup;
    private TitledSpinner preambleSpinner;
    protected String[] flagTitleStrings = new String[]{Bundle.getMessage("UserFlags"), Bundle.getMessage("OperationsFlags")};
    protected String[][] flagStrings = new String[][]{{Bundle.getMessage("Reserved"), Bundle.getMessage("PermitSteal"), Bundle.getMessage("PermitShare"), Bundle.getMessage("Reserved"), Bundle.getMessage("MapEvents"), Bundle.getMessage("StopOnTimeout"), Bundle.getMessage("StartOfDay"), Bundle.getMessage("AutoPower")}, {Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved"), Bundle.getMessage("ZtcMode"), Bundle.getMessage("AllStopTrackOff"), Bundle.getMessage("BluelineMode"), Bundle.getMessage("AckSensitivity"), Bundle.getMessage("Reserved")}};
    protected String[][] flagTtStrings = new String[][]{{Bundle.getMessage("ReservedTt"), Bundle.getMessage("PermitStealTt"), Bundle.getMessage("PermitShareTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("MapEventsTt"), Bundle.getMessage("StopOnTimeoutTt"), Bundle.getMessage("StartOfDayTt"), Bundle.getMessage("AutoPowerTt")}, {Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ZtcModeTt"), Bundle.getMessage("AllStopTrackOffTt"), Bundle.getMessage("BluelineModeTt"), Bundle.getMessage("AckSensitivityTt"), Bundle.getMessage("ReservedTt")}};
    private static final Logger log = LoggerFactory.getLogger(PiSprog3EditNVPane.class);

    protected PiSprog3EditNVPane(CbusNodeNVTableDataModel dataModel, CbusNode node) {
        super(dataModel, node);
    }

    @Override
    public AbstractEditNVPane getContent() {
        JTabbedPane tabbedPane = new JTabbedPane();
        CmdStaPane cmdStaPane = new CmdStaPane();
        DccPane dccPane = new DccPane();
        CbusPane cbusPane = new CbusPane();
        tabbedPane.addTab(Bundle.getMessage("CmdSta"), cmdStaPane);
        tabbedPane.addTab("DCC", dccPane);
        tabbedPane.addTab("CBUS Diagnostics", cbusPane);
        JScrollPane scroll = new JScrollPane(tabbedPane);
        this.add(scroll);
        return this;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 0) {
            int row = e.getFirstRow();
            int nv = row + 1;
            int value = this.getSelectValue8(nv);
            log.debug("pisprog3 gui table changed NV: {} Value: {}", (Object)nv, (Object)value);
            switch (nv) {
                case 12: {
                    this.csFlags[0].setFlags(value);
                    break;
                }
                case 13: {
                    this.csFlags[1].setFlags(value);
                    break;
                }
                case 5: {
                    if (value == this.modeList.getSelectedIndex()) break;
                    this.modeList.setSelectedIndex(value);
                    break;
                }
                case 6: {
                    double mainLimit = (double)value / 100.0;
                    this.mainSpinner.setValue(mainLimit);
                    break;
                }
                case 9: {
                    this.accyPktSpinner.setValue(value);
                    break;
                }
                case 10: {
                    this.meter.setSelected(value != 0);
                    break;
                }
                case 1: {
                    this.setup.setSelected(value != 0);
                    break;
                }
                case 11: {
                    this.preambleSpinner.setValue(value);
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
            }
        }
    }

    public class CbusPane
    extends JPanel {
        public CbusPane() {
            JPanel gridPane = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridx = 0;
            c.gridy = 0;
            PiSprog3EditNVPane.this.setup = new JRadioButton("SetupMode");
            PiSprog3EditNVPane.this.setup.setSelected(false);
            PiSprog3EditNVPane.this.setup.setToolTipText(Bundle.getMessage("SetupModeTt"));
            gridPane.add((Component)PiSprog3EditNVPane.this.setup, c);
            ++c.gridy;
            this.add(gridPane);
        }
    }

    public class DccPane
    extends JPanel {
        public DccPane() {
            JPanel gridPane = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridx = 0;
            c.gridy = 0;
            PiSprog3EditNVPane.this.accyPktSpinner = new TitledSpinner(Bundle.getMessage("AccyPktCnt"), 9, PiSprog3EditNVPane.this.accyPktUpdateFn);
            PiSprog3EditNVPane.this.accyPktSpinner.setToolTip(Bundle.getMessage("AccyPktCntTt"));
            PiSprog3EditNVPane.this.accyPktSpinner.init(PiSprog3EditNVPane.this.getSelectValue8(9, 1), 1, 7, 1);
            gridPane.add((Component)PiSprog3EditNVPane.this.accyPktSpinner, c);
            ++c.gridy;
            PiSprog3EditNVPane.this.preambleSpinner = new TitledSpinner(Bundle.getMessage("DccPreambles"), 11, PiSprog3EditNVPane.this.preambleUpdateFn);
            PiSprog3EditNVPane.this.preambleSpinner.setToolTip(Bundle.getMessage("DccPreamblesTt"));
            PiSprog3EditNVPane.this.preambleSpinner.init(PiSprog3EditNVPane.this.getSelectValue8(11, 14), 14, 32, 1);
            gridPane.add((Component)PiSprog3EditNVPane.this.preambleSpinner, c);
            this.add(gridPane);
        }
    }

    public class CmdStaPane
    extends JPanel {
        public CmdStaPane() {
            JPanel gridPane = new JPanel(new GridBagLayout());
            JPanel[] flagPane = new JPanel[2];
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            for (int i = 0; i < 2; ++i) {
                PiSprog3EditNVPane.this.csFlags[i] = new CmdStaFlags(i, 12 + i, PiSprog3EditNVPane.this.flagTitleStrings[i], PiSprog3EditNVPane.this.flagStrings[i], PiSprog3EditNVPane.this.flagTtStrings[i], PiSprog3EditNVPane.this.flagUpdateFn);
                PiSprog3EditNVPane.this.csFlags[i].setFlags(PiSprog3EditNVPane.this.getSelectValue8(12 + i));
                flagPane[i] = PiSprog3EditNVPane.this.csFlags[i].getContents();
            }
            String[] modeStrings = new String[]{Bundle.getMessage("ProgMode"), Bundle.getMessage("CmdMode")};
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 3;
            PiSprog3EditNVPane.this.modeList = new JComboBox<String>(modeStrings);
            PiSprog3EditNVPane.this.modeList.setSelectedIndex(PiSprog3EditNVPane.this.getSelectValue8(5));
            PiSprog3EditNVPane.this.modeList.addActionListener(e -> this.modeActionListener(e));
            gridPane.add(PiSprog3EditNVPane.this.modeList, c);
            c.gridwidth = 1;
            ++c.gridy;
            PiSprog3EditNVPane.this.meter = new JRadioButton(Bundle.getMessage("Multimeter"));
            PiSprog3EditNVPane.this.meter.setSelected(false);
            PiSprog3EditNVPane.this.meter.setToolTipText(Bundle.getMessage("MultimeterTt"));
            PiSprog3EditNVPane.this.meter.addActionListener(e -> this.meterActionListener(e));
            gridPane.add((Component)PiSprog3EditNVPane.this.meter, c);
            ++c.gridy;
            PiSprog3EditNVPane.this.mainSpinner = new TitledSpinner(Bundle.getMessage("MainLimit"), 6, PiSprog3EditNVPane.this.currentLimitUpdateFn);
            PiSprog3EditNVPane.this.mainSpinner.setToolTip(Bundle.getMessage("MainLimitTt"));
            PiSprog3EditNVPane.this.mainSpinner.init((double)PiSprog3EditNVPane.this.getSelectValue8(6, 100) / 100.0, 1.0, 2.5, 0.01);
            gridPane.add((Component)PiSprog3EditNVPane.this.mainSpinner, c);
            ++c.gridy;
            c.gridx = 0;
            gridPane.add((Component)flagPane[0], c);
            ++c.gridx;
            gridPane.add((Component)flagPane[1], c);
            ++c.gridx;
            this.add(gridPane);
        }

        protected void modeActionListener(ActionEvent e) {
            log.debug("modeActionListener()");
            PiSprog3EditNVPane.this.modeUpdateFn.setNewVal(5);
        }

        protected void meterActionListener(ActionEvent e) {
            PiSprog3EditNVPane.this.meterUpdateFn.setNewVal(10);
        }
    }

    protected class UpdatePowerMode
    implements UpdateNV {
        protected UpdatePowerMode() {
        }

        @Override
        public void setNewVal(int index) {
            log.debug("UpdatePowerMode.setNewVal()");
            int mode = PiSprog3EditNVPane.this.modeList.getSelectedIndex();
            PiSprog3EditNVPane.this._dataModel.setValueAt(mode, index - 1, 5);
        }
    }

    protected class UpdatePreamble
    implements UpdateNV {
        protected UpdatePreamble() {
        }

        @Override
        public void setNewVal(int index) {
            int pre = PiSprog3EditNVPane.this.preambleSpinner.getIntegerValue();
            PiSprog3EditNVPane.this._dataModel.setValueAt(pre, index - 1, 5);
        }
    }

    protected class UpdateAccyCount
    implements UpdateNV {
        protected UpdateAccyCount() {
        }

        @Override
        public void setNewVal(int index) {
            int cnt = PiSprog3EditNVPane.this.accyPktSpinner.getIntegerValue();
            PiSprog3EditNVPane.this._dataModel.setValueAt(cnt, index - 1, 5);
        }
    }

    protected class UpdateCurrentLimit
    implements UpdateNV {
        protected UpdateCurrentLimit() {
        }

        @Override
        public void setNewVal(int index) {
            double fLimit = PiSprog3EditNVPane.this.mainSpinner.getDoubleValue();
            int limit = (int)(fLimit * 100.0 + 0.5);
            PiSprog3EditNVPane.this._dataModel.setValueAt(limit, index - 1, 5);
        }
    }

    protected class UpdateMeter
    implements UpdateNV {
        protected UpdateMeter() {
        }

        @Override
        public void setNewVal(int index) {
            int mode = PiSprog3EditNVPane.this.meter.isSelected() ? 1 : 0;
            PiSprog3EditNVPane.this._dataModel.setValueAt(mode, index - 1, 5);
        }
    }

    protected class UpdateFlags
    implements UpdateNV {
        protected UpdateFlags() {
        }

        @Override
        public void setNewVal(int index) {
            int flags = PiSprog3EditNVPane.this.csFlags[index].getFlags();
            PiSprog3EditNVPane.this._dataModel.setValueAt(flags, PiSprog3EditNVPane.this.csFlags[index].getNv() - 1, 5);
        }
    }
}

