/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.modules.sprogdcc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeNVTableDataModel;
import jmri.jmrix.can.cbus.swing.modules.AbstractEditNVPane;
import jmri.jmrix.can.cbus.swing.modules.CbusConfigPaneProvider;
import jmri.jmrix.can.cbus.swing.modules.sprogdcc.Bundle;
import jmri.jmrix.can.cbus.swing.modules.sprogdcc.PiSprog3EditNVPane;

public class PiSprog3PaneProvider
extends CbusConfigPaneProvider {
    String type = "Pi-SPROG 3";
    public static final int SETUP = 1;
    public static final int ZTC_MODE = 2;
    public static final int BLUELINE_MODE = 3;
    public static final int ACK_SENSITIVITY = 4;
    public static final int CMD_STATION_MODE = 5;
    public static final int CURRENT_LIMIT = 6;
    public static final int INPUT_VOLTAGE = 7;
    public static final int TRACK_CURRENT = 8;
    public static final int ACCY_PACKET_REPEAT_COUNT = 9;
    public static final int MULTIMETER_MODE = 10;
    public static final int DCC_PREAMBLE = 11;
    public static final int USER_FLAGS = 12;
    public static final int OPERATIONS_FLAGS = 13;
    public static int MIN_CANID = 100;
    public static int MAX_CANID = 127;
    public static int MIN_NN = 65520;
    public static int MAX_NN = 65535;
    private static final Map<Integer, String> nvMap = PiSprog3PaneProvider.createNvMap();

    @Override
    @Nonnull
    public String getModuleType() {
        return this.type;
    }

    private static Map<Integer, String> createNvMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(0, "Error - invalid NV index");
        result.put(1, Bundle.getMessage("SetupMode"));
        result.put(2, Bundle.getMessage("ZtcMode"));
        result.put(3, Bundle.getMessage("BluelineMode"));
        result.put(4, Bundle.getMessage("AckSensitivity"));
        result.put(5, Bundle.getMessage("CmdStaMode"));
        result.put(6, Bundle.getMessage("CurrentLimit"));
        result.put(7, Bundle.getMessage("InputVoltage"));
        result.put(8, Bundle.getMessage("TrackCurrent"));
        result.put(9, Bundle.getMessage("AccessoryPacketRepeatCount"));
        result.put(10, Bundle.getMessage("MultimeterMode"));
        result.put(11, Bundle.getMessage("DccPreambleBits"));
        result.put(12, Bundle.getMessage("UserFlags"));
        result.put(13, Bundle.getMessage("OperationsFlags"));
        result.put(12, Bundle.getMessage("UserFlags"));
        result.put(13, Bundle.getMessage("OperationsFlags"));
        return Collections.unmodifiableMap(result);
    }

    @Override
    public String getNVNameByIndex(int index) {
        String nv = nvMap.get(index);
        if (nv == null) {
            return Bundle.getMessage("UnknownNv");
        }
        return nv;
    }

    @Override
    public AbstractEditNVPane getEditNVFrameInstance() {
        return this._nVarEditFrame;
    }

    @Override
    public AbstractEditNVPane getEditNVFrame(CbusNodeNVTableDataModel dataModel, CbusNode node) {
        this._nVarEditFrame = new PiSprog3EditNVPane(dataModel, node);
        return this._nVarEditFrame.getContent();
    }
}

