/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.modules.sprogdcc;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.TableModelEvent;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeNVTableDataModel;
import jmri.jmrix.can.cbus.swing.modules.AbstractEditNVPane;
import jmri.jmrix.can.cbus.swing.modules.CmdStaFlags;
import jmri.jmrix.can.cbus.swing.modules.TitledSpinner;
import jmri.jmrix.can.cbus.swing.modules.UpdateNV;
import jmri.jmrix.can.cbus.swing.modules.sprogdcc.Bundle;
import jmri.jmrix.can.cbus.swing.modules.sprogdcc.Sprog3PlusPaneProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sprog3PlusEditNVPane
extends AbstractEditNVPane {
    private CmdStaFlags[] csFlags = new CmdStaFlags[4];
    private final UpdateNV cmdStaNoUpdateFn = new UpdateCmdStaNo();
    private final UpdateNV canIdUpdateFn = new UpdateCanId();
    private final UpdateNV nodeNumberUpdateFn = new UpdateNodeNumber();
    private final UpdateNV currentLimitUpdateFn = new UpdateCurrentLimit();
    private final UpdateNV accyPktUpdateFn = new UpdateAccyCount();
    private final UpdateNV nnMapUpdateFn = new UpdateNnMap();
    private final UpdateNV preambleUpdateFn = new UpdatePreamble();
    private final UpdateNV powerModeUpdateFn = new UpdatePowerMode();
    private final UpdateNV meterUpdateFn = new UpdateMeter();
    private final UpdateNV flagUpdateFn = new UpdateFlags();
    private TitledSpinner cmdStaNoSpinner;
    private JComboBox<String> powerModeList;
    private TitledSpinner mainSpinner;
    private TitledSpinner progSpinner;
    private TitledSpinner accyPktSpinner;
    private JRadioButton meter;
    private TitledSpinner nnMapDccSpinner;
    private JRadioButton setup;
    private TitledSpinner canIdSpinner;
    private TitledSpinner nodeNumberSpinner;
    private TitledSpinner preambleSpinner;
    private JRadioButton disable;
    protected String[] flagTitleStrings = new String[]{Bundle.getMessage("UserFlags"), Bundle.getMessage("OperationsFlags"), Bundle.getMessage("DebugFlags"), Bundle.getMessage("UserFlags2")};
    protected String[][] flagStrings = new String[][]{{Bundle.getMessage("Reserved"), Bundle.getMessage("PermitSteal"), Bundle.getMessage("PermitShare"), Bundle.getMessage("Reserved"), Bundle.getMessage("MapEvents"), Bundle.getMessage("StopOnTimeout"), Bundle.getMessage("StartOfDay"), Bundle.getMessage("AutoPower")}, {Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved"), Bundle.getMessage("ZtcMode"), Bundle.getMessage("AllStopTrackOff"), Bundle.getMessage("BluelineMode"), Bundle.getMessage("AckSensitivity"), Bundle.getMessage("Reserved")}, {Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved")}, {Bundle.getMessage("MapEventsOffset"), Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved"), Bundle.getMessage("Reserved")}};
    protected String[][] flagTtStrings = new String[][]{{Bundle.getMessage("ReservedTt"), Bundle.getMessage("PermitStealTt"), Bundle.getMessage("PermitShareTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("MapEventsTt"), Bundle.getMessage("StopOnTimeoutTt"), Bundle.getMessage("StartOfDayTt"), Bundle.getMessage("AutoPowerTt")}, {Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ZtcModeTt"), Bundle.getMessage("AllStopTrackOffTt"), Bundle.getMessage("BluelineModeTt"), Bundle.getMessage("AckSensitivityTt"), Bundle.getMessage("ReservedTt")}, {Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt")}, {Bundle.getMessage("MapEventsOffsetTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt"), Bundle.getMessage("ReservedTt")}};
    private static final Logger log = LoggerFactory.getLogger(Sprog3PlusEditNVPane.class);

    protected Sprog3PlusEditNVPane(CbusNodeNVTableDataModel dataModel, CbusNode node) {
        super(dataModel, node);
    }

    @Override
    public AbstractEditNVPane getContent() {
        JTabbedPane tabbedPane = new JTabbedPane();
        CmdStaPane cmdStaPane = new CmdStaPane();
        DccPane dccPane = new DccPane();
        CbusPane cbusPane = new CbusPane();
        tabbedPane.addTab(Bundle.getMessage("CmdSta"), cmdStaPane);
        tabbedPane.addTab("DCC", dccPane);
        tabbedPane.addTab("CBUS Diagnostics", cbusPane);
        JScrollPane scroll = new JScrollPane(tabbedPane);
        this.add(scroll);
        return this;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 0) {
            int row = e.getFirstRow();
            int nv = row + 1;
            int value = this.getSelectValue8(nv);
            log.debug("sprog3plus gui table changed NV: {} Value: {}", (Object)nv, (Object)value);
            switch (nv) {
                case 1: {
                    this.cmdStaNoSpinner.setValue(value);
                    break;
                }
                case 2: {
                    this.csFlags[0].setFlags(value);
                    break;
                }
                case 3: {
                    this.csFlags[1].setFlags(value);
                    break;
                }
                case 4: {
                    this.csFlags[2].setFlags(value);
                    break;
                }
                case 23: {
                    this.csFlags[3].setFlags(value);
                    break;
                }
                case 5: {
                    if (value == this.powerModeList.getSelectedIndex()) break;
                    this.powerModeList.setSelectedIndex(value);
                    break;
                }
                case 6: {
                    double progLimit = (double)value / 100.0;
                    this.progSpinner.setValue(progLimit);
                    break;
                }
                case 13: {
                    double mainLimit = (double)value / 100.0;
                    this.mainSpinner.setValue(mainLimit);
                    break;
                }
                case 9: {
                    this.accyPktSpinner.setValue(value);
                    break;
                }
                case 10: {
                    this.meter.setSelected(value != 0);
                    break;
                }
                case 11: 
                case 12: {
                    this.nnMapDccSpinner.setValue(this.getSelectValue16(11, 12, 0, 65535));
                    break;
                }
                case 17: {
                    this.setup.setSelected(value != 0);
                    break;
                }
                case 18: {
                    this.canIdSpinner.setValue(value);
                    break;
                }
                case 19: 
                case 20: {
                    this.nodeNumberSpinner.setValue(this.getSelectValue16(19, 20, Sprog3PlusPaneProvider.MIN_NN, Sprog3PlusPaneProvider.MAX_NN));
                    break;
                }
                case 21: {
                    this.preambleSpinner.setValue(value);
                    break;
                }
                case 22: {
                    this.disable.setEnabled(value != 0);
                    break;
                }
                case 7: 
                case 8: 
                case 14: 
                case 15: 
                case 16: {
                    break;
                }
            }
        }
    }

    public class CbusPane
    extends JPanel {
        public CbusPane() {
            JPanel gridPane = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridx = 0;
            c.gridy = 0;
            Sprog3PlusEditNVPane.this.canIdSpinner = new TitledSpinner(Bundle.getMessage("CanId"), 18, Sprog3PlusEditNVPane.this.canIdUpdateFn);
            Sprog3PlusEditNVPane.this.canIdSpinner.setToolTip(Bundle.getMessage("CanIdTt"));
            Sprog3PlusEditNVPane.this.canIdSpinner.init(Sprog3PlusEditNVPane.this.getSelectValue8(18, Sprog3PlusPaneProvider.MIN_CANID, Sprog3PlusPaneProvider.MAX_CANID), 100, 127, 1);
            gridPane.add((Component)Sprog3PlusEditNVPane.this.canIdSpinner, c);
            ++c.gridy;
            Sprog3PlusEditNVPane.this.nodeNumberSpinner = new TitledSpinner(Bundle.getMessage("NodeNumber"), 19, Sprog3PlusEditNVPane.this.nodeNumberUpdateFn);
            Sprog3PlusEditNVPane.this.nodeNumberSpinner.setToolTip(Bundle.getMessage("NodeNumberTt"));
            int nn = Sprog3PlusEditNVPane.this.getSelectValue16(19, 20, Sprog3PlusPaneProvider.MIN_NN, Sprog3PlusPaneProvider.MAX_NN);
            Sprog3PlusEditNVPane.this.nodeNumberSpinner.init(nn, 65520, 65534, 1);
            gridPane.add((Component)Sprog3PlusEditNVPane.this.nodeNumberSpinner, c);
            ++c.gridy;
            Sprog3PlusEditNVPane.this.setup = new JRadioButton("SetupMode");
            Sprog3PlusEditNVPane.this.setup.setSelected(false);
            Sprog3PlusEditNVPane.this.setup.setToolTipText(Bundle.getMessage("SetupModeTt"));
            gridPane.add((Component)Sprog3PlusEditNVPane.this.setup, c);
            ++c.gridy;
            Sprog3PlusEditNVPane.this.disable = new JRadioButton("DisableCan");
            Sprog3PlusEditNVPane.this.disable.setSelected(false);
            Sprog3PlusEditNVPane.this.disable.setToolTipText(Bundle.getMessage("DisableCanTt"));
            gridPane.add((Component)Sprog3PlusEditNVPane.this.disable, c);
            ++c.gridy;
            this.add(gridPane);
        }
    }

    public class DccPane
    extends JPanel {
        public DccPane() {
            JPanel gridPane = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridx = 0;
            c.gridy = 0;
            Sprog3PlusEditNVPane.this.accyPktSpinner = new TitledSpinner(Bundle.getMessage("AccyPktCnt"), 9, Sprog3PlusEditNVPane.this.accyPktUpdateFn);
            Sprog3PlusEditNVPane.this.accyPktSpinner.setToolTip(Bundle.getMessage("AccyPktCntTt"));
            Sprog3PlusEditNVPane.this.accyPktSpinner.init(Sprog3PlusEditNVPane.this.getSelectValue8(9, 1), 1, 7, 1);
            gridPane.add((Component)Sprog3PlusEditNVPane.this.accyPktSpinner, c);
            ++c.gridy;
            Sprog3PlusEditNVPane.this.nnMapDccSpinner = new TitledSpinner(Bundle.getMessage("NnMapDcc"), 11, Sprog3PlusEditNVPane.this.nnMapUpdateFn);
            Sprog3PlusEditNVPane.this.nnMapDccSpinner.setToolTip(Bundle.getMessage("NnMapDccTt"));
            int nn = Sprog3PlusEditNVPane.this.getSelectValue16(11, 12, 0, 65535);
            Sprog3PlusEditNVPane.this.nnMapDccSpinner.init(nn, 0, 65535, 1);
            gridPane.add((Component)Sprog3PlusEditNVPane.this.nnMapDccSpinner, c);
            ++c.gridy;
            gridPane.add((Component)Sprog3PlusEditNVPane.this.nnMapDccSpinner, c);
            ++c.gridy;
            Sprog3PlusEditNVPane.this.preambleSpinner = new TitledSpinner(Bundle.getMessage("DccPreambles"), 21, Sprog3PlusEditNVPane.this.preambleUpdateFn);
            Sprog3PlusEditNVPane.this.preambleSpinner.setToolTip(Bundle.getMessage("DccPreamblesTt"));
            Sprog3PlusEditNVPane.this.preambleSpinner.init(Sprog3PlusEditNVPane.this.getSelectValue8(21, 14), 14, 32, 1);
            gridPane.add((Component)Sprog3PlusEditNVPane.this.preambleSpinner, c);
            this.add(gridPane);
        }
    }

    public class CmdStaPane
    extends JPanel {
        public CmdStaPane() {
            JPanel gridPane = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            int flagPanels = 3;
            if (Sprog3PlusEditNVPane.this._node.getNodeParamManager().isFwEqualOrNewer(2, 101, 2)) {
                flagPanels = 4;
            }
            JPanel[] flagPane = new JPanel[flagPanels];
            int[] flagNvs = new int[]{2, 3, 4, 23};
            for (int i = 0; i < flagPanels; ++i) {
                Sprog3PlusEditNVPane.this.csFlags[i] = new CmdStaFlags(i, flagNvs[i], Sprog3PlusEditNVPane.this.flagTitleStrings[i], Sprog3PlusEditNVPane.this.flagStrings[i], Sprog3PlusEditNVPane.this.flagTtStrings[i], Sprog3PlusEditNVPane.this.flagUpdateFn);
                Sprog3PlusEditNVPane.this.csFlags[i].setFlags(Sprog3PlusEditNVPane.this.getSelectValue8(flagNvs[i]));
                flagPane[i] = Sprog3PlusEditNVPane.this.csFlags[i].getContents();
            }
            String[] powerModeStrings = new String[]{Bundle.getMessage("ProgOffMode"), Bundle.getMessage("ProgOnMode"), Bundle.getMessage("ProgArMode")};
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridx = 0;
            c.gridy = 0;
            Sprog3PlusEditNVPane.this.cmdStaNoSpinner = new TitledSpinner(Bundle.getMessage("CmdStaNo"), 1, Sprog3PlusEditNVPane.this.cmdStaNoUpdateFn);
            Sprog3PlusEditNVPane.this.cmdStaNoSpinner.setToolTip(Bundle.getMessage("CmdStaNoTt"));
            Sprog3PlusEditNVPane.this.cmdStaNoSpinner.init(0, 0, 255, 1);
            gridPane.add((Component)Sprog3PlusEditNVPane.this.cmdStaNoSpinner, c);
            ++c.gridy;
            c.gridwidth = flagPanels;
            Sprog3PlusEditNVPane.this.powerModeList = new JComboBox<String>(powerModeStrings);
            Sprog3PlusEditNVPane.this.powerModeList.setSelectedIndex(Sprog3PlusEditNVPane.this.getSelectValue8(5));
            Sprog3PlusEditNVPane.this.powerModeList.addActionListener(e -> this.pwrModeActionListener(e));
            gridPane.add(Sprog3PlusEditNVPane.this.powerModeList, c);
            c.gridwidth = 1;
            ++c.gridy;
            Sprog3PlusEditNVPane.this.meter = new JRadioButton(Bundle.getMessage("Multimeter"));
            Sprog3PlusEditNVPane.this.meter.setSelected(false);
            Sprog3PlusEditNVPane.this.meter.setToolTipText(Bundle.getMessage("MultimeterTt"));
            Sprog3PlusEditNVPane.this.meter.addActionListener(e -> this.meterActionListener(e));
            gridPane.add((Component)Sprog3PlusEditNVPane.this.meter, c);
            ++c.gridy;
            Sprog3PlusEditNVPane.this.mainSpinner = new TitledSpinner(Bundle.getMessage("MainLimit"), 13, Sprog3PlusEditNVPane.this.currentLimitUpdateFn);
            Sprog3PlusEditNVPane.this.mainSpinner.setToolTip(Bundle.getMessage("MainLimitTt"));
            Sprog3PlusEditNVPane.this.mainSpinner.init((double)Sprog3PlusEditNVPane.this.getSelectValue8(13, 100) / 100.0, 1.0, 2.5, 0.01);
            gridPane.add((Component)Sprog3PlusEditNVPane.this.mainSpinner, c);
            ++c.gridx;
            Sprog3PlusEditNVPane.this.progSpinner = new TitledSpinner(Bundle.getMessage("ProgLimit"), 6, Sprog3PlusEditNVPane.this.currentLimitUpdateFn);
            Sprog3PlusEditNVPane.this.progSpinner.setToolTip(Bundle.getMessage("ProgLimitTt"));
            Sprog3PlusEditNVPane.this.progSpinner.init((double)Sprog3PlusEditNVPane.this.getSelectValue8(6, 100) / 100.0, 1.0, 2.5, 0.01);
            gridPane.add((Component)Sprog3PlusEditNVPane.this.progSpinner, c);
            ++c.gridy;
            c.gridx = 0;
            for (int i = 0; i < flagPanels; ++i) {
                gridPane.add((Component)flagPane[i], c);
                ++c.gridx;
            }
            this.add(gridPane);
        }

        protected void pwrModeActionListener(ActionEvent e) {
            log.debug("pwrModeActionListener()");
            Sprog3PlusEditNVPane.this.powerModeUpdateFn.setNewVal(5);
        }

        protected void meterActionListener(ActionEvent e) {
            Sprog3PlusEditNVPane.this.meterUpdateFn.setNewVal(10);
        }
    }

    protected class UpdatePowerMode
    implements UpdateNV {
        protected UpdatePowerMode() {
        }

        @Override
        public void setNewVal(int index) {
            log.debug("UpdatePowerMode.setNewVal()");
            int mode = Sprog3PlusEditNVPane.this.powerModeList.getSelectedIndex();
            Sprog3PlusEditNVPane.this._dataModel.setValueAt(mode, index - 1, 5);
        }
    }

    protected class UpdatePreamble
    implements UpdateNV {
        protected UpdatePreamble() {
        }

        @Override
        public void setNewVal(int index) {
            int pre = Sprog3PlusEditNVPane.this.preambleSpinner.getIntegerValue();
            Sprog3PlusEditNVPane.this._dataModel.setValueAt(pre, index - 1, 5);
        }
    }

    protected class UpdateNnMap
    implements UpdateNV {
        protected UpdateNnMap() {
        }

        @Override
        public void setNewVal(int index) {
            int mapNn = Sprog3PlusEditNVPane.this.nnMapDccSpinner.getIntegerValue();
            int mapNnHi = mapNn / 256;
            int mapNnLo = mapNn % 256;
            Sprog3PlusEditNVPane.this._dataModel.setValueAt(mapNnHi, index - 1, 5);
            Sprog3PlusEditNVPane.this._dataModel.setValueAt(mapNnLo, index, 5);
        }
    }

    protected class UpdateAccyCount
    implements UpdateNV {
        protected UpdateAccyCount() {
        }

        @Override
        public void setNewVal(int index) {
            int cnt = Sprog3PlusEditNVPane.this.accyPktSpinner.getIntegerValue();
            Sprog3PlusEditNVPane.this._dataModel.setValueAt(cnt, index - 1, 5);
        }
    }

    protected class UpdateCurrentLimit
    implements UpdateNV {
        protected UpdateCurrentLimit() {
        }

        @Override
        public void setNewVal(int index) {
            double fLimit = index == 13 ? Sprog3PlusEditNVPane.this.mainSpinner.getDoubleValue().doubleValue() : Sprog3PlusEditNVPane.this.progSpinner.getDoubleValue().doubleValue();
            int limit = (int)(fLimit * 100.0 + 0.5);
            Sprog3PlusEditNVPane.this._dataModel.setValueAt(limit, index - 1, 5);
        }
    }

    protected class UpdateMeter
    implements UpdateNV {
        protected UpdateMeter() {
        }

        @Override
        public void setNewVal(int index) {
            int mode = Sprog3PlusEditNVPane.this.meter.isSelected() ? 1 : 0;
            Sprog3PlusEditNVPane.this._dataModel.setValueAt(mode, index - 1, 5);
        }
    }

    protected class UpdateNodeNumber
    implements UpdateNV {
        protected UpdateNodeNumber() {
        }

        @Override
        public void setNewVal(int index) {
            int nn = Sprog3PlusEditNVPane.this.nodeNumberSpinner.getIntegerValue();
            int nnHi = nn / 256;
            int nnLo = nn % 256;
            Sprog3PlusEditNVPane.this._dataModel.setValueAt(nnHi, index - 1, 5);
            Sprog3PlusEditNVPane.this._dataModel.setValueAt(nnLo, index, 5);
        }
    }

    protected class UpdateCanId
    implements UpdateNV {
        protected UpdateCanId() {
        }

        @Override
        public void setNewVal(int index) {
            int canId = Sprog3PlusEditNVPane.this.canIdSpinner.getIntegerValue();
            Sprog3PlusEditNVPane.this._dataModel.setValueAt(canId, index - 1, 5);
        }
    }

    protected class UpdateFlags
    implements UpdateNV {
        protected UpdateFlags() {
        }

        @Override
        public void setNewVal(int index) {
            int flags = Sprog3PlusEditNVPane.this.csFlags[index].getFlags();
            Sprog3PlusEditNVPane.this._dataModel.setValueAt(flags, Sprog3PlusEditNVPane.this.csFlags[index].getNv() - 1, 5);
        }
    }

    protected class UpdateCmdStaNo
    implements UpdateNV {
        protected UpdateCmdStaNo() {
        }

        @Override
        public void setNewVal(int index) {
            int cmdStaNo = Sprog3PlusEditNVPane.this.cmdStaNoSpinner.getIntegerValue();
            Sprog3PlusEditNVPane.this._dataModel.setValueAt(cmdStaNo, index - 1, 5);
        }
    }
}

