/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.nodeconfig;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeConstants;
import jmri.jmrix.can.cbus.node.CbusNodeFromBackup;
import jmri.jmrix.can.cbus.swing.nodeconfig.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusNodeBackupTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    private CbusNode _nodeOfInterest;
    public static final int DATE_COLUMN = 0;
    public static final int STATUS_COLUMN = 1;
    public static final int BYTES_COLUMN = 2;
    public static final int COMMENT_COLUMN = 3;
    public static final int DESCRIPTION_COLUMN = 4;
    private static final Logger log = LoggerFactory.getLogger(CbusNodeBackupTableModel.class);

    public CbusNodeBackupTableModel(CbusNode nodeOfInterest) {
        this._nodeOfInterest = nodeOfInterest;
    }

    public void setNode(CbusNode newNode) {
        this._nodeOfInterest = newNode;
        this.fireTableDataChanged();
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if (ev.getPropertyName().equals("BACKUPS")) {
            this.fireTableDataChanged();
        }
    }

    @Override
    public Class<?> getColumnClass(int c) {
        switch (c) {
            case 0: {
                return Date.class;
            }
            case 1: {
                return CbusNodeConstants.BackupType.class;
            }
            case 2: {
                return Integer.class;
            }
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public int getRowCount() {
        if (this._nodeOfInterest == null) {
            return 0;
        }
        return this._nodeOfInterest.getNodeBackupManager().getBackups().size();
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return c == 3;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Date / Time";
            }
            case 1: {
                return "Backup Integrity";
            }
            case 2: {
                return Bundle.getMessage("TotalBytes");
            }
            case 3: {
                return Bundle.getMessage("ColumnComment");
            }
        }
        return "";
    }

    public static int getPreferredWidth(int col) {
        switch (col) {
            case 0: {
                return new JTextField((int)20).getPreferredSize().width;
            }
            case 1: {
                return new JTextField((int)60).getPreferredSize().width;
            }
            case 2: {
                return new JTextField((int)8).getPreferredSize().width;
            }
            case 3: {
                return new JTextField((int)80).getPreferredSize().width;
            }
            case 4: {
                return new JTextField((int)70).getPreferredSize().width;
            }
        }
        return new JTextField((int)8).getPreferredSize().width;
    }

    @Override
    public Object getValueAt(int r, int c) {
        if (r > this._nodeOfInterest.getNodeBackupManager().getBackups().size()) {
            c = -1;
        }
        CbusNodeFromBackup lc = this._nodeOfInterest.getNodeBackupManager().getBackups().get(r);
        switch (c) {
            case 0: {
                return lc.getBackupTimeStamp();
            }
            case 1: {
                return lc.getBackupResult();
            }
            case 2: {
                return lc.getNodeStats().totalNodeFileBytes();
            }
            case 3: {
                return lc.getBackupComment();
            }
            case 4: {
                return this.getDescription(r, lc);
            }
        }
        return null;
    }

    private String getDescription(int r, CbusNodeFromBackup lc) {
        if (r == this._nodeOfInterest.getNodeBackupManager().getBackups().size() - 1) {
            return "First Backup on File";
        }
        if (lc.getBackupResult() == CbusNodeConstants.BackupType.NOTONNETWORK) {
            return CbusNodeConstants.BackupType.NOTONNETWORK.toString();
        }
        return lc.compareWithString(this.getPreviousBackup(r + 1));
    }

    @CheckForNull
    private CbusNodeFromBackup getPreviousBackup(int arrayIndex) {
        for (int i = arrayIndex; i < this._nodeOfInterest.getNodeBackupManager().getBackups().size() - 1; ++i) {
            if (this._nodeOfInterest.getNodeBackupManager().getBackups().get(i).getBackupResult() == CbusNodeConstants.BackupType.NOTONNETWORK) continue;
            return this._nodeOfInterest.getNodeBackupManager().getBackups().get(i);
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 3) {
            this._nodeOfInterest.getNodeBackupManager().getBackups().get(row).setBackupComment(String.valueOf(value));
            if (!this._nodeOfInterest.getNodeBackupManager().doStore(false, this._nodeOfInterest.getNodeStats().hasLoadErrors())) {
                log.error("Unable to save Backup User Comment to File");
            }
        }
    }
}

