/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.nodeconfig;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeConstants;
import jmri.jmrix.can.cbus.node.CbusNodeEventTableDataModel;
import jmri.jmrix.can.cbus.node.CbusNodeFromBackup;
import jmri.jmrix.can.cbus.node.CbusNodeNVTableDataModel;
import jmri.jmrix.can.cbus.swing.CbusCommonSwing;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeBackupTableModel;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeConfigTab;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeEventTablePane;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeInfoPane;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeNVEditTablePane;
import jmri.jmrix.can.cbus.swing.nodeconfig.NodeConfigToolPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusNodeBackupsPane
extends CbusNodeConfigTab
implements TableModelListener {
    public SimpleDateFormat readableDateStyle = new SimpleDateFormat("HH:mm EEE d MMM");
    private JScrollPane eventScroll;
    private JPanel backupInfoPane;
    private JPanel newInfoPane;
    private JSplitPane split;
    private ActionListener newBackupListener;
    private ActionListener deleteBackupListener;
    private JButton newBackupButton;
    private JLabel headerText;
    private JPanel evMenuPane;
    private JTable backupTable;
    private JTabbedPane tabbedBackupPane;
    private CbusNodeNVTableDataModel nodeNVModel;
    private CbusNodeNVEditTablePane nodevarPane;
    private CbusNodeEventTablePane nodeEventPane;
    private CbusNodeInfoPane nodeInfoPane;
    private CbusNodeBackupTableModel cbusNodeBackupTableModel;
    public static final Color VERY_LIGHT_RED = new Color(255, 176, 173);
    public static final Color VERY_LIGHT_GREEN = new Color(165, 255, 164);
    public static final Color WHITE_GREEN = new Color(245, 245, 245);
    private static final Logger log = LoggerFactory.getLogger(CbusNodeBackupsPane.class);

    protected CbusNodeBackupsPane(NodeConfigToolPane main) {
        super(main);
        this.initPane();
    }

    @Override
    public String getTitle() {
        return "Node Backups";
    }

    public final void initPane() {
        if (this.eventScroll != null) {
            this.eventScroll.setVisible(false);
            this.evMenuPane.setVisible(false);
        }
        this.eventScroll = null;
        this.evMenuPane = null;
        this.newBackupButton = new JButton("Create New Backup");
        this.evMenuPane = new JPanel();
        this.evMenuPane.add(this.newBackupButton);
        this.cbusNodeBackupTableModel = new CbusNodeBackupTableModel(null);
        this.cbusNodeBackupTableModel.addTableModelListener(this);
        this.backupTable = new JTable(this.cbusNodeBackupTableModel);
        this.backupTable.setRowHeight(26);
        this.backupTable.setDefaultRenderer(Date.class, this.getRenderer());
        this.backupTable.setDefaultRenderer(String.class, this.getRenderer());
        this.backupTable.setDefaultRenderer(Integer.class, this.getRenderer());
        this.backupTable.setDefaultRenderer(CbusNodeConstants.BackupType.class, this.getRenderer());
        this.backupTable.setAutoCreateRowSorter(true);
        this.backupTable.setSelectionMode(0);
        for (int i = 0; i < this.backupTable.getColumnCount(); ++i) {
            this.backupTable.getColumnModel().getColumn(i).setPreferredWidth(CbusNodeBackupTableModel.getPreferredWidth(i));
        }
        this.headerText = new JLabel("");
        this.evMenuPane.add(this.headerText);
        this.updateHeaderText();
        JScrollPane backupTableScrollPane = new JScrollPane(this.backupTable);
        this.nodeInfoPane = new CbusNodeInfoPane(null);
        this.nodeNVModel = new CbusNodeNVTableDataModel(null, 5, 8);
        this.nodevarPane = new CbusNodeNVEditTablePane(this.nodeNVModel);
        this.nodevarPane.setNonEditable();
        CbusNodeEventTableDataModel nodeEvModel = new CbusNodeEventTableDataModel(null, null, 10, 7);
        this.nodeEventPane = new CbusNodeEventTablePane(nodeEvModel);
        this.nodeEventPane.setHideEditButton();
        this.backupInfoPane = new JPanel();
        this.backupInfoPane.setLayout(new BorderLayout());
        this.tabbedBackupPane = new JTabbedPane();
        this.tabbedBackupPane.addTab("Backup Info", this.backupInfoPane);
        this.tabbedBackupPane.addTab("Node Info", this.nodeInfoPane);
        this.tabbedBackupPane.addTab("Node Variables", this.nodevarPane);
        this.tabbedBackupPane.addTab("Node Events", this.nodeEventPane);
        this.split = new JSplitPane(0, backupTableScrollPane, this.tabbedBackupPane);
        this.split.setContinuousLayout(false);
        this.split.setDividerLocation(100);
        this.add((Component)this.evMenuPane, "First");
        this.add((Component)this.split, "Center");
        this.validate();
        this.repaint();
        this.newBackupListener = ae -> this.saveBackup();
        this.newBackupButton.addActionListener(this.newBackupListener);
        this.backupTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.userBackupViewChanged();
            }
        });
        this.tabbedBackupPane.addChangeListener(e -> this.userBackupViewChanged());
    }

    @Override
    protected void disposeOfNode(CbusNode node) {
        node.removePropertyChangeListener(this.cbusNodeBackupTableModel);
        super.disposeOfNode(node);
    }

    @Override
    public void changedNode(CbusNode node) {
        this.cbusNodeBackupTableModel.setNode(this.nodeOfInterest);
        this.nodeOfInterest.addPropertyChangeListener(this.cbusNodeBackupTableModel);
        this.userBackupViewChanged();
    }

    private void userBackupViewChanged() {
        CbusNodeFromBackup backupNode;
        int sel = this.backupTable.getSelectedRow();
        if (this.backupTable.getSelectedRow() > -1) {
            backupNode = this.nodeOfInterest.getNodeBackupManager().getBackups().get(this.backupTable.convertRowIndexToModel(sel));
            this.tabbedBackupPane.setEnabled(true);
            if (this.tabbedBackupPane.getSelectedIndex() == 1) {
                this.nodeInfoPane.setNode(backupNode);
            }
            if (this.tabbedBackupPane.getSelectedIndex() == 2) {
                this.nodevarPane.setNode(backupNode);
            }
            if (this.tabbedBackupPane.getSelectedIndex() == 3) {
                this.nodeEventPane.setNode(backupNode);
            }
        } else {
            backupNode = null;
            this.tabbedBackupPane.setSelectedIndex(0);
            this.tabbedBackupPane.setEnabled(false);
        }
        log.debug("user view changed node {}, index {}", (Object)backupNode, (Object)this.tabbedBackupPane.getSelectedIndex());
        if (this.tabbedBackupPane.getSelectedIndex() == 0) {
            if (this.newInfoPane != null) {
                this.newInfoPane.setVisible(false);
            }
            this.newInfoPane = null;
            this.newInfoPane = new JPanel();
            if (backupNode != null) {
                JScrollPane scroll = new JScrollPane(this.getBackupPanel(backupNode));
                this.newInfoPane.setLayout(new BorderLayout());
                this.newInfoPane.add(scroll);
                this.backupInfoPane.add(this.newInfoPane);
                this.backupInfoPane.revalidate();
            } else {
                JLabel nvstring = new JLabel("<html><h3>No Backup Selected</h3></html>");
                this.newInfoPane.add(nvstring);
                this.backupInfoPane.add(this.newInfoPane);
                this.backupInfoPane.validate();
                this.backupInfoPane.repaint();
            }
        }
    }

    private JPanel getBackupPanel(CbusNodeFromBackup backupNode) {
        StringBuilder text = new StringBuilder();
        text.append("<html><h3>").append(this.readableDateStyle.format(backupNode.getBackupTimeStamp())).append("</h3>").append(" <h4>NV's : ").append(Math.max(0, backupNode.getNodeParamManager().getParameter(6))).append("</h4>").append("<h4>Events : ").append(Math.max(0, backupNode.getNodeEventManager().getTotalNodeEvents())).append("</h4>").append("<h4>Params : ").append(Math.max(0, backupNode.getNodeParamManager().getParameter(0))).append("</h4>").append("</html>");
        JLabel nvstring = new JLabel(text.toString());
        JPanel evPane = new JPanel();
        evPane.setLayout(new BoxLayout(evPane, 0));
        evPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        evPane.add(nvstring);
        JButton restoreBackupButton = new JButton("Restore Backup");
        JButton deleteBackupButton = new JButton("Delete Backup");
        restoreBackupButton.setEnabled(false);
        if (backupNode.getBackupResult() == CbusNodeConstants.BackupType.COMPLETE) {
            if (backupNode.getNodeNvManager().getTotalNVs() == this.nodeOfInterest.getNodeNvManager().getTotalNVs()) {
                if (backupNode.getNodeParamManager().getParameter(5) == this.nodeOfInterest.getNodeParamManager().getParameter(5)) {
                    restoreBackupButton.setToolTipText(null);
                    restoreBackupButton.setEnabled(true);
                } else {
                    restoreBackupButton.setToolTipText("Event Variable total does not match");
                }
            } else {
                restoreBackupButton.setToolTipText("NV total does not match");
            }
        } else {
            restoreBackupButton.setToolTipText("Backup Incomplete");
        }
        this.deleteBackupListener = ae -> this.deleteBackup(this.backupTable.convertRowIndexToModel(this.backupTable.getSelectedRow()));
        deleteBackupButton.addActionListener(this.deleteBackupListener);
        ActionListener restore = ae -> this.getMainPane().showConfirmThenSave(backupNode, this.nodeOfInterest, true, true, true, null);
        restoreBackupButton.addActionListener(restore);
        evPane.add(restoreBackupButton);
        evPane.add(deleteBackupButton);
        return evPane;
    }

    private void updateHeaderText() {
        if (this.nodeOfInterest != null) {
            StringBuilder text = new StringBuilder();
            text.append("<html><h4>");
            if (this.nodeOfInterest.getNodeBackupManager().getBackups().size() == 1) {
                text.append(this.nodeOfInterest.getNodeBackupManager().getBackups().size()).append(" xml entry");
            } else {
                text.append(this.nodeOfInterest.getNodeBackupManager().getBackups().size()).append(" xml entries");
            }
            text.append("</h4></html>");
            this.headerText.setText(text.toString());
            this.evMenuPane.revalidate();
            this.evMenuPane.repaint();
        }
    }

    private void saveBackup() {
        if (!this.nodeOfInterest.getNodeBackupManager().doStore(true, this.nodeOfInterest.getNodeStats().hasLoadErrors())) {
            log.error("Issue saving Backup File");
        }
        this.cbusNodeBackupTableModel.fireTableDataChanged();
    }

    private void deleteBackup(int bup) {
        int rowAfter = Math.max(0, this.backupTable.getSelectedRow() - 1);
        this.nodeOfInterest.getNodeBackupManager().getBackups().remove(bup);
        if (!this.nodeOfInterest.getNodeBackupManager().doStore(false, this.nodeOfInterest.getNodeStats().hasLoadErrors())) {
            log.error("Issue saving Backup File following remove single entry");
        }
        this.cbusNodeBackupTableModel.fireTableDataChanged();
        if (this.backupTable.getRowCount() > 0) {
            this.backupTable.getSelectionModel().setSelectionInterval(rowAfter, rowAfter);
        }
    }

    private TableCellRenderer getRenderer() {
        return new TableCellRenderer(){
            JTextField f = new JTextField();

            @Override
            public Component getTableCellRendererComponent(JTable table, Object arg1, boolean isSelected, boolean hasFocus, int row, int col) {
                this.f.setHorizontalAlignment(0);
                this.f.setBorder(table.getBorder());
                CbusCommonSwing.setCellBackground(isSelected, this.f, table, row);
                if (arg1 != null) {
                    String string = arg1.toString();
                    this.f.setText(string);
                    CbusCommonSwing.setCellFromDate(arg1, this.f, CbusNodeBackupsPane.this.readableDateStyle);
                    CbusCommonSwing.setCellFromBackupEnum(arg1, this.f);
                } else {
                    this.f.setText("");
                }
                CbusCommonSwing.setCellFocus(hasFocus, this.f, table);
                return this.f;
            }
        };
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.updateHeaderText();
    }

    @Override
    public void dispose() {
        this.disposeOfNode(this.nodeOfInterest);
        this.nodeOfInterest.removePropertyChangeListener(this.cbusNodeBackupTableModel);
    }
}

