/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.nodeconfig;

import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.swing.nodeconfig.Bundle;
import jmri.jmrix.can.cbus.swing.nodeconfig.NodeConfigToolPane;
import jmri.jmrix.can.swing.CanPanel;
import jmri.util.swing.JmriJOptionPane;

public abstract class CbusNodeConfigTab
extends CanPanel
implements PropertyChangeListener {
    protected CbusNode nodeOfInterest;
    private final NodeConfigToolPane mainpane;
    private boolean _activeDialogue;

    protected CbusNodeConfigTab(NodeConfigToolPane main) {
        this.mainpane = main;
        if (main != null) {
            super.initComponents(main.getMemo());
        }
        super.setLayout(new BorderLayout());
        this._activeDialogue = false;
    }

    protected NodeConfigToolPane getMainPane() {
        return this.mainpane;
    }

    public final void setNode(CbusNode node) {
        if (this.nodeOfInterest != null) {
            if (this.nodeOfInterest.equals(node)) {
                return;
            }
            this.disposeOfNode(this.nodeOfInterest);
        }
        if (node != null) {
            this.nodeOfInterest = node;
            this.nodeOfInterest.addPropertyChangeListener(this);
            this.changedNode(node);
            this.setVisible(true);
            this.validate();
            this.repaint();
        }
    }

    protected boolean getVetoBeingChanged() {
        return false;
    }

    protected void setActiveDialog(boolean newVal) {
        this._activeDialogue = newVal;
    }

    protected boolean getActiveDialog() {
        return this._activeDialogue;
    }

    protected final int getTabIndex() {
        return this.getMainPane().getTabs().indexOf(this);
    }

    protected abstract void changedNode(@Nonnull CbusNode var1);

    @OverridingMethodsMustInvokeSuper
    protected void disposeOfNode(@Nonnull CbusNode node) {
        node.removePropertyChangeListener(this);
    }

    protected int getNodeRow() {
        return this.getMainPane().nodeTable.convertRowIndexToView(this.getMainPane().getNodeModel().getNodeRowFromNodeNum(this.nodeOfInterest.getNodeNumber()));
    }

    protected void resetViewToVeto() {
        this.getMainPane().nodeTable.getSelectionModel().clearSelection();
        this.getMainPane().nodeTable.getSelectionModel().setSelectionInterval(this.getNodeRow(), this.getNodeRow());
        this.getMainPane().tabbedPane.setSelectedIndex(this.getTabIndex());
    }

    protected boolean getCancelSaveEditDialog(String adviceString) {
        this.setActiveDialog(true);
        this.resetViewToVeto();
        int selectedValue = JmriJOptionPane.showOptionDialog(this.getParent(), "<html>" + adviceString + "<br>" + Bundle.getMessage("ContinueEditQuestion") + "</html>", Bundle.getMessage("WarningTitle") + " " + this.nodeOfInterest, -1, 3, null, new String[]{Bundle.getMessage("CancelEdit"), Bundle.getMessage("SaveEdit"), Bundle.getMessage("ContinueEdit")}, Bundle.getMessage("ContinueEdit"));
        this.setActiveDialog(false);
        switch (selectedValue) {
            case -1: 
            case 0: {
                this.cancelOption();
                return false;
            }
            case 1: {
                this.saveOption();
                return false;
            }
        }
        return true;
    }

    protected void cancelOption() {
    }

    protected void saveOption() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
    }

    @Override
    public void dispose() {
        if (this.nodeOfInterest != null) {
            this.disposeOfNode(this.nodeOfInterest);
        }
        super.dispose();
    }
}

