/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.nodeconfig;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.CbusNameService;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeEvent;
import jmri.jmrix.can.cbus.node.CbusNodeSingleEventTableDataModel;
import jmri.jmrix.can.cbus.node.CbusNodeTableDataModel;
import jmri.jmrix.can.cbus.swing.nodeconfig.Bundle;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeSingleEventEditTablePane;
import jmri.jmrix.can.cbus.swing.nodeconfig.NodeConfigToolPane;
import jmri.util.JmriJFrame;
import jmri.util.ThreadingUtil;
import jmri.util.swing.BusyDialog;
import jmri.util.swing.JSpinnerUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusNodeEditEventFrame
extends JmriJFrame
implements TableModelListener,
PropertyChangeListener {
    private CbusNodeSingleEventTableDataModel singleEVModel;
    private final CbusNodeTableDataModel nodeModel;
    private JSpinner numberSpinnerEv;
    private JSpinner numberSpinnernd;
    private JButton framedeletebutton;
    private JButton frameeditevbutton;
    private JButton frameCopyButton;
    private JTabbedPane tabbedPane;
    private CbusNodeEvent _ndEv;
    private CbusNode _node;
    private JLabel ndEvNameLabel;
    private final NodeConfigToolPane mainpane;
    private BusyDialog busy_dialog;
    private CanSystemConnectionMemo _memo;
    private JPanel infoPane;
    private JButton framenewevbutton;
    private JButton frameResetButton;
    private boolean isNewEvent;
    private static final Logger log = LoggerFactory.getLogger(CbusNodeEditEventFrame.class);

    public CbusNodeEditEventFrame(NodeConfigToolPane tp) {
        this.mainpane = tp;
        this.nodeModel = this.mainpane.getNodeModel();
    }

    public void initComponents(CanSystemConnectionMemo memo, CbusNodeEvent ndEv) {
        this._ndEv = ndEv;
        this._memo = memo;
        this.singleEVModel = new CbusNodeSingleEventTableDataModel(memo, 5, 7, this._ndEv);
        this.singleEVModel.addTableModelListener(this);
        this.screenInit();
    }

    private void screenInit() {
        if (this.infoPane != null) {
            this.infoPane.setVisible(false);
            this.infoPane = null;
        }
        if (this._ndEv == null) {
            return;
        }
        this._node = this.nodeModel.getNodeByNodeNum(this._ndEv.getParentNn());
        if (this._node != null) {
            this._node.addPropertyChangeListener(this);
        }
        this.isNewEvent = this._node != null && this._node.getNodeEventManager().getNodeEvent(this._ndEv.getNn(), this._ndEv.getEn()) == null;
        log.debug("isNewEvent {}", (Object)this.isNewEvent);
        this.frameeditevbutton = new JButton(Bundle.getMessage("EditEvent"));
        this.framenewevbutton = new JButton(Bundle.getMessage("NewEvent"));
        this.framedeletebutton = new JButton(Bundle.getMessage("ButtonDelete"));
        this.frameResetButton = new JButton("Reset New Values");
        this.frameCopyButton = new JButton("Copy Event");
        this.numberSpinnernd = new JSpinner(new SpinnerNumberModel(Math.max(0, this._ndEv.getNn()), 0, 65535, 1));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.numberSpinnernd, "#");
        this.numberSpinnernd.setEditor(editor);
        JSpinnerUtil.setCommitsOnValidEdit(this.numberSpinnernd, true);
        this.numberSpinnerEv = new JSpinner(new SpinnerNumberModel(Math.max(0, this._ndEv.getEn()), 0, 65535, 1));
        JSpinner.NumberEditor neditor = new JSpinner.NumberEditor(this.numberSpinnernd, "#");
        this.numberSpinnernd.setEditor(neditor);
        JSpinnerUtil.setCommitsOnValidEdit(this.numberSpinnerEv, true);
        this.infoPane = new JPanel();
        this.infoPane.setLayout(new BorderLayout());
        JPanel pageStartPanel = new JPanel();
        pageStartPanel.setLayout(new BoxLayout(pageStartPanel, 1));
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.frameCopyButton);
        buttonPanel.add(this.frameResetButton);
        buttonPanel.add(this.framedeletebutton);
        JPanel spinnerPanel = new JPanel();
        spinnerPanel.add(new JLabel(Bundle.getMessage("CbusNode"), 4));
        spinnerPanel.add(this.numberSpinnernd);
        spinnerPanel.add(new JLabel(Bundle.getMessage("CbusEvent"), 4));
        spinnerPanel.add(this.numberSpinnerEv);
        spinnerPanel.add(this.framenewevbutton);
        spinnerPanel.add(this.frameeditevbutton);
        JPanel evNamePanel = new JPanel();
        this.ndEvNameLabel = new JLabel("");
        evNamePanel.add(this.ndEvNameLabel);
        pageStartPanel.add(spinnerPanel);
        pageStartPanel.add(evNamePanel);
        pageStartPanel.add(buttonPanel);
        pageStartPanel.add(new JSeparator(0));
        pageStartPanel.validate();
        JPanel generic = new JPanel();
        generic.setLayout(new BorderLayout());
        CbusNodeSingleEventEditTablePane genericEVTable = new CbusNodeSingleEventEditTablePane(this.singleEVModel);
        genericEVTable.initComponents(this._memo, this.mainpane);
        generic.add(genericEVTable);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("Template", null);
        this.tabbedPane.addTab("Generic", generic);
        this.tabbedPane.setEnabledAt(0, false);
        this.tabbedPane.setSelectedIndex(1);
        this.infoPane.add((Component)pageStartPanel, "First");
        this.infoPane.add((Component)this.tabbedPane, "Center");
        this.add(this.infoPane);
        this.setPreferredSize(new Dimension(500, 300));
        this.setResizable(true);
        ThreadingUtil.runOnGUI(() -> {
            this.pack();
            this.setVisible(true);
        });
        this.toFront();
        this.updateButtons();
        this.frameResetButton.addActionListener(e -> {
            this.singleEVModel.resetnewEVs();
            this.numberSpinnernd.setValue(Math.max(0, this._ndEv.getNn()));
            this.numberSpinnerEv.setValue(Math.max(1, this._ndEv.getEn()));
        });
        ActionListener copyEvClicked = ae -> {
            log.debug("copy button");
            this.isNewEvent = true;
            this.updateButtons();
        };
        this.frameCopyButton.addActionListener(copyEvClicked);
        ActionListener newEvClicked = ae -> {
            this.busy_dialog = new BusyDialog(this, "Teaching Node", false);
            this.busy_dialog.start();
            ThreadingUtil.runOnLayout(() -> this.singleEVModel.passNewEvToNode(this));
        };
        this.framenewevbutton.addActionListener(newEvClicked);
        ActionListener deleteClicked = ae -> {
            if (this._node == null) {
                return;
            }
            int response = JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("NdDelEvConfrm", new CbusNameService(this._memo).getEventNodeString(this._ndEv.getNn(), this._ndEv.getEn()), this._node), Bundle.getMessage("DelEvPopTitle"), 0, 0);
            if (response == 0) {
                this.busy_dialog = new BusyDialog(this, "Deleting Event", false);
                this.busy_dialog.start();
                ThreadingUtil.runOnLayout(() -> this._node.getNodeEventManager().deleteEvOnNode(this._ndEv.getNn(), this._ndEv.getEn()));
            }
        };
        this.framedeletebutton.addActionListener(deleteClicked);
        ActionListener editEvClicked = ae -> {
            this.busy_dialog = new BusyDialog(this, "Teaching Node", false);
            this.busy_dialog.start();
            ThreadingUtil.runOnLayout(() -> this.singleEVModel.passEditEvToNode(this));
        };
        this.frameeditevbutton.addActionListener(editEvClicked);
        this.numberSpinnerEv.addChangeListener(e -> this.updateButtons());
        this.numberSpinnernd.addChangeListener(e -> this.updateButtons());
    }

    public boolean spinnersDirty() {
        return this._ndEv.getNn() != this.getNodeVal() || this._ndEv.getEn() != this.getEventVal();
    }

    private void notifyLearnEvoutcome(String message) {
        this._ndEv.setNn(this.getNodeVal());
        this._ndEv.setEn(this.getEventVal());
        this._ndEv.setEvArr(Arrays.copyOf(this.singleEVModel.newEVs, this.singleEVModel.newEVs.length));
        this.singleEVModel.fireTableDataChanged();
        this.updateButtons();
        this.busy_dialog.finish();
        this.busy_dialog = null;
        if (!message.isEmpty()) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("NdEvVarWriteError"), Bundle.getMessage("WarningTitle"), 0);
        }
    }

    private void notifyDeleteEvoutcome(String message) {
        this.busy_dialog.finish();
        this.busy_dialog = null;
        this.updateButtons();
        if (!message.isEmpty()) {
            JmriJOptionPane.showMessageDialog(this, message, Bundle.getMessage("WarningTitle"), 0);
        }
        this.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if (ev.getPropertyName().equals("DELETEEVCOMPLETE")) {
            ThreadingUtil.runOnGUIEventually(() -> this.notifyDeleteEvoutcome(ev.getNewValue().toString()));
        }
        if (ev.getPropertyName().equals("ADDEVCOMPLETE")) {
            ThreadingUtil.runOnGUIEventually(() -> this.notifyLearnEvoutcome(ev.getNewValue().toString()));
        }
    }

    private void updateButtons() {
        this.setTitle(this.getTitle());
        this.ndEvNameLabel.setText("<html><div style='text-align: center;'>" + new CbusNameService(this._memo).getEventNodeString(this.getNodeVal(), this.getEventVal()) + "</div></html>");
        this.frameResetButton.setEnabled(this.singleEVModel.isTableDirty() || this.spinnersDirty());
        if (this._node == null) {
            return;
        }
        this.framenewevbutton.setVisible(this.isNewEvent);
        this.frameeditevbutton.setVisible(!this.isNewEvent);
        this.framedeletebutton.setVisible(!this.isNewEvent);
        this.frameCopyButton.setVisible(!this.isNewEvent);
        if (this.isNewEvent) {
            if (this._node.getNodeEventManager().getNodeEvent(this.getNodeVal(), this.getEventVal()) == null) {
                this.framenewevbutton.setEnabled(true);
                this.framenewevbutton.setToolTipText(null);
            } else {
                this.framenewevbutton.setEnabled(false);
                this.framenewevbutton.setToolTipText("Event Already on Node");
            }
        } else {
            if (this.spinnersDirty() || this.singleEVModel.isTableDirty()) {
                if (this._node.getNodeEventManager().getNodeEvent(this.getNodeVal(), this.getEventVal()) == null) {
                    this.frameeditevbutton.setEnabled(true);
                    this.frameeditevbutton.setToolTipText(null);
                } else if (this.spinnersDirty()) {
                    this.frameeditevbutton.setEnabled(false);
                    this.frameeditevbutton.setToolTipText("Event Already on Node");
                } else {
                    this.frameeditevbutton.setEnabled(true);
                    this.frameeditevbutton.setToolTipText(null);
                }
            } else {
                this.frameeditevbutton.setEnabled(false);
                this.frameeditevbutton.setToolTipText(null);
            }
            if (this.spinnersDirty()) {
                this.framedeletebutton.setEnabled(false);
                this.framedeletebutton.setToolTipText("Cannot Delete an edited event or node number");
            } else {
                this.framedeletebutton.setEnabled(true);
                this.framedeletebutton.setToolTipText(null);
            }
        }
    }

    public int getEventVal() {
        return (Integer)this.numberSpinnerEv.getValue();
    }

    public int getNodeVal() {
        return (Integer)this.numberSpinnernd.getValue();
    }

    @Override
    public String getTitle() {
        if (this.nodeModel == null) {
            return Bundle.getMessage("NewEvent");
        }
        if (this._node != null) {
            StringBuilder title = new StringBuilder();
            if (this.isNewEvent) {
                title.append(Bundle.getMessage("NewEvent")).append(" ");
            } else {
                title.append(Bundle.getMessage("EditEvent")).append(new CbusNameService(this._memo).getEventNodeString(this._ndEv.getNn(), this._ndEv.getEn()));
            }
            title.append("on ").append(Bundle.getMessage("CbusNode")).append(this._node);
            return title.toString();
        }
        return Bundle.getMessage("NewEvent");
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.updateButtons();
    }

    @Override
    public void dispose() {
        if (this._node != null) {
            this._node.removePropertyChangeListener(this);
        }
        if (this.mainpane != null) {
            this.mainpane.clearEditEventFrame();
        }
        super.dispose();
    }
}

