/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.nodeconfig;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeNVTableDataModel;
import jmri.jmrix.can.cbus.swing.modules.CbusConfigPaneProvider;
import jmri.jmrix.can.cbus.swing.modules.UnknownPaneProvider;
import jmri.jmrix.can.cbus.swing.nodeconfig.Bundle;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeConfigTab;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeNVEditGuiPane;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeNVEditTablePane;
import jmri.jmrix.can.cbus.swing.nodeconfig.NodeConfigToolPane;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusNodeEditNVarPane
extends CbusNodeConfigTab
implements TableModelListener {
    private JTabbedPane tabbedPane;
    private JPanel infoPane;
    private CbusNodeNVTableDataModel nodeNVModel;
    private JButton saveNvButton;
    private JToggleButton liveUpdateNvButton;
    private JButton resetNvButton;
    private JPanel buttonPane;
    private CbusNodeNVEditTablePane genericNVTable;
    private CbusNodeNVEditGuiPane editNVGui;
    private CbusConfigPaneProvider provider;
    private static final int GENERIC = 0;
    private static final int EDIT = 1;
    private static final Logger log = LoggerFactory.getLogger(CbusNodeEditNVarPane.class);

    protected CbusNodeEditNVarPane(NodeConfigToolPane main) {
        super(main);
        this.buildPane();
    }

    @Override
    public String getTitle() {
        return "Node Variables";
    }

    private void buildPane() {
        this.nodeNVModel = new CbusNodeNVTableDataModel(this.memo, 5, 8);
        this.nodeNVModel.addTableModelListener(this);
        this.infoPane = new JPanel();
        this.infoPane.setLayout(new BorderLayout());
        this.saveNvButton = new JButton(Bundle.getMessage("ButtonSave"));
        this.saveNvButton.setToolTipText(Bundle.getMessage("SaveNvButtonTt"));
        this.liveUpdateNvButton = new JToggleButton(Bundle.getMessage("LiveUpdateNode"));
        this.liveUpdateNvButton.setToolTipText(Bundle.getMessage("LiveUpdateNodeTt"));
        this.resetNvButton = new JButton(Bundle.getMessage("Reset"));
        this.resetNvButton.setToolTipText(Bundle.getMessage("ResetTt"));
        ActionListener reset = ae -> this.cancelOption();
        this.resetNvButton.addActionListener(reset);
        ActionListener save = ae -> this.saveOption();
        this.saveNvButton.addActionListener(save);
        ActionListener liveUpdate = ae -> this.liveUpdateOption();
        this.liveUpdateNvButton.addActionListener(liveUpdate);
        this.buttonPane = new JPanel();
        this.buttonPane.add(this.liveUpdateNvButton);
        this.buttonPane.add(this.saveNvButton);
        this.buttonPane.add(this.resetNvButton);
        this.infoPane.setLayout(new BorderLayout());
        JPanel nvMenuPane = new JPanel();
        nvMenuPane.add(this.buttonPane);
        nvMenuPane.add(new JSeparator(0));
        this.genericNVTable = new CbusNodeNVEditTablePane(this.nodeNVModel);
        this.genericNVTable.initComponents(this.memo);
        this.editNVGui = new CbusNodeNVEditGuiPane(this.nodeNVModel);
        this.editNVGui.initComponents(this.memo);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("Generic", this.genericNVTable);
        this.tabbedPane.addTab("Edit", this.editNVGui);
        this.tabbedPane.setEnabledAt(1, false);
        this.tabbedPane.setSelectedIndex(0);
        this.infoPane.add((Component)nvMenuPane, "First");
        this.infoPane.add((Component)this.tabbedPane, "Center");
        this.add(this.infoPane);
    }

    protected void liveUpdateOption() {
        if (this.liveUpdateNvButton.isSelected() && this.areNvsDirty()) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("LiveUpdateVeto"), this.nodeOfInterest.toString(), 0);
            this.liveUpdateNvButton.setSelected(false);
            return;
        }
        this.nodeOfInterest.setliveUpdate(this.liveUpdateNvButton.isSelected());
    }

    @Override
    protected void saveOption() {
        this.getMainPane().showConfirmThenSave(this.nodeNVModel.getChangedNode(), this.nodeOfInterest, true, false, false, null);
    }

    @Override
    public void changedNode(CbusNode node) {
        log.debug("setnode {}", (Object)this.nodeOfInterest);
        this.nodeNVModel.setNode(this.nodeOfInterest);
        this.setSaveCancelButtonsActive(false);
        if (this.nodeOfInterest.getnvWriteInLearnOnly()) {
            this.liveUpdateNvButton.setVisible(true);
            this.liveUpdateNvButton.setEnabled(true);
        } else {
            this.liveUpdateNvButton.setVisible(false);
            this.liveUpdateNvButton.setEnabled(false);
        }
        this.genericNVTable.setNode(this.nodeOfInterest);
        this.provider = CbusConfigPaneProvider.getProviderByNode(this.nodeOfInterest);
        this.editNVGui.setNode(this.nodeOfInterest, this.provider);
        if (!(this.provider instanceof UnknownPaneProvider)) {
            this.tabbedPane.setEnabledAt(1, true);
            this.tabbedPane.setSelectedIndex(1);
        } else {
            this.tabbedPane.setEnabledAt(1, false);
            this.tabbedPane.setSelectedIndex(0);
        }
        this.validate();
        this.repaint();
        this.setVisible(true);
    }

    public boolean areNvsDirty() {
        log.debug("Table Dirty {}", (Object)this.nodeNVModel.isTableDirty());
        return this.nodeNVModel.isTableDirty();
    }

    @Override
    protected void cancelOption() {
        this.nodeNVModel.resetNewNvs();
        this.editNVGui.setNode(this.nodeOfInterest);
    }

    public void setSaveCancelButtonsActive(boolean newstate) {
        this.saveNvButton.setEnabled(newstate);
        this.resetNvButton.setEnabled(newstate);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.setSaveCancelButtonsActive(this.nodeNVModel.isTableDirty());
        this.editNVGui.tableChanged(e);
    }

    @Override
    protected boolean getVetoBeingChanged() {
        if (this.areNvsDirty()) {
            return this.getCancelSaveEditDialog(Bundle.getMessage("NvsEditUnsaved", this.nodeOfInterest));
        }
        return false;
    }

    @Override
    public void dispose() {
        if (this.nodeNVModel != null) {
            this.nodeNVModel.removeTableModelListener(this);
            this.nodeNVModel.dispose();
        }
        this.editNVGui.dispose();
    }
}

