/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.nodeconfig;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JPanel;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeEvent;
import jmri.jmrix.can.cbus.node.CbusNodeEventTableDataModel;
import jmri.jmrix.can.cbus.swing.nodeconfig.Bundle;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeConfigTab;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeEventTablePane;
import jmri.jmrix.can.cbus.swing.nodeconfig.NodeConfigToolPane;

public class CbusNodeEventVarPane
extends CbusNodeConfigTab {
    private CbusNodeEventTableDataModel nodeEvModel;
    private JButton newEvButton;
    private CbusNodeEventTablePane genericEvTable;

    protected CbusNodeEventVarPane(NodeConfigToolPane main) {
        super(main);
        this.initPane();
    }

    @Override
    public String getTitle() {
        return "Node Events";
    }

    @Override
    protected void disposeOfNode(CbusNode node) {
        super.disposeOfNode(node);
        this.nodeEvModel.dispose();
    }

    @Override
    public void changedNode(CbusNode node) {
        this.genericEvTable.setNode(node);
        this.nodeEvModel.fireTableDataChanged();
        this.newEvButton.setEnabled(this.nodeOfInterest.getNodeParamManager().getParameter(5) > -1);
        this.validate();
        this.repaint();
    }

    private void initPane() {
        JPanel evMenuPane = new JPanel();
        this.newEvButton = new JButton(Bundle.getMessage("AddNodeEvent"));
        this.newEvButton.setToolTipText(Bundle.getMessage("AddNodeEventTip"));
        this.addButtonListener(this.newEvButton);
        evMenuPane.add(this.newEvButton);
        this.nodeEvModel = new CbusNodeEventTableDataModel(this.getMainPane(), this.memo, 10, 7);
        this.genericEvTable = new CbusNodeEventTablePane(this.nodeEvModel);
        this.genericEvTable.initComponents(this.memo);
        this.genericEvTable.setVisible(true);
        this.add((Component)evMenuPane, "First");
        this.add((Component)this.genericEvTable, "Center");
    }

    private void addButtonListener(JButton button) {
        ActionListener newEvButtonClicked = ae -> {
            CbusNodeEvent newevent = new CbusNodeEvent(this.memo, -1, -1, this.nodeOfInterest.getNodeNumber(), -1, this.nodeOfInterest.getNodeParamManager().getParameter(5));
            Arrays.fill(newevent.getEvVarArray(), 0);
            this.getMainPane().getEditEvFrame().initComponents(this.memo, newevent);
        };
        button.addActionListener(newEvButtonClicked);
    }
}

