/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.nodeconfig;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeConstants;
import jmri.jmrix.can.cbus.node.CbusNodeParameterManager;
import jmri.jmrix.can.cbus.swing.nodeconfig.Bundle;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeConfigTab;
import jmri.jmrix.can.cbus.swing.nodeconfig.NodeConfigToolPane;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusNodeInfoPane
extends CbusNodeConfigTab {
    private JButton nodesupportlinkbutton;
    private URI supportlink;
    private JLabel header;
    private JPanel menuPane;
    protected JTextArea textArea;
    private CbusNodeParameterManager paramMgr;
    private JScrollPane textAreaPanel;
    private JPanel paneToDisplay;
    private static final Logger log = LoggerFactory.getLogger(CbusNodeInfoPane.class);

    public CbusNodeInfoPane(NodeConfigToolPane main) {
        super(main);
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        ThreadingUtil.runOnGUIEventually(() -> this.paramsHaveUpdated());
    }

    @Override
    public String getTitle() {
        return Bundle.getMessage("NodeInfo");
    }

    @Override
    public void changedNode(CbusNode node) {
        if (this.paneToDisplay == null) {
            this.paneToDisplay = this.newInfoPane();
            this.add(this.paneToDisplay);
        }
        this.paramMgr = node.getNodeParamManager();
        this.paramsHaveUpdated();
        this.validate();
        this.repaint();
    }

    private JPanel newInfoPane() {
        JPanel newPane = new JPanel();
        newPane.setLayout(new BorderLayout());
        this.nodesupportlinkbutton = new JButton("");
        this.nodesupportlinkbutton.addActionListener(e -> CbusNodeInfoPane.openUri(this.supportlink));
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setMargin(new Insets(10, 10, 10, 10));
        this.textAreaPanel = new JScrollPane(this.textArea);
        this.header = new JLabel("");
        this.menuPane = new JPanel();
        this.menuPane.add(this.header);
        this.menuPane.add(this.nodesupportlinkbutton);
        newPane.add((Component)this.menuPane, "First");
        newPane.add((Component)this.textAreaPanel, "Center");
        newPane.validate();
        newPane.repaint();
        return newPane;
    }

    private void appendIfKnown(StringBuilder sb, int paramToCheck, String label) {
        if (this.paramMgr.getParameter(paramToCheck) > -1) {
            this.appendRaw(sb, String.valueOf(this.paramMgr.getParameter(paramToCheck)), label);
        }
    }

    private void appendRaw(StringBuilder sb, Object value, String label) {
        sb.append(label).append(" : ").append(value).append(System.getProperty("line.separator"));
    }

    private void setHeaderText() {
        StringBuilder buildheader = new StringBuilder();
        buildheader.append("<html><h3>");
        buildheader.append(CbusNodeConstants.getManu(this.paramMgr.getParameter(1)));
        buildheader.append(" ");
        buildheader.append(this.nodeOfInterest.getNodeStats().getNodeTypeName());
        buildheader.append("</h3></html>");
        this.header.setText(buildheader.toString());
    }

    private void paramsHaveUpdated() {
        this.updateSupportButton();
        this.setHeaderText();
        StringBuilder textAreaString = new StringBuilder();
        this.appendRaw(textAreaString, this.nodeOfInterest.getNodeNumber(), Bundle.getMessage("NodeNumberTitle"));
        this.appendNodeTypeInfo(textAreaString);
        this.appendIfKnown(textAreaString, 6, Bundle.getMessage("NodeVariables"));
        this.appendIfKnown(textAreaString, 0, "Parameters");
        if (this.nodeOfInterest.getNodeEventManager().getTotalNodeEvents() > -1) {
            this.appendRaw(textAreaString, this.nodeOfInterest.getNodeEventManager().getTotalNodeEvents(), "Current Events");
        }
        this.appendIfKnown(textAreaString, 4, "Max Events");
        this.appendIfKnown(textAreaString, 5, "Max Event Variables per Event");
        if (this.paramMgr.getParameter(0) > 9 && this.paramMgr.getParameter(10) > 0) {
            textAreaString.append(CbusNodeConstants.getBusType(this.paramMgr.getParameter(10)));
            textAreaString.append(" ");
            textAreaString.append(Bundle.getMessage("BusType"));
            textAreaString.append(System.getProperty("line.separator"));
        }
        this.appendRaw(textAreaString, Math.max(0, this.nodeOfInterest.getNodeStats().totalNodeBytes()), "Current Node Data Bytes");
        this.addBackupInfo(textAreaString);
        this.appendRaw(textAreaString, this.nodeOfInterest.getsendsWRACKonNVSET(), "Sends WRACK Following NV Set");
        this.appendAllParams(textAreaString);
        if (!this.textArea.getText().equals(textAreaString.toString())) {
            this.textArea.setText(textAreaString.toString());
            this.textArea.setCaretPosition(0);
        }
    }

    private void appendNodeTypeInfo(StringBuilder sb) {
        if (this.paramMgr.getParameter(1) > -1 && this.paramMgr.getParameter(3) > -1) {
            sb.append(Bundle.getMessage("ManufacturerType", this.paramMgr.getParameter(1), CbusNodeConstants.getManu(this.paramMgr.getParameter(1)), this.paramMgr.getParameter(3)));
            sb.append(System.getProperty("line.separator"));
        }
        if (!this.nodeOfInterest.getNodeStats().getNodeTypeName().isEmpty()) {
            sb.append(Bundle.getMessage("IdentifiesAs", this.nodeOfInterest.getNodeStats().getNodeTypeName(), CbusNodeConstants.getModuleTypeExtra(this.paramMgr.getParameter(1), this.paramMgr.getParameter(3))));
            sb.append(System.getProperty("line.separator"));
        }
        this.appendFirmware(sb);
    }

    private void appendFirmware(StringBuilder sb) {
        if (this.paramMgr.getParameter(2) > 0 && this.paramMgr.getParameter(7) > 0) {
            sb.append(Bundle.getMessage("FirmwareVer", this.paramMgr.getParameter(7), Character.toString((char)this.paramMgr.getParameter(2))));
            if (this.paramMgr.getParameter(0) > 19 && this.paramMgr.getParameter(20) > 0) {
                sb.append(Bundle.getMessage("FWBeta"));
                sb.append(this.paramMgr.getParameter(20));
            }
            sb.append(System.getProperty("line.separator"));
        }
    }

    private void addBackupInfo(StringBuilder sb) {
        sb.append(System.getProperty("line.separator"));
        this.appendRaw(sb, this.nodeOfInterest.getNodeBackupManager().getBackups().size(), "Entries in Node xml file");
        this.appendRaw(sb, this.nodeOfInterest.getNodeBackupManager().getNumCompleteBackups(), "Num Backups in Node xml file");
        if (this.nodeOfInterest.getNodeBackupManager().getNumCompleteBackups() > 0) {
            this.appendRaw(sb, this.nodeOfInterest.getNodeBackupManager().getFirstBackupTime(), "First entry");
            this.appendRaw(sb, this.nodeOfInterest.getNodeBackupManager().getLastBackupTime(), "Last entry");
        }
    }

    private void appendAllParams(StringBuilder sb) {
        if (!this.paramMgr.getParameterHexString().isEmpty()) {
            sb.append(System.getProperty("line.separator"));
            sb.append("Parameter Hex String : ");
            sb.append(this.paramMgr.getParameterHexString());
            sb.append(System.getProperty("line.separator"));
        }
        sb.append(System.getProperty("line.separator"));
        for (int i = 1; i <= this.paramMgr.getParameter(0); ++i) {
            if (this.paramMgr.getParameter(i) <= -1) continue;
            sb.append("Parameter ");
            sb.append(i);
            sb.append(" : ");
            sb.append(this.paramMgr.getParameter(i));
            sb.append(" (dec)");
            sb.append(System.getProperty("line.separator"));
        }
    }

    private void updateSupportButton() {
        String supportLinkStr = CbusNodeConstants.getModuleSupportLink(this.paramMgr.getParameter(1), this.paramMgr.getParameter(3));
        if (!supportLinkStr.isEmpty()) {
            this.nodesupportlinkbutton.setText(supportLinkStr);
            this.nodesupportlinkbutton.setToolTipText("<html>" + CbusNodeConstants.getManu(this.paramMgr.getParameter(1)) + " " + CbusNodeConstants.getModuleType(this.paramMgr.getParameter(1), this.paramMgr.getParameter(3)) + " " + Bundle.getMessage("Support") + "</html>");
            try {
                this.supportlink = new URI(supportLinkStr);
                this.nodesupportlinkbutton.setVisible(true);
                return;
            }
            catch (URISyntaxException ex) {
                log.warn("Unable to create support link URI for module type {}", (Object)this.paramMgr.getParameter(3), (Object)ex);
            }
        }
        this.nodesupportlinkbutton.setVisible(false);
    }

    private static void openUri(URI uri) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(uri);
            }
            catch (IOException e) {
                log.warn("Unable to get URI for {}", (Object)uri, (Object)e);
            }
        }
    }
}

