/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.nodeconfig;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeNVTableDataModel;
import jmri.jmrix.can.swing.CanPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CbusNodeNVEditTablePane
extends CanPanel {
    private final CbusNodeNVTableDataModel nodeNVModel;
    private int largerFont;
    private final JTable nodeNvTable;
    private JScrollPane eventVarScroll;
    private JPanel pane1;
    private boolean _editable = true;
    public static final Color WHITE_GREEN = new Color(245, 245, 245);
    private static final Logger log = LoggerFactory.getLogger(CbusNodeNVEditTablePane.class);

    protected CbusNodeNVEditTablePane(CbusNodeNVTableDataModel nVModel) {
        this.nodeNVModel = nVModel;
        this.nodeNvTable = new JTable(this.nodeNVModel);
    }

    protected void setNode(CbusNode node) {
        if (this.pane1 == null) {
            this.initTable();
        }
        CbusNode nodeOfInterest = node;
        this.nodeNVModel.setNode(nodeOfInterest);
        this.pane1.setVisible(node != null);
    }

    private void initTable() {
        this.pane1 = new JPanel();
        TableColumnModel tableModel = this.nodeNvTable.getColumnModel();
        this.nodeNvTable.createDefaultColumnsFromModel();
        this.nodeNvTable.setRowSelectionAllowed(true);
        this.nodeNvTable.setColumnSelectionAllowed(false);
        this.nodeNvTable.setSelectionMode(1);
        this.nodeNvTable.getTableHeader().setReorderingAllowed(true);
        this.nodeNvTable.setRowHeight(27);
        tableModel.getColumn(0).setCellRenderer(this.getRenderer());
        tableModel.getColumn(2).setCellRenderer(this.getRenderer());
        tableModel.getColumn(3).setCellRenderer(this.getRenderer());
        tableModel.getColumn(4).setCellRenderer(this.getRenderer());
        log.debug("_editable : {} , tot column {}", (Object)this._editable, (Object)this.nodeNVModel.getColumnCount());
        if (this._editable) {
            tableModel.getColumn(5).setCellRenderer(new SpinnerRenderer());
            tableModel.getColumn(5).setCellEditor(new NvSpinnerEditor());
            tableModel.getColumn(6).setCellRenderer(this.getRenderer());
            tableModel.getColumn(7).setCellRenderer(this.getRenderer());
        } else {
            tableModel.getColumn(5).setMinWidth(0);
            tableModel.getColumn(5).setMaxWidth(0);
            tableModel.getColumn(5).setWidth(0);
            tableModel.getColumn(6).setMinWidth(0);
            tableModel.getColumn(6).setMaxWidth(0);
            tableModel.getColumn(6).setWidth(0);
            tableModel.getColumn(7).setMinWidth(0);
            tableModel.getColumn(7).setMaxWidth(0);
            tableModel.getColumn(7).setWidth(0);
        }
        this.largerFont = new JTextField().getFont().getSize() + 2;
        this.setLayout(new BorderLayout());
        this.pane1.setLayout(new BorderLayout());
        this.eventVarScroll = new JScrollPane(this.nodeNvTable);
        this.pane1.add(this.eventVarScroll);
        this.add(this.pane1);
        this.pane1.setVisible(true);
        this.nodeNvTable.setAutoCreateColumnsFromModel(false);
        this.add(this.eventVarScroll);
    }

    protected void setNonEditable() {
        this._editable = false;
    }

    private TableCellRenderer getRenderer() {
        return new TableCellRenderer(){
            JTextField f = new JTextField();

            @Override
            public Component getTableCellRendererComponent(JTable table, Object arg1, boolean isSelected, boolean hasFocus, int row, int col) {
                this.f.setHorizontalAlignment(0);
                this.f.setBorder(table.getBorder());
                int tablecol = CbusNodeNVEditTablePane.this.nodeNvTable.convertColumnIndexToModel(col);
                if (tablecol == 0) {
                    this.f.setFont(this.f.getFont().deriveFont(1, CbusNodeNVEditTablePane.this.largerFont));
                }
                int oldval = (Integer)CbusNodeNVEditTablePane.this.nodeNVModel.getValueAt(row, 2);
                int newval = (Integer)CbusNodeNVEditTablePane.this.nodeNVModel.getValueAt(row, 5);
                if (arg1 != null) {
                    String string = arg1.toString();
                    try {
                        if (Integer.parseInt(string) < 0) {
                            string = "";
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    this.f.setText(string.toUpperCase());
                } else {
                    this.f.setText("");
                }
                if ((tablecol == 6 || tablecol == 7) && oldval == newval) {
                    this.f.setText("");
                }
                if (isSelected) {
                    if (oldval != newval) {
                        this.f.setBackground(Color.orange);
                    } else {
                        this.f.setBackground(table.getSelectionBackground());
                    }
                } else if (oldval != newval) {
                    this.f.setBackground(Color.yellow);
                } else if (row % 2 == 0) {
                    this.f.setBackground(table.getBackground());
                } else {
                    this.f.setBackground(WHITE_GREEN);
                }
                return this.f;
            }
        };
    }

    protected static class SpinnerRenderer
    extends JSpinner
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setModel(new SpinnerNumberModel((Integer)value, -1, 255, 1));
            this.setEnabled((Integer)value > -1);
            this.setOpaque(true);
            this.setBorder(null);
            return this;
        }
    }

    protected static class NvSpinnerEditor
    extends AbstractCellEditor
    implements ChangeListener,
    TableCellEditor {
        final JSpinner spinner = new JSpinner(new SpinnerNumberModel(0, 0, 255, 1));

        public NvSpinnerEditor() {
            this.init();
        }

        final void init() {
            this.spinner.addChangeListener(this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.spinner.setValue(value);
            this.spinner.setBorder(null);
            return this.spinner;
        }

        @Override
        public boolean isCellEditable(EventObject evt) {
            if (evt instanceof MouseEvent) {
                return ((MouseEvent)evt).getClickCount() >= 1;
            }
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            return this.spinner.getValue();
        }

        @Override
        public void stateChanged(ChangeEvent eve) {
            this.stopCellEditing();
        }
    }
}

