/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.nodeconfig;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jmri.jmrit.XmlFile;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.cbus.eventtable.CbusEventTableDataModel;
import jmri.jmrix.can.cbus.eventtable.CbusTableEvent;
import jmri.jmrix.can.cbus.node.CbusNode;
import jmri.jmrix.can.cbus.node.CbusNodeEvent;
import jmri.jmrix.can.cbus.node.CbusNodeEventTableDataModel;
import jmri.jmrix.can.cbus.node.CbusNodeFromBackup;
import jmri.jmrix.can.cbus.node.CbusNodeFromFcuTableDataModel;
import jmri.jmrix.can.cbus.node.CbusNodeNVTableDataModel;
import jmri.jmrix.can.cbus.node.CbusNodeTableDataModel;
import jmri.jmrix.can.cbus.swing.nodeconfig.Bundle;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeEventTablePane;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeFcuTablePane;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeInfoPane;
import jmri.jmrix.can.cbus.swing.nodeconfig.CbusNodeNVEditTablePane;
import jmri.jmrix.can.cbus.swing.nodeconfig.NodeConfigToolPane;
import jmri.util.JmriJFrame;
import jmri.util.StringUtil;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CbusNodeRestoreFcuFrame
extends JmriJFrame {
    private CbusNodeFromFcuTableDataModel cbusNodeFcuDataModel;
    private JTabbedPane tabbedPane;
    private CbusNodeTableDataModel nodeModel;
    private CanSystemConnectionMemo _memo;
    private final NodeConfigToolPane mainpane;
    private CbusNodeNVEditTablePane nodevarPane;
    private CbusNodeEventTablePane nodeEventPane;
    private JSplitPane split;
    private CbusNodeInfoPane nodeinfoPane;
    private JTable nodeTable;
    private JButton openFCUButton;
    private JButton nodeToBeTaughtButton;
    private JLabel fileLocationDisplayLabel;
    private JLabel eventTableRunningLabel;
    private final JList<String> nodeToTeachTolist;
    private JCheckBox teachNvsCheckBox;
    private JCheckBox teachEventsCheckBox;
    private JCheckBox resetEventsBeforeTeach;
    private final PropertyChangeListener memoListener = this::updateEventTableActive;
    private final TableModelListener nodeModelListener = this::updateNodeToTeachList;
    private static JFileChooser chooser;
    private static final Logger log;

    public CbusNodeRestoreFcuFrame(NodeConfigToolPane main) {
        this.mainpane = main;
        this.nodeToTeachTolist = new JList();
    }

    public void initComponents(@Nonnull CanSystemConnectionMemo memo) {
        this._memo = memo;
        this.cbusNodeFcuDataModel = new CbusNodeFromFcuTableDataModel(this._memo, 2, 6);
        this.nodeModel = memo.get(CbusNodeTableDataModel.class);
        this.initMainPane();
        this.nodeModel.addTableModelListener(this.nodeModelListener);
        this._memo.addPropertyChangeListener(this.memoListener);
    }

    private void initMainPane() {
        this.mainpane.setRestoreFcuActive(true);
        JPanel infoPane = new JPanel();
        infoPane.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        JPanel selectFilePanel = new JPanel();
        this.openFCUButton = new JButton(Bundle.getMessage("SelectFcuFile"));
        selectFilePanel.add(this.openFCUButton);
        this.fileLocationDisplayLabel = new JLabel();
        selectFilePanel.add(this.fileLocationDisplayLabel);
        topPanel.add(selectFilePanel);
        JPanel eventTableRunningPanel = new JPanel();
        this.eventTableRunningLabel = new JLabel();
        this.updateEventTableActive(null);
        eventTableRunningPanel.add(this.eventTableRunningLabel);
        topPanel.add(eventTableRunningPanel);
        infoPane.add((Component)topPanel, "First");
        infoPane.add((Component)this.getMiddlePane(), "Center");
        infoPane.add((Component)this.getNodeToBeTaughtButtonPane(), "Last");
        this.add(infoPane);
        ThreadingUtil.runOnGUI(this::pack);
        this.setResizable(true);
        this.validate();
        this.repaint();
        this.setTitle(this.getTitle());
        ThreadingUtil.runOnGUI(() -> this.setVisible(true));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                CbusNodeRestoreFcuFrame.this.mainpane.setRestoreFcuActive(false);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                CbusNodeRestoreFcuFrame.this.mainpane.setRestoreFcuActive(false);
            }
        });
        ActionListener save = ae -> {
            CbusNode fromNode = this.nodeFromSelectedRow();
            CbusNode toNode = this.nodeFromSelectedList();
            if (fromNode == null || toNode == null) {
                return;
            }
            this.mainpane.showConfirmThenSave(fromNode, toNode, this.teachNvsCheckBox.isSelected(), this.resetEventsBeforeTeach.isSelected(), this.teachEventsCheckBox.isSelected(), this);
        };
        this.nodeToBeTaughtButton.addActionListener(save);
        this.openFCUButton.addActionListener(this::selectInputFile);
        this.nodeTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.updateTabs();
                this.updateRestoreNodeButton();
            }
        });
        this.nodeToTeachTolist.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.updateRestoreNodeButton();
            }
        });
        this.updateRestoreNodeButton();
    }

    private JSplitPane getMiddlePane() {
        CbusNodeFcuTablePane fcuTablePane = new CbusNodeFcuTablePane();
        fcuTablePane.initComponents(this._memo, this.cbusNodeFcuDataModel);
        this.nodeTable = fcuTablePane.nodeTable;
        JPanel fcuPane = new JPanel();
        fcuPane.setLayout(new BoxLayout(fcuPane, 1));
        fcuPane.setPreferredSize(new Dimension(200, 150));
        fcuPane.add(fcuTablePane);
        this.tabbedPane = new JTabbedPane();
        this.nodeinfoPane = new CbusNodeInfoPane(null);
        CbusNodeNVTableDataModel nodeNVModel = new CbusNodeNVTableDataModel(this._memo, 5, 8);
        this.nodevarPane = new CbusNodeNVEditTablePane(nodeNVModel);
        this.nodevarPane.setNonEditable();
        CbusNodeEventTableDataModel nodeEvModel = new CbusNodeEventTableDataModel(null, this._memo, 10, 7);
        this.nodeEventPane = new CbusNodeEventTablePane(nodeEvModel);
        this.nodeEventPane.setHideEditButton();
        this.nodeEventPane.initComponents(this._memo);
        this.tabbedPane.addTab(Bundle.getMessage("NodeInfo"), this.nodeinfoPane);
        this.tabbedPane.addTab(Bundle.getMessage("NodeVariables"), this.nodevarPane);
        this.tabbedPane.addTab(Bundle.getMessage("NodeEvents"), this.nodeEventPane);
        this.tabbedPane.addChangeListener(e -> this.updateTabs());
        this.split = new JSplitPane(0, fcuPane, this.tabbedPane);
        this.split.setContinuousLayout(true);
        return this.split;
    }

    private JPanel getNodeToBeTaughtButtonPane() {
        JPanel nodeToBeTaughtButtonPane = new JPanel();
        nodeToBeTaughtButtonPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("ChooseNodeToTeach")));
        JPanel nodeToBeTaughtPane = new JPanel();
        nodeToBeTaughtPane.setLayout(new BoxLayout(nodeToBeTaughtPane, 1));
        this.updateNodeToTeachList(null);
        this.nodeToTeachTolist.setLayoutOrientation(0);
        this.nodeToTeachTolist.setVisibleRowCount(-1);
        this.nodeToTeachTolist.setSelectionMode(0);
        JScrollPane listScroller = new JScrollPane(this.nodeToTeachTolist);
        listScroller.setPreferredSize(new Dimension(300, 80));
        nodeToBeTaughtPane.add(listScroller);
        nodeToBeTaughtButtonPane.add(nodeToBeTaughtPane);
        JPanel nodeToBeTaughtCheckboxPane = new JPanel();
        nodeToBeTaughtCheckboxPane.setLayout(new BoxLayout(nodeToBeTaughtCheckboxPane, 1));
        this.nodeToBeTaughtButton = new JButton(Bundle.getMessage("UpdateNodeButton"));
        this.teachNvsCheckBox = new JCheckBox(Bundle.getMessage("WriteNVs"));
        this.teachEventsCheckBox = new JCheckBox(Bundle.getMessage("WriteEvents"));
        this.resetEventsBeforeTeach = new JCheckBox(Bundle.getMessage("CBUS_NNCLR"));
        this.teachNvsCheckBox.setSelected(true);
        this.teachEventsCheckBox.setSelected(true);
        this.resetEventsBeforeTeach.setSelected(true);
        nodeToBeTaughtCheckboxPane.add(this.teachNvsCheckBox);
        nodeToBeTaughtCheckboxPane.add(this.resetEventsBeforeTeach);
        nodeToBeTaughtCheckboxPane.add(this.teachEventsCheckBox);
        nodeToBeTaughtButtonPane.add(nodeToBeTaughtCheckboxPane);
        nodeToBeTaughtButtonPane.add(this.nodeToBeTaughtButton);
        return nodeToBeTaughtButtonPane;
    }

    private void updateNodeToTeachList(TableModelEvent e) {
        String before = this.nodeToTeachTolist.getSelectedValue();
        String[] data = this.nodeModel.getListOfNodeNumberNames().toArray(new String[0]);
        if (data.length == 0) {
            data = new String[]{Bundle.getMessage("NodeTableEmpty")};
        }
        this.nodeToTeachTolist.setListData((String[])data);
        this.nodeToTeachTolist.setSelectedValue(before, true);
    }

    @CheckForNull
    private CbusNode nodeFromSelectedRow() {
        int sel = this.nodeTable.getSelectedRow();
        if (sel > -1) {
            int modelIndex = this.nodeTable.convertRowIndexToModel(sel);
            int nodenum = (Integer)this.nodeTable.getModel().getValueAt(modelIndex, 0);
            return this.cbusNodeFcuDataModel.getNodeByNodeNum(nodenum);
        }
        return null;
    }

    @CheckForNull
    private CbusNode nodeFromSelectedList() {
        String obj = this.nodeToTeachTolist.getSelectedValue();
        if (obj == null) {
            return null;
        }
        int targetnodenum = StringUtil.getFirstIntFromString(obj);
        return this.nodeModel.getNodeByNodeNum(targetnodenum);
    }

    private void updateTabs() {
        if (this.nodeTable.getSelectedRow() > -1) {
            switch (this.tabbedPane.getSelectedIndex()) {
                case 1: {
                    this.nodevarPane.setNode(this.nodeFromSelectedRow());
                    break;
                }
                case 2: {
                    this.nodeEventPane.setNode(this.nodeFromSelectedRow());
                    break;
                }
                default: {
                    this.nodeinfoPane.setNode(this.nodeFromSelectedRow());
                    break;
                }
            }
        } else {
            this.nodeinfoPane.setNode(null);
        }
    }

    private void updateRestoreNodeButton() {
        CbusNode nodeFrom = this.nodeFromSelectedRow();
        if (nodeFrom == null) {
            this.nodeToBeTaughtButton.setEnabled(false);
            this.nodeToBeTaughtButton.setToolTipText("Select a Node from file in top table");
            return;
        }
        CbusNode nodeTo = this.nodeFromSelectedList();
        if (nodeTo == null) {
            this.nodeToBeTaughtButton.setEnabled(false);
            this.nodeToBeTaughtButton.setToolTipText("Select a target Node from list on left");
            return;
        }
        if (nodeFrom.getNodeNvManager().getTotalNVs() == nodeTo.getNodeNvManager().getTotalNVs() && nodeFrom.getNodeParamManager().getParameter(5) == nodeTo.getNodeParamManager().getParameter(5)) {
            this.nodeToBeTaughtButton.setEnabled(true);
            this.nodeToBeTaughtButton.setToolTipText(null);
            return;
        }
        this.nodeToBeTaughtButton.setEnabled(false);
        this.nodeToBeTaughtButton.setToolTipText("Both nodes must have same amount of NV's");
    }

    private static void initChooser() {
        if (chooser == null) {
            chooser = XmlFile.userFileChooser("XML Files", "xml", "XML");
        }
    }

    private void selectInputFile(ActionEvent e) {
        CbusNodeRestoreFcuFrame.initChooser();
        chooser.rescanCurrentDirectory();
        int retVal = chooser.showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        File testForXml = chooser.getSelectedFile();
        if (!testForXml.getPath().toUpperCase().endsWith("XML")) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ImportNotXml"), Bundle.getMessage("WarningTitle"), 0);
            return;
        }
        this.addFile(testForXml);
    }

    protected void addFile(File inputFile) {
        this.fileLocationDisplayLabel.setText(inputFile.toString());
        try {
            this.cbusNodeFcuDataModel.resetData();
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbFactory.setXIncludeAware(false);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(inputFile);
            doc.getDocumentElement().normalize();
            this.setNodesAndNVs(doc);
            this.setEventstoNodes(doc);
        }
        catch (IOException | NumberFormatException | ParserConfigurationException | DOMException | SAXException e) {
            log.warn("Error importing xml file. Valid xml?", (Throwable)e);
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ImportError") + " Valid XML?", Bundle.getMessage("WarningTitle"), 0);
        }
    }

    private void setNodesAndNVs(@Nonnull Document doc) {
        NodeList nodeList = doc.getElementsByTagName("userNodes");
        for (int temp = 0; temp < nodeList.getLength(); ++temp) {
            Node nNode = nodeList.item(temp);
            Element eElement = (Element)nNode;
            String nodeNum = eElement.getElementsByTagName("nodeNum").item(0).getTextContent();
            String nodeName = eElement.getElementsByTagName("nodeName").item(0).getTextContent();
            String moduleIdNum = eElement.getElementsByTagName("moduleId").item(0).getTextContent();
            String moduleNvString = eElement.getElementsByTagName("NodeVars").item(0).getTextContent();
            String nodeVersion = eElement.getElementsByTagName("Version").item(0).getTextContent();
            int nodenum = Integer.parseInt(nodeNum);
            int nodetype = Integer.parseInt(moduleIdNum);
            if (nodenum <= 0) continue;
            CbusNodeFromBackup actualnode = this.cbusNodeFcuDataModel.provideNodeByNodeNum(nodenum);
            actualnode.setNameIfNoName(nodeName);
            actualnode.getNodeEventManager().resetNodeEvents();
            log.debug("node version {}", (Object)nodeVersion);
            int[] nvArray = StringUtil.intBytesWithTotalFromNonSpacedHexString(moduleNvString, true);
            int[] myarray = new int[]{7, 165, -1, nodetype, -1, -1, nvArray[0], -1};
            actualnode.getNodeParamManager().setParameters(myarray);
            if (nvArray.length <= 1) continue;
            actualnode.getNodeNvManager().setNVs(nvArray);
        }
    }

    private void setEventstoNodes(@Nonnull Document doc) {
        NodeList eventList = doc.getElementsByTagName("userEvents");
        CbusEventTableDataModel eventModel = this._memo.get(CbusEventTableDataModel.class);
        if (eventModel == null) {
            log.info("CBUS Event Table not running, no Event Names imported.");
        }
        for (int temp = 0; temp < eventList.getLength(); ++temp) {
            Node nNode = eventList.item(temp);
            Element eElement = (Element)nNode;
            String hostNodeNumString = eElement.getElementsByTagName("ownerNode").item(0).getTextContent();
            String event = eElement.getElementsByTagName("eventValue").item(0).getTextContent();
            String eventNode = eElement.getElementsByTagName("eventNode").item(0).getTextContent();
            String eventName = eElement.getElementsByTagName("eventName").item(0).getTextContent();
            String eventVars = eElement.getElementsByTagName("Values").item(0).getTextContent();
            int hostNodeNum = Integer.parseInt(hostNodeNumString);
            int eventNum = Integer.parseInt(event);
            int eventNodeNum = Integer.parseInt(eventNode);
            log.debug("event host {} event {} event node {} vars {}", new Object[]{hostNodeNum, eventNum, eventNodeNum, eventVars});
            if (hostNodeNum > 0) {
                CbusNodeFromBackup hostNode = this.cbusNodeFcuDataModel.provideNodeByNodeNum(hostNodeNum);
                int[] evVarArray = StringUtil.intBytesWithTotalFromNonSpacedHexString(eventVars, false);
                if (!eventVars.isEmpty() && hostNode.getNodeParamManager().getParameter(5) < 0) {
                    hostNode.getNodeParamManager().setParameter(5, evVarArray.length);
                }
                CbusNodeEvent ev = new CbusNodeEvent(this._memo, eventNodeNum, eventNum, hostNodeNum, -1, hostNode.getNodeParamManager().getParameter(5));
                ev.setEvArr(evVarArray);
                ev.setName(eventName);
                ev.setTempFcuNodeName(this.cbusNodeFcuDataModel.getNodeName(eventNodeNum));
                hostNode.getNodeEventManager().addNewEvent(ev);
            }
            if (eventModel == null) continue;
            CbusTableEvent ev = eventModel.provideEvent(eventNodeNum, eventNum);
            ev.setNameIfNoName(eventName);
        }
    }

    private void updateEventTableActive(PropertyChangeEvent evt) {
        CbusEventTableDataModel eventModel = this._memo.get(CbusEventTableDataModel.class);
        this.eventTableRunningLabel.setText(Bundle.getMessage(eventModel == null ? "EventTableNotRunning" : "EventsImportToTable"));
    }

    @Override
    public String getTitle() {
        return Bundle.getMessage("FcuImportTitle");
    }

    @Override
    public void dispose() {
        if (this._memo != null) {
            this._memo.removePropertyChangeListener(this.memoListener);
        }
        if (this.nodeModel != null) {
            this.nodeModel.removeTableModelListener(this.nodeModelListener);
        }
        super.dispose();
    }

    static {
        log = LoggerFactory.getLogger(CbusNodeRestoreFcuFrame.class);
    }
}

