/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.can.cbus.swing.simulator;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultFormatter;
import jmri.jmrix.can.cbus.simulator.CbusSimCanListener;
import jmri.jmrix.can.cbus.swing.simulator.Bundle;

public class DirectionPane
extends JPanel {
    private JCheckBox processIn;
    private JCheckBox processOut;
    private JCheckBox sendIn;
    private JCheckBox sendOut;
    private JSpinner delaySpinner;
    private CbusSimCanListener cbl;
    private JPanel processPane;
    private JPanel sendPane;
    private JPanel delayPane;

    public DirectionPane() {
    }

    public DirectionPane(CbusSimCanListener cbcl) {
        this.cbl = cbcl;
        this.init();
    }

    public void setSimCanListener(CbusSimCanListener cbcl) {
        this.cbl = cbcl;
        this.setWhichActive();
        this.setListeners();
    }

    private void init() {
        this.initPanes();
        this.initCheckBoxes();
        this.processPane.add(this.processIn);
        this.processPane.add(this.processOut);
        this.add(this.processPane);
        this.sendPane.add(this.sendIn);
        this.sendPane.add(this.sendOut);
        this.add(this.sendPane);
        this.delayPane.add(this.getNewJSpinner());
        this.add(this.delayPane);
        this.setWhichActive();
        this.setListeners();
    }

    private void initPanes() {
        this.processPane = new JPanel();
        this.processPane.setLayout(new BoxLayout(this.processPane, 0));
        this.processPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("Listen")));
        this.sendPane = new JPanel();
        this.sendPane.setLayout(new BoxLayout(this.sendPane, 0));
        this.sendPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("Send")));
        this.delayPane = new JPanel();
        this.delayPane.setLayout(new BoxLayout(this.delayPane, 0));
        this.delayPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Bundle.getMessage("Delay")));
    }

    private void initCheckBoxes() {
        this.processIn = new JCheckBox(Bundle.getMessage("processIn"));
        this.processOut = new JCheckBox(Bundle.getMessage("processOut"));
        this.sendIn = new JCheckBox(Bundle.getMessage("sendIn"));
        this.sendOut = new JCheckBox(Bundle.getMessage("sendOut"));
        this.processIn.setToolTipText(Bundle.getMessage("processInTip"));
        this.processOut.setToolTipText(Bundle.getMessage("processOutTip"));
        this.sendIn.setToolTipText(Bundle.getMessage("sendInTip"));
        this.sendOut.setToolTipText(Bundle.getMessage("sendOutTip"));
        this.processIn.setVisible(true);
        this.processOut.setVisible(true);
        this.sendIn.setVisible(true);
        this.sendOut.setVisible(true);
    }

    private JSpinner getNewJSpinner() {
        this.delaySpinner = new JSpinner(new SpinnerNumberModel(80, 0, 999999, 1));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.delaySpinner, "#");
        this.delaySpinner.setEditor(editor);
        JFormattedTextField fieldEv = (JFormattedTextField)editor.getComponent(0);
        DefaultFormatter formatterEv = (DefaultFormatter)fieldEv.getFormatter();
        fieldEv.setColumns(4);
        formatterEv.setCommitsOnValidEdit(true);
        this.delaySpinner.setToolTipText(Bundle.getMessage("DelayMs"));
        return this.delaySpinner;
    }

    private void setListeners() {
        if (this.cbl == null) {
            return;
        }
        this.processIn.addActionListener(e -> this.cbl.setProcessIn(this.processIn.isSelected()));
        this.processOut.addActionListener(e -> this.cbl.setProcessOut(this.processOut.isSelected()));
        this.sendIn.addActionListener(e -> this.cbl.setSendIn(this.sendIn.isSelected()));
        this.sendOut.addActionListener(e -> this.cbl.setSendOut(this.sendOut.isSelected()));
        this.delaySpinner.addChangeListener(e -> this.cbl.setDelay((Integer)this.delaySpinner.getValue()));
    }

    private void setWhichActive() {
        this.processOut.setEnabled(this.cbl != null);
        this.processIn.setEnabled(this.cbl != null);
        this.sendOut.setEnabled(this.cbl != null);
        this.sendIn.setEnabled(this.cbl != null);
        this.delaySpinner.setEnabled(this.cbl != null);
        if (this.cbl == null) {
            return;
        }
        this.processOut.setSelected(this.cbl.getProcessOut());
        this.processIn.setSelected(this.cbl.getProcessIn());
        this.sendOut.setSelected(this.cbl.getSendOut());
        this.sendIn.setSelected(this.cbl.getSendIn());
        this.delaySpinner.setValue(this.cbl.getDelay());
    }
}

